/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.CodeBlock;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineBase;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.util.LineCollectingVisitor;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlRendererOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NonRenderingInline;
import com.vladsch.flexmark.util.ast.TextCollectingVisitor;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.Range;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CoreNodeRenderer
implements NodeRenderer {
    public static final AttributablePart LOOSE_LIST_ITEM = new AttributablePart("LOOSE_LIST_ITEM");
    public static final AttributablePart TIGHT_LIST_ITEM = new AttributablePart("TIGHT_LIST_ITEM");
    public static final AttributablePart PARAGRAPH_LINE = new AttributablePart("PARAGRAPH_LINE");
    public static final AttributablePart CODE_CONTENT = new AttributablePart("FENCED_CODE_CONTENT");
    private final ListOptions listOptions;
    private final boolean obfuscateEmail;
    private final boolean obfuscateEmailRandom;
    private final ReferenceRepository referenceRepository;
    private final boolean recheckUndefinedReferences;
    private final boolean codeContentBlock;
    private final boolean codeSoftLineBreaks;
    private List<Range> myLines;
    private List<Integer> myEOLs;
    private int myNextLine;
    private int nextLineStartOffset;

    public CoreNodeRenderer(DataHolder options) {
        this.referenceRepository = Parser.REFERENCES.get(options);
        this.recheckUndefinedReferences = HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.get(options);
        this.listOptions = ListOptions.get(options);
        this.obfuscateEmail = HtmlRenderer.OBFUSCATE_EMAIL.get(options);
        this.obfuscateEmailRandom = HtmlRenderer.OBFUSCATE_EMAIL_RANDOM.get(options);
        this.codeContentBlock = Parser.FENCED_CODE_CONTENT_BLOCK.get(options);
        this.codeSoftLineBreaks = Parser.CODE_SOFT_LINE_BREAKS.get(options);
        this.myLines = null;
        this.myEOLs = null;
        this.myNextLine = 0;
        this.nextLineStartOffset = 0;
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler<AutoLink>(AutoLink.class, this::render), new NodeRenderingHandler<BlockQuote>(BlockQuote.class, this::render), new NodeRenderingHandler<BulletList>(BulletList.class, this::render), new NodeRenderingHandler<Code>(Code.class, this::render), new NodeRenderingHandler<CodeBlock>(CodeBlock.class, this::render), new NodeRenderingHandler<Document>(Document.class, this::render), new NodeRenderingHandler<Emphasis>(Emphasis.class, this::render), new NodeRenderingHandler<FencedCodeBlock>(FencedCodeBlock.class, this::render), new NodeRenderingHandler<HardLineBreak>(HardLineBreak.class, this::render), new NodeRenderingHandler<Heading>(Heading.class, this::render), new NodeRenderingHandler<HtmlBlock>(HtmlBlock.class, this::render), new NodeRenderingHandler<HtmlCommentBlock>(HtmlCommentBlock.class, this::render), new NodeRenderingHandler<HtmlInnerBlock>(HtmlInnerBlock.class, this::render), new NodeRenderingHandler<HtmlInnerBlockComment>(HtmlInnerBlockComment.class, this::render), new NodeRenderingHandler<HtmlEntity>(HtmlEntity.class, this::render), new NodeRenderingHandler<HtmlInline>(HtmlInline.class, this::render), new NodeRenderingHandler<HtmlInlineComment>(HtmlInlineComment.class, this::render), new NodeRenderingHandler<Image>(Image.class, this::render), new NodeRenderingHandler<ImageRef>(ImageRef.class, this::render), new NodeRenderingHandler<IndentedCodeBlock>(IndentedCodeBlock.class, this::render), new NodeRenderingHandler<Link>(Link.class, this::render), new NodeRenderingHandler<LinkRef>(LinkRef.class, this::render), new NodeRenderingHandler<BulletListItem>(BulletListItem.class, this::render), new NodeRenderingHandler<OrderedListItem>(OrderedListItem.class, this::render), new NodeRenderingHandler<MailLink>(MailLink.class, this::render), new NodeRenderingHandler<OrderedList>(OrderedList.class, this::render), new NodeRenderingHandler<Paragraph>(Paragraph.class, this::render), new NodeRenderingHandler<Reference>(Reference.class, this::render), new NodeRenderingHandler<SoftLineBreak>(SoftLineBreak.class, this::render), new NodeRenderingHandler<StrongEmphasis>(StrongEmphasis.class, this::render), new NodeRenderingHandler<Text>(Text.class, this::render), new NodeRenderingHandler<TextBase>(TextBase.class, this::render), new NodeRenderingHandler<ThematicBreak>(ThematicBreak.class, this::render)));
    }

    void render(Document node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
    }

    void render(Heading node, NodeRendererContext context, HtmlWriter html) {
        String id;
        if (context.getHtmlOptions().renderHeaderId && (id = context.getNodeId(node)) != null && id.length() > 0) {
            html.attr("id", id);
        }
        if (context.getHtmlOptions().sourcePositionParagraphLines) {
            html.srcPos(node.getChars()).withAttr().tagLine((CharSequence)("h" + node.getLevel()), () -> {
                html.srcPos(node.getText()).withAttr().tag("span");
                context.renderChildren(node);
                html.tag("/span");
            });
        } else {
            html.srcPos(node.getText()).withAttr().tagLine((CharSequence)("h" + node.getLevel()), () -> context.renderChildren(node));
        }
    }

    void render(BlockQuote node, NodeRendererContext context, HtmlWriter html) {
        html.withAttr().tagLineIndent("blockquote", () -> context.renderChildren(node));
    }

    void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        html.line();
        ((HtmlWriter)html.srcPosWithTrailingEOL(node.getChars()).withAttr().tag("pre")).openPre();
        BasedSequence info = node.getInfo();
        HtmlRendererOptions htmlOptions = context.getHtmlOptions();
        if (info.isNotNull() && !info.isBlank()) {
            String language = node.getInfoDelimitedByAny(htmlOptions.languageDelimiterSet).unescape();
            String languageClass = htmlOptions.languageClassMap.getOrDefault(language, htmlOptions.languageClassPrefix + language);
            html.attr("class", languageClass);
        } else {
            String noLanguageClass = htmlOptions.noLanguageClass.trim();
            if (!noLanguageClass.isEmpty()) {
                html.attr("class", noLanguageClass);
            }
        }
        html.srcPosWithEOL(node.getContentChars()).withAttr(CODE_CONTENT).tag("code");
        if (this.codeContentBlock) {
            context.renderChildren(node);
        } else {
            html.text(node.getContentChars().normalizeEOL());
        }
        html.tag("/code");
        ((HtmlWriter)html.tag("/pre")).closePre();
        html.lineIf(htmlOptions.htmlBlockCloseTagEol);
    }

    void render(ThematicBreak node, NodeRendererContext context, HtmlWriter html) {
        html.srcPos(node.getChars()).withAttr().tagVoidLine("hr");
    }

    void render(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        html.line();
        ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr().tag("pre")).openPre();
        String noLanguageClass = context.getHtmlOptions().noLanguageClass.trim();
        if (!noLanguageClass.isEmpty()) {
            html.attr("class", noLanguageClass);
        }
        html.srcPosWithEOL(node.getContentChars()).withAttr(CODE_CONTENT).tag("code");
        if (this.codeContentBlock) {
            context.renderChildren(node);
        } else {
            html.text(((BasedSequence)node.getContentChars().trimTailBlankLines()).normalizeEndWithEOL());
        }
        html.tag("/code");
        ((HtmlWriter)html.tag("/pre")).closePre();
        html.lineIf(context.getHtmlOptions().htmlBlockCloseTagEol);
    }

    void render(CodeBlock node, NodeRendererContext context, HtmlWriter html) {
        if (node.getParent() instanceof IndentedCodeBlock) {
            html.text(((BasedSequence)node.getContentChars().trimTailBlankLines()).normalizeEndWithEOL());
        } else {
            html.text(node.getContentChars().normalizeEOL());
        }
    }

    void render(BulletList node, NodeRendererContext context, HtmlWriter html) {
        html.withAttr().tagIndent("ul", () -> context.renderChildren(node));
    }

    void render(OrderedList node, NodeRendererContext context, HtmlWriter html) {
        int start2 = node.getStartNumber();
        if (this.listOptions.isOrderedListManualStart() && start2 != 1) {
            html.attr("start", String.valueOf(start2));
        }
        html.withAttr().tagIndent("ol", () -> context.renderChildren(node));
    }

    void render(BulletListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItem(node, context, html);
    }

    void render(OrderedListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItem(node, context, html);
    }

    private void renderListItem(ListItem node, NodeRendererContext context, HtmlWriter html) {
        if (this.listOptions.isTightListItem(node)) {
            ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr(TIGHT_LIST_ITEM).withCondIndent()).tagLine((CharSequence)"li", () -> {
                html.text(node.getMarkerSuffix().unescape());
                context.renderChildren(node);
            });
        } else {
            ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr(LOOSE_LIST_ITEM).withCondIndent()).tagLine((CharSequence)"li", () -> {
                html.text(node.getMarkerSuffix().unescape());
                context.renderChildren(node);
            });
        }
    }

    public void renderTextBlockParagraphLines(Paragraph node, NodeRendererContext context, HtmlWriter html, boolean wrapTextInSpan) {
        if (context.getHtmlOptions().sourcePositionParagraphLines && node.hasChildren()) {
            LineCollectingVisitor breakCollectingVisitor = new LineCollectingVisitor();
            this.myLines = breakCollectingVisitor.collectAndGetRanges(node);
            this.myEOLs = breakCollectingVisitor.getEOLs();
            this.myNextLine = 0;
            if (node.getFirstChild() != null) {
                this.outputSourceLineSpan(node, node.getFirstChild(), node, html);
            }
            context.renderChildren(node);
            html.tag("/span");
            return;
        }
        if (wrapTextInSpan) {
            html.withAttr().tag("span", false, false, () -> context.renderChildren(node));
        } else {
            context.renderChildren(node);
        }
    }

    private void outputSourceLineSpan(Node parentNode, Node startNode, Node endNode, HtmlWriter html) {
        int startOffset = startNode.getStartOffset();
        Range range = this.myLines.get(this.myNextLine);
        int eolLength = this.myEOLs.get(this.myNextLine);
        int endOffset = endNode.getEndOffset();
        if (range.getEnd() <= endOffset) {
            endOffset = range.getEnd();
            endOffset -= eolLength;
            endOffset -= parentNode.baseSubSequence(startOffset, endOffset).countTrailing(CharPredicate.SPACE_TAB);
            ++this.myNextLine;
            this.nextLineStartOffset = range.getEnd();
            this.nextLineStartOffset += parentNode.baseSubSequence(this.nextLineStartOffset, parentNode.getEndOffset()).countLeading(CharPredicate.SPACE_TAB);
        }
        if (range.getStart() > startOffset) {
            startOffset = range.getStart();
        }
        html.srcPos(startOffset, endOffset).withAttr(PARAGRAPH_LINE).tag("span");
    }

    private void outputNextLineBreakSpan(Node node, HtmlWriter html, boolean outputBreakText) {
        Range range = this.myLines.get(this.myNextLine);
        int eolLength = this.myEOLs.get(this.myNextLine);
        ++this.myNextLine;
        int countTrailing = node.baseSubSequence(this.nextLineStartOffset, range.getEnd() - eolLength).countTrailing(CharPredicate.SPACE_TAB);
        if (!outputBreakText && countTrailing > 0) {
            --countTrailing;
        }
        html.srcPos(this.nextLineStartOffset, range.getEnd() - (eolLength += countTrailing)).withAttr(PARAGRAPH_LINE).tag("span");
        this.nextLineStartOffset = range.getEnd();
        this.nextLineStartOffset += node.baseSubSequence(this.nextLineStartOffset, node.getChars().getBaseSequence().length()).countLeading(CharPredicate.SPACE_TAB);
    }

    private void renderLooseParagraph(Paragraph node, NodeRendererContext context, HtmlWriter html) {
        if (context.getHtmlOptions().noPTagsUseBr) {
            this.renderTextBlockParagraphLines(node, context, html, false);
            ((HtmlWriter)((HtmlWriter)html.tagVoid("br")).tagVoid("br")).line();
        } else {
            html.srcPosWithEOL(node.getChars()).withAttr().tagLine((CharSequence)"p", () -> this.renderTextBlockParagraphLines(node, context, html, false));
        }
    }

    void render(Paragraph node, NodeRendererContext context, HtmlWriter html) {
        if (node.getFirstChildAnyNot(NonRenderingInline.class) != null) {
            if (!(node.getParent() instanceof ParagraphItemContainer) || !((ParagraphItemContainer)((Object)node.getParent())).isParagraphWrappingDisabled(node, this.listOptions, context.getOptions())) {
                this.renderLooseParagraph(node, context, html);
            } else {
                this.renderTextBlockParagraphLines(node, context, html, false);
            }
        }
    }

    private boolean renderLineBreak(String breakText, String suppressInTag, Node node, NodeRendererContext context, HtmlWriter html) {
        if (this.myLines != null && this.myNextLine < this.myLines.size()) {
            boolean outputBreakText;
            List<String> openTags = html.getOpenTagsAfterLast("span");
            int iMax = openTags.size();
            boolean bl = outputBreakText = iMax == 0 || suppressInTag == null || !suppressInTag.equalsIgnoreCase(openTags.get(iMax - 1));
            if (!outputBreakText && !html.isPendingSpace()) {
                html.raw(" ");
            }
            int i = iMax;
            while (i-- > 0) {
                html.closeTag(openTags.get(i));
            }
            html.tag("/span");
            if (outputBreakText) {
                html.raw(breakText);
            }
            this.outputNextLineBreakSpan(node, html, outputBreakText);
            for (String tag : openTags) {
                if (!outputBreakText && context.getHtmlOptions().inlineCodeSpliceClass != null && !context.getHtmlOptions().inlineCodeSpliceClass.isEmpty()) {
                    ((HtmlWriter)html.attr("class", context.getHtmlOptions().inlineCodeSpliceClass)).withAttr().tag(tag);
                    continue;
                }
                html.tag(tag);
            }
            return true;
        }
        return false;
    }

    void render(SoftLineBreak node, NodeRendererContext context, HtmlWriter html) {
        String softBreak = context.getHtmlOptions().softBreak;
        if (context.getHtmlOptions().sourcePositionParagraphLines && this.renderLineBreak(softBreak, softBreak.equals("\n") || softBreak.equals("\r\n") || softBreak.equals("\r") ? "code" : null, node, context, html)) {
            return;
        }
        html.raw(softBreak);
    }

    void render(HardLineBreak node, NodeRendererContext context, HtmlWriter html) {
        if (context.getHtmlOptions().sourcePositionParagraphLines && this.renderLineBreak(context.getHtmlOptions().hardBreak, null, node, context, html)) {
            return;
        }
        html.raw(context.getHtmlOptions().hardBreak);
    }

    void render(Emphasis node, NodeRendererContext context, HtmlWriter html) {
        HtmlRendererOptions htmlOptions = context.getHtmlOptions();
        if (htmlOptions.emphasisStyleHtmlOpen == null || htmlOptions.emphasisStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag("em");
            } else {
                html.srcPos(node.getText()).withAttr().tag("em");
            }
            context.renderChildren(node);
            html.tag("/em");
        } else {
            html.raw(htmlOptions.emphasisStyleHtmlOpen);
            context.renderChildren(node);
            html.raw(htmlOptions.emphasisStyleHtmlClose);
        }
    }

    void render(StrongEmphasis node, NodeRendererContext context, HtmlWriter html) {
        HtmlRendererOptions htmlOptions = context.getHtmlOptions();
        if (htmlOptions.strongEmphasisStyleHtmlOpen == null || htmlOptions.strongEmphasisStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag("strong");
            } else {
                html.srcPos(node.getText()).withAttr().tag("strong");
            }
            context.renderChildren(node);
            html.tag("/strong");
        } else {
            html.raw(htmlOptions.strongEmphasisStyleHtmlOpen);
            context.renderChildren(node);
            html.raw(htmlOptions.strongEmphasisStyleHtmlClose);
        }
    }

    void render(Text node, NodeRendererContext context, HtmlWriter html) {
        html.text(Escaping.normalizeEOL(node.getChars().unescape()));
    }

    void render(TextBase node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
    }

    void render(Code node, NodeRendererContext context, HtmlWriter html) {
        HtmlRendererOptions htmlOptions = context.getHtmlOptions();
        if (htmlOptions.codeStyleHtmlOpen == null || htmlOptions.codeStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag("code");
            } else {
                html.srcPos(node.getText()).withAttr().tag("code");
            }
            if (this.codeSoftLineBreaks && !htmlOptions.isSoftBreakAllSpaces) {
                for (Node child : node.getChildren()) {
                    if (child instanceof Text) {
                        html.text(Escaping.collapseWhitespace((CharSequence)child.getChars(), true));
                        continue;
                    }
                    context.render(child);
                }
            } else {
                html.text(Escaping.collapseWhitespace((CharSequence)node.getText(), true));
            }
            html.tag("/code");
        } else {
            html.raw(htmlOptions.codeStyleHtmlOpen);
            if (this.codeSoftLineBreaks && !htmlOptions.isSoftBreakAllSpaces) {
                for (Node child : node.getChildren()) {
                    if (child instanceof Text) {
                        html.text(Escaping.collapseWhitespace((CharSequence)child.getChars(), true));
                        continue;
                    }
                    context.render(child);
                }
            } else {
                html.text(Escaping.collapseWhitespace((CharSequence)node.getText(), true));
            }
            html.raw(htmlOptions.codeStyleHtmlClose);
        }
    }

    void render(HtmlBlock node, NodeRendererContext context, HtmlWriter html) {
        html.line();
        HtmlRendererOptions htmlOptions = context.getHtmlOptions();
        if (htmlOptions.sourceWrapHtmlBlocks) {
            ((HtmlWriter)((HtmlWriter)html.srcPos(node.getChars()).withAttr(AttributablePart.NODE_POSITION).tag("div")).indent()).line();
        }
        if (node.hasChildren()) {
            context.renderChildren(node);
        } else {
            CoreNodeRenderer.renderHtmlBlock(node, context, html, htmlOptions.suppressHtmlBlocks, htmlOptions.escapeHtmlBlocks, false);
        }
        if (htmlOptions.sourceWrapHtmlBlocks) {
            ((HtmlWriter)html.unIndent()).tag("/div");
        }
        html.lineIf(htmlOptions.htmlBlockCloseTagEol);
    }

    void render(HtmlCommentBlock node, NodeRendererContext context, HtmlWriter html) {
        CoreNodeRenderer.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlCommentBlocks, context.getHtmlOptions().escapeHtmlCommentBlocks, false);
    }

    void render(HtmlInnerBlock node, NodeRendererContext context, HtmlWriter html) {
        CoreNodeRenderer.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlBlocks, context.getHtmlOptions().escapeHtmlBlocks, false);
    }

    void render(HtmlInnerBlockComment node, NodeRendererContext context, HtmlWriter html) {
        CoreNodeRenderer.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlCommentBlocks, context.getHtmlOptions().escapeHtmlCommentBlocks, false);
    }

    public static void renderHtmlBlock(HtmlBlockBase node, NodeRendererContext context, HtmlWriter html, boolean suppress, boolean escape, boolean trimSpaces) {
        String normalizeEOL;
        if (suppress) {
            return;
        }
        if (node instanceof HtmlBlock) {
            html.line();
        }
        String string = normalizeEOL = node instanceof HtmlBlock ? node.getContentChars().normalizeEOL() : node.getChars().normalizeEOL();
        if (trimSpaces) {
            normalizeEOL = normalizeEOL.trim();
        }
        if (escape) {
            if (node instanceof HtmlBlock) {
                if (normalizeEOL.length() > 0 && normalizeEOL.charAt(normalizeEOL.length() - 1) == '\n') {
                    normalizeEOL = normalizeEOL.substring(0, normalizeEOL.length() - 1);
                }
                ((HtmlWriter)((HtmlWriter)html.raw("<p>")).text(normalizeEOL)).raw("</p>");
            } else {
                html.text(normalizeEOL);
            }
        } else {
            html.rawPre(normalizeEOL);
        }
        if (node instanceof HtmlBlock) {
            html.lineIf(context.getHtmlOptions().htmlBlockCloseTagEol);
        }
    }

    void render(HtmlInline node, NodeRendererContext context, HtmlWriter html) {
        CoreNodeRenderer.renderInlineHtml(node, context, html, context.getHtmlOptions().suppressInlineHtml, context.getHtmlOptions().escapeInlineHtml);
    }

    void render(HtmlInlineComment node, NodeRendererContext context, HtmlWriter html) {
        CoreNodeRenderer.renderInlineHtml(node, context, html, context.getHtmlOptions().suppressInlineHtmlComments, context.getHtmlOptions().escapeInlineHtmlComments);
    }

    public static void renderInlineHtml(HtmlInlineBase node, NodeRendererContext context, HtmlWriter html, boolean suppress, boolean escape) {
        if (suppress) {
            return;
        }
        if (escape) {
            html.text(node.getChars().normalizeEOL());
        } else {
            html.rawPre(node.getChars().normalizeEOL());
        }
    }

    void render(Reference node, NodeRendererContext context, HtmlWriter html) {
    }

    void render(HtmlEntity node, NodeRendererContext context, HtmlWriter html) {
        if (context.getHtmlOptions().unescapeHtmlEntities) {
            html.text(node.getChars().unescape());
        } else {
            html.raw(node.getChars().unescapeNoEntities());
        }
    }

    public static boolean isSuppressedLinkPrefix(CharSequence url, NodeRendererContext context) {
        Pattern suppressedLinks = context.getHtmlOptions().suppressedLinks;
        if (suppressedLinks != null) {
            Matcher matcher = suppressedLinks.matcher(url);
            return matcher.matches();
        }
        return false;
    }

    void render(AutoLink node, NodeRendererContext context, HtmlWriter html) {
        String text2 = node.getText().toString();
        if (context.isDoNotRenderLinks() || CoreNodeRenderer.isSuppressedLinkPrefix(node.getUrl(), context)) {
            html.text(text2);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, text2, null);
            ((HtmlWriter)html.srcPos(node.getText()).attr("href", (CharSequence)(resolvedLink.getUrl().startsWith("www.") ? context.getHtmlOptions().autolinkWwwPrefix + resolvedLink.getUrl() : resolvedLink.getUrl()))).withAttr(resolvedLink).tag("a", false, false, () -> html.text(text2));
        }
    }

    void render(MailLink node, NodeRendererContext context, HtmlWriter html) {
        String text2 = node.getText().unescape();
        if (context.isDoNotRenderLinks() || CoreNodeRenderer.isSuppressedLinkPrefix(node.getUrl(), context)) {
            html.text(text2);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, text2, null);
            if (this.obfuscateEmail) {
                String url = Escaping.obfuscate("mailto:" + resolvedLink.getUrl(), this.obfuscateEmailRandom);
                text2 = Escaping.obfuscate(text2, true);
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.srcPos(node.getText()).attr("href", url)).withAttr(resolvedLink).tag("a")).raw(text2)).tag("/a");
            } else {
                String url = resolvedLink.getUrl();
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.srcPos(node.getText()).attr("href", "mailto:" + url)).withAttr(resolvedLink).tag("a")).text(text2)).tag("/a");
            }
        }
    }

    void render(Image node, NodeRendererContext context, HtmlWriter html) {
        if (!context.isDoNotRenderLinks() && !CoreNodeRenderer.isSuppressedLinkPrefix(node.getUrl(), context)) {
            String altText = new TextCollectingVisitor().collectAndGetText(node);
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, node.getUrl().unescape(), null, null);
            Object url = resolvedLink.getUrl();
            if (!node.getUrlContent().isEmpty()) {
                String content = Escaping.percentEncodeUrl(node.getUrlContent()).replace("+", "%2B").replace("%3D", "=").replace("%26", "&amp;");
                url = (String)url + content;
            }
            html.attr("src", (CharSequence)url);
            html.attr("alt", altText);
            if (node.getTitle().isNotNull()) {
                resolvedLink = resolvedLink.withTitle(node.getTitle().unescape());
            }
            html.attr(resolvedLink.getNonNullAttributes());
            html.srcPos(node.getChars()).withAttr(resolvedLink).tagVoid("img");
        }
    }

    void render(Link node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks() || CoreNodeRenderer.isSuppressedLinkPrefix(node.getUrl(), context)) {
            context.renderChildren(node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl().unescape(), null, null);
            html.attr("href", resolvedLink.getUrl());
            if (node.getTitle().isNotNull()) {
                resolvedLink = resolvedLink.withTitle(node.getTitle().unescape());
            }
            html.attr(resolvedLink.getNonNullAttributes());
            html.srcPos(node.getChars()).withAttr(resolvedLink).tag("a");
            this.renderChildrenSourceLineWrapped(node, node.getText(), context, html);
            html.tag("/a");
        }
    }

    private void renderChildrenSourceLineWrapped(Node node, BasedSequence nodeChildText, NodeRendererContext context, HtmlWriter html) {
        if (context.getHtmlOptions().sourcePositionParagraphLines && nodeChildText.indexOfAny(CharPredicate.ANY_EOL) >= 0) {
            if (this.myNextLine > 0) {
                --this.myNextLine;
            }
            this.outputSourceLineSpan(node, node, node, html);
            context.renderChildren(node);
            html.tag("/span");
        } else {
            context.renderChildren(node);
        }
    }

    void render(ImageRef node, NodeRendererContext context, HtmlWriter html) {
        ResolvedLink resolvedLink;
        boolean isSuppressed = false;
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        Reference reference = null;
        if (node.isDefined()) {
            reference = node.getReferenceNode(this.referenceRepository);
            String url = reference.getUrl().unescape();
            isSuppressed = CoreNodeRenderer.isSuppressedLinkPrefix(url, context);
            resolvedLink = context.resolveLink(LinkType.IMAGE, url, null, null);
            if (reference.getTitle().isNotNull()) {
                resolvedLink = resolvedLink.withTitle(reference.getTitle().unescape());
            }
        } else {
            String normalizeRef = this.referenceRepository.normalizeKey(node.getReference());
            resolvedLink = context.resolveLink(LinkType.IMAGE_REF, normalizeRef, null, null);
            if (resolvedLink.getStatus() == LinkStatus.UNKNOWN || resolvedLink.getUrl().isEmpty()) {
                resolvedLink = null;
            }
        }
        if (resolvedLink == null) {
            html.text(node.getChars().unescape());
        } else if (!context.isDoNotRenderLinks() && !isSuppressed) {
            String altText = new TextCollectingVisitor().collectAndGetText(node);
            Attributes attributes = resolvedLink.getNonNullAttributes();
            html.attr("src", resolvedLink.getUrl());
            html.attr("alt", altText);
            if (reference != null) {
                attributes = context.extendRenderingNodeAttributes(reference, AttributablePart.NODE, attributes);
            }
            html.attr(attributes);
            html.srcPos(node.getChars()).withAttr(resolvedLink).tagVoid("img");
        }
    }

    void render(LinkRef node, NodeRendererContext context, HtmlWriter html) {
        ResolvedLink resolvedLink;
        boolean isSuppressed = false;
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        Reference reference = null;
        if (node.isDefined()) {
            reference = node.getReferenceNode(this.referenceRepository);
            String url = reference.getUrl().unescape();
            isSuppressed = CoreNodeRenderer.isSuppressedLinkPrefix(url, context);
            resolvedLink = context.resolveLink(LinkType.LINK, url, null, null);
            if (reference.getTitle().isNotNull()) {
                resolvedLink = resolvedLink.withTitle(reference.getTitle().unescape());
            }
        } else {
            String normalizeRef = node.getReference().unescape();
            resolvedLink = context.resolveLink(LinkType.LINK_REF, normalizeRef, null, null);
            if (resolvedLink.getStatus() == LinkStatus.UNKNOWN || resolvedLink.getUrl().isEmpty()) {
                resolvedLink = null;
            }
        }
        if (resolvedLink == null) {
            assert (!node.isDefined());
            if (!node.hasChildren()) {
                html.text(node.getChars().unescape());
            } else {
                html.text(node.getChars().prefixOf(node.getChildChars()).unescape());
                this.renderChildrenSourceLineWrapped(node, node.getText(), context, html);
                html.text(node.getChars().suffixOf(node.getChildChars()).unescape());
            }
        } else if (context.isDoNotRenderLinks() || isSuppressed) {
            context.renderChildren(node);
        } else {
            Attributes attributes = resolvedLink.getNonNullAttributes();
            html.attr("href", resolvedLink.getUrl());
            if (reference != null) {
                attributes = context.extendRenderingNodeAttributes(reference, AttributablePart.NODE, attributes);
            }
            html.attr(attributes);
            html.srcPos(node.getChars()).withAttr(resolvedLink).tag("a");
            this.renderChildrenSourceLineWrapped(node, node.getText(), context, html);
            html.tag("/a");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new CoreNodeRenderer(options);
        }
    }
}

