/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.registry;

import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.registry.QodanaRegistryKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u001a\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u0011\u0010\u0016\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0018\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u001c\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u001e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u0011\u0010 \u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\bR\u0011\u0010\"\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lorg/jetbrains/qodana/registry/QodanaRegistry;", "", "()V", "CLOUD_INTEGRATION_ENABLE_KEY", "", "cloudDownloadRetriesCount", "", "getCloudDownloadRetriesCount", "()I", "cloudRequestRetriesCount", "getCloudRequestRetriesCount", "isActivityBasedConfigurationEnabled", "", "()Z", "isForceLocalRunEnabled", "isForceSetupCIEnabled", "isQodanaCloudIntegrationEnabled", "isQodanaLicenseAgreementCallbackEnabled", "limitedInspectionKtsDependencies", "getLimitedInspectionKtsDependencies", "openCoveragePackageLength", "getOpenCoveragePackageLength", "openCoverageReportEnabled", "getOpenCoverageReportEnabled", "openCoverageSmartFilteringEnabled", "getOpenCoverageSmartFilteringEnabled", "openSarifInEditor", "getOpenSarifInEditor", "useAllDistributionForInspectionKtsDependencies", "getUseAllDistributionForInspectionKtsDependencies", "vcsRevisionMaxPages", "getVcsRevisionMaxPages", "vcsRevisionPageSize", "getVcsRevisionPageSize", "webUiSourcesPath", "getWebUiSourcesPath", "()Ljava/lang/String;", "Cloud", "intellij.qodana"})
public final class QodanaRegistry {
    @NotNull
    public static final QodanaRegistry INSTANCE = new QodanaRegistry();
    @VisibleForTesting
    @NotNull
    public static final String CLOUD_INTEGRATION_ENABLE_KEY = "qd.cloud.integration.enabled";

    private QodanaRegistry() {
    }

    public final boolean isQodanaLicenseAgreementCallbackEnabled() {
        return Registry.is((String)"qd.license.agreement.callback.enabled", (boolean)true);
    }

    public final boolean isForceLocalRunEnabled() {
        return Registry.is((String)"qd.force.local.run.enabled", (boolean)false);
    }

    public final boolean isForceSetupCIEnabled() {
        return Registry.is((String)"qd.force.setup.ci.enabled", (boolean)false);
    }

    public final boolean isQodanaCloudIntegrationEnabled() {
        return Registry.is((String)CLOUD_INTEGRATION_ENABLE_KEY, (boolean)true);
    }

    public final boolean getOpenSarifInEditor() {
        return Registry.is((String)"qd.open.sarif.in.editor", (boolean)false);
    }

    public final boolean getOpenCoverageReportEnabled() {
        return Registry.is((String)"qd.open.coverage.enabled", (boolean)true);
    }

    public final boolean getOpenCoverageSmartFilteringEnabled() {
        return Registry.is((String)"qd.open.coverage.smart.filter.enabled", (boolean)true);
    }

    public final int getOpenCoveragePackageLength() {
        return Registry.intValue((String)"qd.open.coverage.common.package.length", (int)3);
    }

    @NotNull
    public final String getWebUiSourcesPath() {
        String string = Registry.stringValue((String)"qd.web.ui.sources.url");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        return string;
    }

    public final int getVcsRevisionPageSize() {
        return Registry.intValue((String)"qd.vcs.revision.page.size", (int)100);
    }

    public final int getVcsRevisionMaxPages() {
        return Registry.intValue((String)"qd.vcs.revision.max.pages", (int)10);
    }

    public final int getCloudRequestRetriesCount() {
        return Registry.intValue((String)"qd.cloud.request.retries.count", (int)2);
    }

    public final int getCloudDownloadRetriesCount() {
        return Registry.intValue((String)"qd.cloud.download.retries.count", (int)2);
    }

    public final boolean isActivityBasedConfigurationEnabled() {
        return Registry.is((String)"qd.activity.based.project.configuration");
    }

    public final boolean getUseAllDistributionForInspectionKtsDependencies() {
        return Registry.is((String)"qd.inspection.kts.all.distribution.for.dependencies", (boolean)false);
    }

    public final boolean getLimitedInspectionKtsDependencies() {
        return Registry.is((String)"qd.inspection.kts.limited.dependencies", (boolean)true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/registry/QodanaRegistry$Cloud;", "", "()V", "cloudApi", "", "getCloudApi", "()Ljava/lang/String;", "jbaAuthReferrer", "getJbaAuthReferrer", "jbaClientId", "getJbaClientId", "jbaOAuthUrl", "getJbaOAuthUrl", "website", "getWebsite", "intellij.qodana"})
    public static final class Cloud {
        @NotNull
        public static final Cloud INSTANCE = new Cloud();

        private Cloud() {
        }

        @NotNull
        public final String getWebsite() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.website", "https://qodana.cloud");
        }

        @NotNull
        public final String getCloudApi() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.api", "https://api.qodana.cloud");
        }

        @NotNull
        public final String getJbaOAuthUrl() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.jba.oauth.url", "https://oauth.account.jetbrains.com/oauth2/auth");
        }

        @NotNull
        public final String getJbaAuthReferrer() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.jba.auth.referrer", "https://account.jetbrains.com/");
        }

        @NotNull
        public final String getJbaClientId() {
            return QodanaRegistryKt.access$fromRegistryOrDefaultIfEmpty("qd.cloud.jba.auth.client.id", "qodana");
        }
    }
}

