/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.reposearch.DependencySearchService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesArtifactIdConverter;", "Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter;", "()V", "doGetVariants", "", "", "id", "Lorg/jetbrains/idea/maven/model/MavenId;", "searchService", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "doIsValid", "", "manager", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;", "context", "Lcom/intellij/util/xml/ConvertContext;", "intellij.maven"})
public final class MavenArtifactCoordinatesArtifactIdConverter
extends MavenArtifactCoordinatesConverter {
    @Override
    protected boolean doIsValid(@NotNull MavenId id, @NotNull MavenIndicesManager manager, @NotNull ConvertContext context2) {
        MavenProject mavenProject2;
        VirtualFile projectFile;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (StringUtil.isEmpty((String)id.getGroupId()) || StringUtil.isEmpty((String)id.getArtifactId())) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context2.getProject());
        if (StringUtil.isNotEmpty((String)id.getVersion())) {
            if (projectsManager.findProject(id) != null) {
                return true;
            }
        } else {
            for (MavenProject project2 : projectsManager.getProjects()) {
                Object mavenId2;
                Intrinsics.checkNotNullExpressionValue((Object)project2.getMavenId(), (String)"getMavenId(...)");
                if (!Intrinsics.areEqual((Object)id.getGroupId(), (Object)mavenId2.getGroupId()) || !Intrinsics.areEqual((Object)id.getArtifactId(), (Object)mavenId2.getArtifactId())) continue;
                return true;
            }
        }
        VirtualFile virtualFile = projectFile = this.getMavenProjectFile(context2);
        MavenProject mavenProject3 = mavenProject2 = virtualFile == null ? null : projectsManager.findProject(virtualFile);
        if (mavenProject2 != null) {
            for (MavenArtifact artifact : mavenProject2.findDependencies(id.getGroupId(), id.getArtifactId())) {
                if (!artifact.isResolved()) continue;
                return true;
            }
        }
        boolean hasLocalArtifactId = manager.hasLocalArtifactId(id.getGroupId(), id.getArtifactId());
        MavenLog.LOG.trace("local index artifact id " + id + ": " + hasLocalArtifactId);
        return hasLocalArtifactId;
    }

    @Override
    @NotNull
    protected Set<String> doGetVariants(@NotNull MavenId id, @NotNull DependencySearchService searchService) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        return SetsKt.emptySet();
    }
}

