/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;

public final class MavenRunnerParameters
implements Cloneable {
    private final boolean isPomExecution;
    private String myWorkingDirPath;
    private String myPomFileName;
    private String myMultimoduleDir;
    private final List<String> myGoals;
    private boolean myResolveToWorkspace;
    private final List<String> myProjectsCmdOptionValues;
    @Nullable
    private String myCmdOptions;
    private final Map<String, Boolean> myProfilesMap;
    private final Collection<String> myEnabledProfilesForXmlSerializer;

    public MavenRunnerParameters() {
        this(true, "", null, null, null, null);
    }

    @Deprecated(forRemoval=true)
    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(0);
        }
        this(isPomExecution, workingDirPath, null, goals, explicitEnabledProfiles, null);
    }

    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable String pomFileName, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(1);
        }
        this(isPomExecution, workingDirPath, pomFileName, goals, explicitEnabledProfiles, null);
    }

    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable String pomFileName, @Nullable List<String> goals, @NotNull MavenExplicitProfiles explicitProfiles2) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(2);
        }
        if (explicitProfiles2 == null) {
            MavenRunnerParameters.$$$reportNull$$$0(3);
        }
        this(isPomExecution, workingDirPath, pomFileName, goals, explicitProfiles2.getEnabledProfiles(), explicitProfiles2.getDisabledProfiles());
    }

    @Deprecated(forRemoval=true)
    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles, @Nullable Collection<String> explicitDisabledProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(4);
        }
        this(isPomExecution, workingDirPath, null, goals, explicitEnabledProfiles, explicitDisabledProfiles);
    }

    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable String pomFileName, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles, @Nullable Collection<String> explicitDisabledProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(5);
        }
        this.myGoals = new ArrayList<String>();
        this.myProjectsCmdOptionValues = new ArrayList<String>();
        this.myCmdOptions = null;
        this.myProfilesMap = new LinkedHashMap<String, Boolean>();
        this.myEnabledProfilesForXmlSerializer = new TreeSet<String>();
        this.isPomExecution = isPomExecution;
        this.setWorkingDirPath(workingDirPath);
        this.setPomFileName(pomFileName);
        this.setGoals(goals);
        if (explicitEnabledProfiles != null) {
            for (String profile : explicitEnabledProfiles) {
                this.myProfilesMap.put(profile, Boolean.TRUE);
            }
        }
        if (explicitDisabledProfiles != null) {
            for (String profile : explicitDisabledProfiles) {
                this.myProfilesMap.put(profile, Boolean.FALSE);
            }
        }
    }

    public MavenRunnerParameters(@NotNull String workingDirPath, @Nullable String pomFileName, boolean isPomExecution, @Nullable List<String> goals, @NotNull Map<String, Boolean> profilesMap) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(6);
        }
        if (profilesMap == null) {
            MavenRunnerParameters.$$$reportNull$$$0(7);
        }
        this.myGoals = new ArrayList<String>();
        this.myProjectsCmdOptionValues = new ArrayList<String>();
        this.myCmdOptions = null;
        this.myProfilesMap = new LinkedHashMap<String, Boolean>();
        this.myEnabledProfilesForXmlSerializer = new TreeSet<String>();
        this.isPomExecution = isPomExecution;
        this.setWorkingDirPath(workingDirPath);
        this.setPomFileName(pomFileName);
        this.setGoals(goals);
        this.setProfilesMap(profilesMap);
    }

    public MavenRunnerParameters(MavenRunnerParameters that) {
        this(that.myWorkingDirPath, that.myPomFileName, that.isPomExecution, that.myGoals, that.myProfilesMap);
        this.myResolveToWorkspace = that.myResolveToWorkspace;
        this.setProjectsCmdOptionValues(that.myProjectsCmdOptionValues);
    }

    public boolean isPomExecution() {
        return this.isPomExecution;
    }

    @NotNull
    @NlsSafe
    public String getWorkingDirPath() {
        String string = this.myWorkingDirPath;
        if (string == null) {
            MavenRunnerParameters.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setWorkingDirPath(@NotNull @NlsSafe String workingDirPath) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(9);
        }
        this.myWorkingDirPath = workingDirPath;
    }

    @NotNull
    public File getWorkingDirFile() {
        assert (this.myWorkingDirPath != null);
        return new File(this.myWorkingDirPath);
    }

    @Transient
    public void setCommandLine(@NotNull String value) {
        List commandLine;
        int pomFileNameIndex;
        if (value == null) {
            MavenRunnerParameters.$$$reportNull$$$0(10);
        }
        if ((pomFileNameIndex = 1 + (commandLine = ParametersListUtil.parse((String)value)).indexOf("-f")) != 0) {
            if (pomFileNameIndex < commandLine.size()) {
                this.setPomFileName((String)commandLine.remove(pomFileNameIndex));
            }
            commandLine.remove(pomFileNameIndex - 1);
        }
        this.setGoals(commandLine);
    }

    @Transient
    @NotNull
    public String getCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>(this.getGoals());
        String pomFileName = this.getPomFileName();
        if (pomFileName != null) {
            commandLine.add("-f");
            commandLine.add(pomFileName);
        }
        String string = ParametersList.join(commandLine);
        if (string == null) {
            MavenRunnerParameters.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setPomFileName(String pomFileName) {
        this.myPomFileName = pomFileName;
    }

    @NlsSafe
    public String getPomFileName() {
        return this.myPomFileName;
    }

    @NlsSafe
    @Nullable
    public String getMultimoduleDir() {
        return this.myMultimoduleDir;
    }

    public void setMultimoduleDir(@Nullable String multimoduleDir) {
        this.myMultimoduleDir = StringUtil.isEmptyOrSpaces((String)multimoduleDir) ? null : multimoduleDir;
    }

    public List<String> getGoals() {
        return this.myGoals;
    }

    public void setGoals(@Nullable List<String> goals) {
        if (this.myGoals == goals) {
            return;
        }
        this.myGoals.clear();
        if (goals != null) {
            this.myGoals.addAll(goals);
        }
    }

    public List<String> getProjectsCmdOptionValues() {
        return this.myProjectsCmdOptionValues;
    }

    public void setProjectsCmdOptionValues(@Nullable List<String> projectsCmdOptionValues) {
        if (this.myProjectsCmdOptionValues == projectsCmdOptionValues) {
            return;
        }
        this.myProjectsCmdOptionValues.clear();
        if (projectsCmdOptionValues != null) {
            this.myProjectsCmdOptionValues.addAll(projectsCmdOptionValues);
        }
    }

    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        if (!this.myProjectsCmdOptionValues.isEmpty()) {
            options.add("--projects=" + String.join((CharSequence)",", this.myProjectsCmdOptionValues));
        }
        if (StringUtil.isNotEmpty((String)this.myCmdOptions)) {
            options.add(this.myCmdOptions);
        }
        return options;
    }

    @Nullable
    public String getCmdOptions() {
        return this.myCmdOptions;
    }

    public void setCmdOptions(@Nullable String cmdOptions) {
        this.myCmdOptions = cmdOptions;
    }

    @Deprecated
    @OptionTag(value="profiles")
    public Collection<String> getEnabledProfilesForXmlSerializer() {
        return this.myEnabledProfilesForXmlSerializer;
    }

    @Deprecated
    public void setEnabledProfilesForXmlSerializer(@Nullable Collection<String> enabledProfilesForXmlSerializer) {
        if (enabledProfilesForXmlSerializer != null) {
            if (this.myEnabledProfilesForXmlSerializer == enabledProfilesForXmlSerializer) {
                return;
            }
            this.myEnabledProfilesForXmlSerializer.retainAll(enabledProfilesForXmlSerializer);
            this.myEnabledProfilesForXmlSerializer.addAll(enabledProfilesForXmlSerializer);
        }
    }

    public void fixAfterLoadingFromOldFormat() {
        for (String profile : this.myEnabledProfilesForXmlSerializer) {
            this.myProfilesMap.put(profile, true);
        }
        this.myEnabledProfilesForXmlSerializer.clear();
        File workingDir = this.getWorkingDirFile();
        if ("pom.xml".equals(workingDir.getName())) {
            this.setWorkingDirPath(workingDir.getParent());
        }
    }

    @OptionTag(value="profilesMap")
    @MapAnnotation(sortBeforeSave=false)
    public Map<String, Boolean> getProfilesMap() {
        return this.myProfilesMap;
    }

    public void setProfilesMap(@NotNull Map<String, Boolean> profilesMap) {
        if (profilesMap == null) {
            MavenRunnerParameters.$$$reportNull$$$0(12);
        }
        if (this.myProfilesMap == profilesMap) {
            return;
        }
        this.myProfilesMap.clear();
        for (Map.Entry<String, Boolean> entry : profilesMap.entrySet()) {
            if (entry.getValue() == null) continue;
            this.myProfilesMap.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isResolveToWorkspace() {
        return this.myResolveToWorkspace;
    }

    public void setResolveToWorkspace(boolean resolveToWorkspace) {
        this.myResolveToWorkspace = resolveToWorkspace;
    }

    public MavenRunnerParameters clone() {
        return new MavenRunnerParameters(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRunnerParameters that = (MavenRunnerParameters)o;
        if (this.isPomExecution != that.isPomExecution) {
            return false;
        }
        if (this.myResolveToWorkspace != that.myResolveToWorkspace) {
            return false;
        }
        if (!this.myGoals.equals(that.myGoals)) {
            return false;
        }
        if (!this.myProjectsCmdOptionValues.equals(that.myProjectsCmdOptionValues)) {
            return false;
        }
        if (!Objects.equals(this.myWorkingDirPath, that.myWorkingDirPath)) {
            return false;
        }
        if (!Objects.equals(this.myPomFileName, that.myPomFileName)) {
            return false;
        }
        if (!Objects.equals(this.myMultimoduleDir, that.myMultimoduleDir)) {
            return false;
        }
        return this.myProfilesMap.equals(that.myProfilesMap);
    }

    public int hashCode() {
        int result2 = this.isPomExecution ? 1 : 0;
        result2 = 31 * result2 + (this.myWorkingDirPath != null ? this.myWorkingDirPath.hashCode() : 0);
        result2 = 31 * result2 + this.myGoals.hashCode();
        result2 = 31 * result2 + (this.myPomFileName != null ? this.myPomFileName.hashCode() : 0);
        result2 = 31 * result2 + (this.myMultimoduleDir != null ? this.myMultimoduleDir.hashCode() : 0);
        result2 = 31 * result2 + this.myProfilesMap.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitProfiles";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilesMap";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunnerParameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunnerParameters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProfilesMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11 -> new IllegalStateException(string);
        };
    }
}

