/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\u000b\u0010\u0005\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfiguratorUtil;", "", "()V", "getModuleProfileName", "", "moduleName", "Lcom/intellij/openapi/util/NlsSafe;", "getProcessorArtifactInfos", "", "Lorg/jetbrains/idea/maven/model/MavenArtifactInfo;", "config", "Lorg/jdom/Element;", "intellij.maven"})
@ApiStatus.Internal
public final class MavenAnnotationProcessorConfiguratorUtil {
    @NotNull
    public static final MavenAnnotationProcessorConfiguratorUtil INSTANCE = new MavenAnnotationProcessorConfiguratorUtil();

    private MavenAnnotationProcessorConfiguratorUtil() {
    }

    @NotNull
    public final String getModuleProfileName(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return "Annotation profile for " + moduleName;
    }

    @NotNull
    public final List<MavenArtifactInfo> getProcessorArtifactInfos(@NotNull Element config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List artifacts = new ArrayList();
        Consumer addToArtifacts = arg_0 -> MavenAnnotationProcessorConfiguratorUtil.getProcessorArtifactInfos$lambda$0(artifacts, arg_0);
        for (Element path2 : config.getChildren("path")) {
            addToArtifacts.consume((Object)path2);
        }
        for (Element dependency : config.getChildren("dependency")) {
            addToArtifacts.consume((Object)dependency);
        }
        for (Element annotationProcessorPath : config.getChildren("annotationProcessorPath")) {
            addToArtifacts.consume((Object)annotationProcessorPath);
        }
        return artifacts;
    }

    private static final void getProcessorArtifactInfos$lambda$0(List $artifacts, Element path2) {
        Intrinsics.checkNotNullParameter((Object)$artifacts, (String)"$artifacts");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String groupId = path2.getChildTextTrim("groupId");
        String artifactId = path2.getChildTextTrim("artifactId");
        String version2 = path2.getChildTextTrim("version");
        String classifier = path2.getChildTextTrim("classifier");
        $artifacts.add(new MavenArtifactInfo(groupId, artifactId, version2, "jar", classifier));
    }
}

