/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.CallTreeBuildingData;
import com.intellij.profiler.api.DiffProfilerData;
import com.intellij.profiler.api.LazyCallTreeModelProviderWithProgress;
import com.intellij.profiler.api.MultipleCallTreesProfilerData;
import com.intellij.profiler.api.SamplingProfilerData;
import com.intellij.profiler.api.SingleCallTreeProfilerData;
import com.intellij.profiler.diff.ProfilerCallStackElementsCombiner;
import com.intellij.profiler.diff.ProfilerSnapshotComparator;
import com.intellij.profiler.diff.RegularProfilerSnapshotsComparisonStrategy;
import com.intellij.profiler.model.AllThreadsMerged;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.NoThreadInfoInProfilerData;
import com.intellij.profiler.model.RichCallTreeModel;
import com.intellij.profiler.model.RichCallTreeModelKt;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.model.ThreadInfoKt;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ`\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\r0\u001d2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0015\u0010\u001e\u001a\u00020\u001f2\u000b\u0010 \u001a\u00070\u0012\u00a2\u0006\u0002\b!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/profiler/diff/ProfilerSnapshotComparator;", "", "project", "Lcom/intellij/openapi/project/Project;", "callStackElementsCombiner", "Lcom/intellij/profiler/diff/ProfilerCallStackElementsCombiner;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/diff/ProfilerCallStackElementsCombiner;)V", "compare", "Lcom/intellij/profiler/api/DiffProfilerData;", "firstData", "Lcom/intellij/profiler/api/SamplingProfilerData;", "secondData", "createEntry", "Lkotlin/Pair;", "Lcom/intellij/profiler/model/ThreadInfo;", "Lcom/intellij/profiler/model/RichCallTreeModel;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "eventIdentifier", "", "firstModel", "", "secondModel", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getDiff", "Lcom/intellij/profiler/api/CallTreeBuildingData;", "firstTree", "secondTree", "matchProfilerTrees", "", "showErrorBalloon", "", "message", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerSnapshotsComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerSnapshotsComparator.kt\ncom/intellij/profiler/diff/ProfilerSnapshotComparator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1549#2:119\n1620#2,3:120\n1#3:123\n*S KotlinDebug\n*F\n+ 1 ProfilerSnapshotsComparator.kt\ncom/intellij/profiler/diff/ProfilerSnapshotComparator\n*L\n21#1:119\n21#1:120,3\n*E\n"})
public final class ProfilerSnapshotComparator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final ProfilerCallStackElementsCombiner callStackElementsCombiner;
    @NotNull
    private static final Lazy<Logger> LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);

    public ProfilerSnapshotComparator(@Nullable Project project, @NotNull ProfilerCallStackElementsCombiner callStackElementsCombiner) {
        Intrinsics.checkNotNullParameter((Object)callStackElementsCombiner, (String)"callStackElementsCombiner");
        this.project = project;
        this.callStackElementsCombiner = callStackElementsCombiner;
    }

    public /* synthetic */ ProfilerSnapshotComparator(Project project, ProfilerCallStackElementsCombiner profilerCallStackElementsCombiner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            profilerCallStackElementsCombiner = ProfilerCallStackElementsCombiner.Default.INSTANCE;
        }
        this(project, profilerCallStackElementsCombiner);
    }

    @NotNull
    public final DiffProfilerData compare(@NotNull SamplingProfilerData firstData, @NotNull SamplingProfilerData secondData) {
        SamplingProfilerData samplingProfilerData;
        Intrinsics.checkNotNullParameter((Object)firstData, (String)"firstData");
        Intrinsics.checkNotNullParameter((Object)secondData, (String)"secondData");
        long startTimeMs = System.currentTimeMillis();
        List<Pair<CallTreeBuildingData, CallTreeBuildingData>> treesToCompare = this.matchProfilerTrees(firstData, secondData);
        if (treesToCompare.isEmpty()) {
            Collection<String> collection;
            CallTreeBuildingData it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = firstData.getTrees();
            Logger logger = ProfilerSnapshotComparator.Companion.getLOG();
            boolean $i$f$map = false;
            Pair<CallTreeBuildingData, CallTreeBuildingData> pair = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CallTreeBuildingData callTreeBuildingData = (CallTreeBuildingData)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getReadableStateName());
            }
            $this$map$iv = secondData.getTrees();
            collection2 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (CallTreeBuildingData)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getReadableStateName());
            }
            collection = (List)destination$iv$iv;
            logger.info("Nothing to compare: there are no matching events. First dump: " + (List)collection2 + ", second dump: " + (List)collection);
            this.showErrorBalloon(CommonProfilerBundleKt.profilerMessage("ui.diff.info.nothing.to.compare", new Object[0]));
        }
        List resultTrees = new ArrayList();
        for (Pair<CallTreeBuildingData, CallTreeBuildingData> pair : treesToCompare) {
            CallTreeBuildingData firstTree = (CallTreeBuildingData)pair.component1();
            CallTreeBuildingData secondTree = (CallTreeBuildingData)pair.component2();
            ((Collection)resultTrees).add(this.getDiff(firstTree, secondTree));
        }
        if (firstData instanceof SingleCallTreeProfilerData && secondData instanceof SingleCallTreeProfilerData) {
            if (!(resultTrees.size() == 1)) {
                boolean bl = false;
                String string = "Unexpected number of trees: both dumps can have only one tree but the diff contains " + resultTrees.size();
                throw new IllegalArgumentException(string.toString());
            }
            samplingProfilerData = new SingleCallTreeProfilerData((CallTreeBuildingData)CollectionsKt.single((List)resultTrees));
        } else {
            samplingProfilerData = new MultipleCallTreesProfilerData(resultTrees);
        }
        SamplingProfilerData delegate = samplingProfilerData;
        ProfilerUsageTriggerCollector.logDiffCreated(this.project, System.currentTimeMillis() - startTimeMs);
        return new DiffProfilerData(delegate);
    }

    private final List<Pair<CallTreeBuildingData, CallTreeBuildingData>> matchProfilerTrees(SamplingProfilerData firstData, SamplingProfilerData secondData) {
        List result2 = new ArrayList();
        for (CallTreeBuildingData firstTree : firstData.getTrees()) {
            CallTreeBuildingData secondTree;
            Object v0;
            block2: {
                Iterable iterable = secondData.getTrees();
                for (Object t : iterable) {
                    CallTreeBuildingData it = (CallTreeBuildingData)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getReadableStateName(), (Object)firstTree.getReadableStateName())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((secondTree = (CallTreeBuildingData)v0) == null) continue;
            ((Collection)result2).add(TuplesKt.to((Object)firstTree, (Object)secondTree));
        }
        return result2;
    }

    private final CallTreeBuildingData getDiff(CallTreeBuildingData firstTree, CallTreeBuildingData secondTree) {
        return new CallTreeBuildingData(firstTree.getReadableStateName(), firstTree.getRenderer(), firstTree.getMetric(), new LazyCallTreeModelProviderWithProgress((Function1<? super ProgressIndicator, ? extends Map<ThreadInfo, ? extends RichCallTreeModel<BaseCallStackElement>>>)((Function1)new Function1<ProgressIndicator, Map<ThreadInfo, ? extends RichCallTreeModel<BaseCallStackElement>>>(this, firstTree, secondTree){
            final /* synthetic */ ProfilerSnapshotComparator this$0;
            final /* synthetic */ CallTreeBuildingData $firstTree;
            final /* synthetic */ CallTreeBuildingData $secondTree;
            {
                this.this$0 = $receiver;
                this.$firstTree = $firstTree;
                this.$secondTree = $secondTree;
                super(1);
            }

            @NotNull
            public final Map<ThreadInfo, RichCallTreeModel<BaseCallStackElement>> invoke(@NotNull ProgressIndicator indicator) {
                Map map2;
                Map map3;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Pair pair = ProfilerSnapshotComparator.access$createEntry(this.this$0, this.$firstTree.getReadableStateName(), this.$firstTree.getCallTreeModelProvider().getModel(), this.$secondTree.getCallTreeModelProvider().getModel(), indicator);
                if (pair != null) {
                    Pair p0 = pair;
                    boolean bl = false;
                    map3 = MapsKt.mapOf((Pair)p0);
                } else {
                    map3 = map2 = null;
                }
                if (map3 == null) {
                    map2 = MapsKt.emptyMap();
                }
                return map2;
            }
        })), firstTree.getId());
    }

    private final Pair<ThreadInfo, RichCallTreeModel<BaseCallStackElement>> createEntry(String eventIdentifier, Map<ThreadInfo, ? extends RichCallTreeModel<BaseCallStackElement>> firstModel, Map<ThreadInfo, ? extends RichCallTreeModel<BaseCallStackElement>> secondModel, ProgressIndicator progressIndicator) throws ProcessCanceledException {
        if (ThreadInfoKt.noThreadInfoInThreadList((Collection<? extends ThreadInfo>)firstModel.keySet()) && ThreadInfoKt.noThreadInfoInThreadList((Collection<? extends ThreadInfo>)secondModel.keySet())) {
            return TuplesKt.to((Object)NoThreadInfoInProfilerData.INSTANCE, this.getDiff((RichCallTreeModel)MapsKt.getValue(firstModel, (Object)NoThreadInfoInProfilerData.INSTANCE), (RichCallTreeModel)MapsKt.getValue(secondModel, (Object)NoThreadInfoInProfilerData.INSTANCE), progressIndicator));
        }
        RichCallTreeModel<BaseCallStackElement> first = firstModel.get(AllThreadsMerged.INSTANCE);
        RichCallTreeModel<BaseCallStackElement> second = secondModel.get(AllThreadsMerged.INSTANCE);
        if (first == null || second == null) {
            String string;
            if (StringsKt.isBlank((CharSequence)eventIdentifier)) {
                string = CommonProfilerBundleKt.profilerMessage("ui.diff.info.incompatible.thread.layouts.no.identifier", new Object[0]);
            } else {
                Object[] objectArray = new Object[]{eventIdentifier};
                string = CommonProfilerBundleKt.profilerMessage("ui.diff.info.incompatible.thread.layouts", objectArray);
            }
            String message2 = string;
            this.showErrorBalloon(message2);
            return null;
        }
        return TuplesKt.to((Object)AllThreadsMerged.INSTANCE, this.getDiff(first, second, progressIndicator));
    }

    private final void showErrorBalloon(String message2) {
        block0: {
            Project project = this.project;
            if (project == null) break block0;
            Project it = project;
            boolean bl = false;
            ProfilerToolWindowManager.Companion.getInstance(it).showErrorBalloon(message2);
        }
    }

    private final RichCallTreeModel<BaseCallStackElement> getDiff(RichCallTreeModel<BaseCallStackElement> firstModel, RichCallTreeModel<BaseCallStackElement> secondModel, ProgressIndicator progressIndicator) throws ProcessCanceledException {
        CallTreeNode<BaseCallStackElement> firstCallTree = firstModel.getCallTree();
        CallTreeNode<BaseCallStackElement> secondCallTree = secondModel.getCallTree();
        return RichCallTreeModelKt.createRichCallTreeModel(new RegularProfilerSnapshotsComparisonStrategy(this.callStackElementsCombiner).getDiff((CallTreeNode<? extends BaseCallStackElement>)firstCallTree, (CallTreeNode<? extends BaseCallStackElement>)secondCallTree, progressIndicator));
    }

    public static final /* synthetic */ Pair access$createEntry(ProfilerSnapshotComparator $this, String eventIdentifier, Map firstModel, Map secondModel, ProgressIndicator progressIndicator) {
        return $this.createEntry(eventIdentifier, firstModel, secondModel, progressIndicator);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/diff/ProfilerSnapshotComparator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

