/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.kotlin.correctness;

import com.intellij.ml.inline.completion.features.autoimport.ImportFixer;
import com.intellij.ml.inline.completion.features.correctness.CorrectnessError;
import com.intellij.ml.inline.completion.features.correctness.RawEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.kotlin.KotlinImportFixer;
import com.intellij.ml.inline.completion.kotlin.correctness.KotlinEnrichmentTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaDiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007JD\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J4\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J*\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J>\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0006H\u0016JL\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\"*\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'2\u0006\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\u0004\u0018\u00010,*\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/ml/inline/completion/kotlin/correctness/KotlinEnrichmentTool;", "Lcom/intellij/ml/inline/completion/features/correctness/RawEnrichmentTool;", "kit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;)V", "findElementsToAnalyze", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "range", "findErrorsByKotlinDiagnostics", "", "Lcom/intellij/ml/inline/completion/features/correctness/CorrectnessError;", "newPsiFile", "elements", "Lcom/intellij/psi/PsiElement;", "textRange", "offset", "", "suggestion", "", "originalFile", "findInvalidFunctionDefinition", "findSyntaxErrors", "getLocationInSuggestion", "errorRangeInFile", "suggestionLocationInFile", "run", "editor", "Lcom/intellij/openapi/editor/Editor;", "suggestionOffset", "fileWithSuggestion", "suggestionRange", "findErrorsForElement", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "allDiagnostics", "", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnosticWithPsi;", "originalKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getUnresolvedReferenceSeverity", "Lcom/intellij/ml/inline/completion/features/correctness/Severity;", "Companion", "intellij.ml.inline.completion.kotlin"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKotlinSuggestionEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/kotlin/correctness/KotlinEnrichmentTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,393:1\n800#2,11:394\n800#2,11:405\n1360#2:416\n1446#2,5:417\n766#2:432\n857#2,2:433\n1446#2,2:435\n1603#2,9:437\n1855#2:446\n1856#2:448\n1612#2:449\n1448#2,3:450\n28#3,2:422\n36#4,8:424\n1#5:447\n14#6:453\n13#7:454\n*S KotlinDebug\n*F\n+ 1 KotlinSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/kotlin/correctness/KotlinEnrichmentTool\n*L\n125#1:394,11\n138#1:405,11\n141#1:416\n141#1:417,5\n229#1:432\n229#1:433,2\n230#1:435,2\n237#1:437,9\n237#1:446\n237#1:448\n237#1:449\n230#1:450,3\n208#1:422,2\n208#1:424,8\n237#1:447\n248#1:453\n258#1:454\n*E\n"})
public final class KotlinEnrichmentTool
extends RawEnrichmentTool {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MLCompletionLanguageKit kit;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<List<String>> CRITICAL_ERRORS$delegate;
    @NotNull
    private static final Lazy<List<String>> ACCEPTABLE_ERRORS$delegate;

    public KotlinEnrichmentTool(@NotNull MLCompletionLanguageKit kit) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        this.kit = kit;
    }

    @ApiStatus.Internal
    @NotNull
    public final TextRange findElementsToAnalyze(@NotNull PsiFile file, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        List list2 = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file)).filter(arg_0 -> KotlinEnrichmentTool.findElementsToAnalyze$lambda$0((Function1)new Function1<PsiElement, Boolean>(range){
            final /* synthetic */ TextRange $range;
            {
                this.$range = $range;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PsiElement it) {
                Intrinsics.checkNotNull((Object)it);
                return FixersUtilKt.getRange((PsiElement)it).intersects(this.$range) && PsiTreeUtilKt.getEndOffset((PsiElement)it) <= this.$range.getEndOffset();
            }
        }, arg_0))).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        List initialElements2 = list2;
        PsiElement firstCommonParent = PsiTreeUtil.findCommonParent((List)initialElements2);
        if (!(firstCommonParent instanceof KtFunction)) {
            return range;
        }
        TextRange textRange = ((KtFunction)firstCommonParent).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CorrectnessError> findInvalidFunctionDefinition(List<? extends PsiElement> elements2, TextRange textRange, int offset2, String suggestion) {
        void $this$filterIsInstanceTo$iv$iv;
        List allInvalidFunctions = new ArrayList();
        Iterable $this$filterIsInstance$iv = elements2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (KtNamedFunction function : (List)destination$iv$iv) {
            TextRange errorLocation;
            PsiElement equalsToken = function.getEqualsToken();
            if (equalsToken == null || !(function.getBodyExpression() instanceof KtLambdaExpression)) continue;
            TextRange textRange2 = equalsToken.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
            if (this.getLocationInSuggestion(textRange2, textRange, offset2, suggestion) == null) continue;
            boolean bl = false;
            allInvalidFunctions.add(new CorrectnessError(errorLocation, Severity.CRITICAL, "SYNTAX_ERROR"));
        }
        return allInvalidFunctions;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CorrectnessError> findSyntaxErrors(List<? extends PsiElement> elements2, TextRange textRange, int offset2, String suggestion) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = elements2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiErrorElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List syntaxErrors = (List)destination$iv$iv;
        if (syntaxErrors.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = syntaxErrors;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object object;
            block7: {
                block6: {
                    PsiErrorElement syntaxError = (PsiErrorElement)element$iv$iv;
                    boolean bl = false;
                    TextRange textRange2 = syntaxError.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
                    object = this.getLocationInSuggestion(textRange2, textRange, offset2, suggestion);
                    if (object == null) break block6;
                    TextRange errorLocation = object;
                    boolean bl2 = false;
                    List list2 = CollectionsKt.listOf((Object)new CorrectnessError(errorLocation, Severity.CRITICAL, "SYNTAX_ERROR"));
                    object = list2;
                    if (list2 != null) break block7;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<CorrectnessError> run(@NotNull Editor editor2, @NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion, @NotNull PsiFile fileWithSuggestion, @NotNull TextRange suggestionRange) {
        List foundErrors;
        Object object;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)fileWithSuggestion, (String)"fileWithSuggestion");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        TextRange adjustedTextRange = this.findElementsToAnalyze(fileWithSuggestion, suggestionRange);
        List list2 = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)fileWithSuggestion)).onRange(adjustedTextRange).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        List elements2 = list2;
        List<CorrectnessError> invalidFunctionErrors = this.findInvalidFunctionDefinition(elements2, adjustedTextRange, suggestionRange.getStartOffset(), suggestion);
        if (!((Collection)invalidFunctionErrors).isEmpty()) {
            return invalidFunctionErrors;
        }
        List<CorrectnessError> syntaxErrors = this.findSyntaxErrors(elements2, adjustedTextRange, suggestionRange.getStartOffset(), suggestion);
        if (!((Collection)syntaxErrors).isEmpty()) {
            return syntaxErrors;
        }
        KotlinEnrichmentTool kotlinEnrichmentTool = this;
        try {
            KotlinEnrichmentTool $this$run_u24lambda_u244 = kotlinEnrichmentTool;
            boolean bl = false;
            object = Result.constructor-impl($this$run_u24lambda_u244.findErrorsByKotlinDiagnostics(fileWithSuggestion, elements2, adjustedTextRange, suggestionRange.getStartOffset(), suggestion, originalFile));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        List list3 = foundErrors = (List)LoggerKt.getOrLogException((Object)object, (Logger)LOG);
        if (list3 != null) {
            return list3;
        }
        TextRange textRange = TextRange.allOf((String)suggestion);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"allOf(...)");
        return CollectionsKt.listOf((Object)new CorrectnessError(textRange, Severity.CRITICAL, "Unexpected exception during analyzing Kotlin code"));
    }

    private final TextRange getLocationInSuggestion(TextRange errorRangeInFile, TextRange suggestionLocationInFile, int offset2, String suggestion) {
        if (!suggestionLocationInFile.intersects(errorRangeInFile)) {
            return null;
        }
        TextRange intersectionRange = suggestionLocationInFile.intersection(errorRangeInFile);
        return new TextRange(RangesKt.coerceIn((int)(intersectionRange.getStartOffset() - offset2), (ClosedRange)((ClosedRange)StringsKt.getIndices((CharSequence)suggestion))), RangesKt.coerceIn((int)(intersectionRange.getEndOffset() - offset2), (ClosedRange)((ClosedRange)new IntRange(1, suggestion.length()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<CorrectnessError> findErrorsByKotlinDiagnostics(PsiFile newPsiFile, List<? extends PsiElement> elements2, TextRange textRange, int offset2, String suggestion, PsiFile originalFile) {
        void this_$iv$iv;
        KtFile ktFile = newPsiFile instanceof KtFile ? (KtFile)newPsiFile : null;
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile newKtFile = ktFile;
        KtFile ktFile2 = originalFile instanceof KtFile ? (KtFile)originalFile : null;
        if (ktFile2 == null) {
            return CollectionsKt.emptyList();
        }
        KtFile originalKtFile = ktFile2;
        Set allErrors = new LinkedHashSet();
        KtElement useSiteElement$iv = (KtElement)newPsiFile;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv);
        try {
            KaSession $this$findErrorsByKotlinDiagnostics_u24lambda_u245 = analysisSession$iv$iv;
            boolean bl = false;
            Collection allDiagnostics = $this$findErrorsByKotlinDiagnostics_u24lambda_u245.collectDiagnostics(newKtFile, KaDiagnosticCheckerFilter.ONLY_COMMON_CHECKERS);
            for (PsiElement psiElement : elements2) {
                if (!(psiElement instanceof KtElement)) continue;
                allErrors.addAll((Collection)this.findErrorsForElement($this$findErrorsByKotlinDiagnostics_u24lambda_u245, (KtElement)psiElement, textRange, offset2, suggestion, allDiagnostics, originalKtFile));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv);
        }
        return CollectionsKt.toList((Iterable)allErrors);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<CorrectnessError> findErrorsForElement(KaSession $this$findErrorsForElement, KtElement element, TextRange textRange, int offset2, String suggestion, Collection<? extends KaDiagnosticWithPsi<?>> allDiagnostics, KtFile originalKtFile) {
        void destination$iv;
        void $this$flatMapTo$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = allDiagnostics;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KaDiagnosticWithPsi it = (KaDiagnosticWithPsi)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPsi(), (Object)element)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List diagnostics = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)$this$findErrorsForElement.diagnostics(element, KaDiagnosticCheckerFilter.ONLY_COMMON_CHECKERS));
        $this$filter$iv = diagnostics;
        Collection $i$f$filter22 = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            List list2;
            KaDiagnosticWithPsi diagnostic = (KaDiagnosticWithPsi)element$iv;
            boolean bl = false;
            String it = diagnostic.getFactoryName();
            if ((Intrinsics.areEqual((Object)it, (Object)FirErrors.INSTANCE.getUNRESOLVED_REFERENCE().getName()) ? this.getUnresolvedReferenceSeverity($this$findErrorsForElement, element, originalKtFile) : (Companion.getCRITICAL_ERRORS().contains(it) ? Severity.CRITICAL : (Companion.getACCEPTABLE_ERRORS().contains(it) ? Severity.ACCEPTABLE : null))) == null) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$mapNotNullTo$iv$iv;
                Severity severity;
                severity = severity;
                Iterable $this$mapNotNull$iv = diagnostic.getTextRanges();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    CorrectnessError correctnessError;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    TextRange errorTextRange = (TextRange)element$iv$iv;
                    boolean bl3 = false;
                    if (this.getLocationInSuggestion(errorTextRange, textRange, offset2, suggestion) == null) {
                        correctnessError = null;
                    } else {
                        TextRange errorLocation;
                        String string = diagnostic.getFactoryName();
                        if (string == null) {
                            string = "unknown Kotlin diagnostics problem";
                        }
                        correctnessError = new CorrectnessError(errorLocation, severity, string);
                    }
                    if (correctnessError == null) continue;
                    CorrectnessError it$iv$iv = correctnessError;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            }
            Iterable list$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)destination$iv;
    }

    private final Severity getUnresolvedReferenceSeverity(KaSession $this$getUnresolvedReferenceSeverity, KtElement element, KtFile originalKtFile) {
        if (!(element instanceof KtSimpleNameExpression)) {
            return null;
        }
        ImportFixer $this$asSafely$iv = this.kit.getImportFixer();
        boolean $i$f$asSafely = false;
        ImportFixer importFixer = $this$asSafely$iv;
        if (!(importFixer instanceof KotlinImportFixer)) {
            importFixer = null;
        }
        KotlinImportFixer kotlinImportFixer = (KotlinImportFixer)importFixer;
        if (kotlinImportFixer == null) {
            return null;
        }
        KotlinImportFixer importFixer2 = kotlinImportFixer;
        return importFixer2.isFixableByAutoImport((KtSimpleNameExpression)element, originalKtFile) ? Severity.ACCEPTABLE : Severity.CRITICAL;
    }

    private static final boolean findElementsToAnalyze$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(KotlinEnrichmentTool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        CRITICAL_ERRORS$delegate = LazyKt.lazy((Function0)Companion.CRITICAL_ERRORS.2.INSTANCE);
        ACCEPTABLE_ERRORS$delegate = LazyKt.lazy((Function0)Companion.ACCEPTABLE_ERRORS.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/correctness/KotlinEnrichmentTool$Companion;", "", "()V", "ACCEPTABLE_ERRORS", "", "", "getACCEPTABLE_ERRORS", "()Ljava/util/List;", "ACCEPTABLE_ERRORS$delegate", "Lkotlin/Lazy;", "CRITICAL_ERRORS", "getCRITICAL_ERRORS", "CRITICAL_ERRORS$delegate", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.inline.completion.kotlin"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final List<String> getCRITICAL_ERRORS() {
            Lazy lazy = CRITICAL_ERRORS$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<String> getACCEPTABLE_ERRORS() {
            Lazy lazy = ACCEPTABLE_ERRORS$delegate;
            return (List)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

