/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import freemarker.cache.ClassTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class TemplateFactory {
    private Template myNamespacesTeamplate;
    private Template myModulesTemplate;
    private Template myNamespaceIndexTemplate;
    private Template myClassTemplate;
    private Template myEmpty;

    public TemplateFactory() throws IOException {
        Configuration configuration = new Configuration();
        configuration.setTemplateLoader(new ClassTemplateLoader(this.getClass(), "/htmlTemplates"));
        try {
            configuration.setSetting("cache_storage", "strong:420, soft:400");
            configuration.setSetting("template_update_delay", "0");
        }
        catch (TemplateException e) {
            System.err.println("Failed to set configuration properties: " + e.getMessage());
            e.printStackTrace();
        }
        this.myNamespacesTeamplate = configuration.getTemplate("namespaces.ftl");
        this.myModulesTemplate = configuration.getTemplate("modules.ftl");
        this.myNamespaceIndexTemplate = configuration.getTemplate("namespaceIndex.ftl");
        this.myClassTemplate = configuration.getTemplate("classCoverage.ftl");
        this.myEmpty = configuration.getTemplate("empty.ftl");
    }

    @NotNull
    public Template createEmptyTemplate() throws IOException {
        return this.myEmpty;
    }

    @NotNull
    public Template createNamespacesPerModuleIndexTemplate() throws IOException {
        return this.myNamespacesTeamplate;
    }

    @NotNull
    public Template createModulesIndexTemplate() throws IOException {
        return this.myModulesTemplate;
    }

    @NotNull
    public Template createNamespaceIndexTemplate() throws IOException {
        return this.myNamespaceIndexTemplate;
    }

    @NotNull
    public Template createClassCoverageTemplate() throws IOException {
        return this.myClassTemplate;
    }
}

