/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.codeInspection.MigrateToAssertThatQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/junit/codeInspection/HamcrestAssertionsConverterVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "matcherFqn", "", "importMemberOnDemand", "", "(Lcom/intellij/codeInspection/ProblemsHolder;Ljava/lang/String;Z)V", "isBooleanAssert", "methodName", "visitCallExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "Companion", "intellij.junit"})
final class HamcrestAssertionsConverterVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final String matcherFqn;
    private final boolean importMemberOnDemand;
    @NotNull
    private static final List<String> JUNIT_ASSERT_METHODS;

    public HamcrestAssertionsConverterVisitor(@NotNull ProblemsHolder holder, @NotNull String matcherFqn, boolean importMemberOnDemand) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)matcherFqn, (String)"matcherFqn");
        this.holder = holder;
        this.matcherFqn = matcherFqn;
        this.importMemberOnDemand = importMemberOnDemand;
    }

    private final boolean isBooleanAssert(String methodName) {
        return Intrinsics.areEqual((Object)methodName, (Object)"assertTrue") || Intrinsics.areEqual((Object)methodName, (Object)"assertFalse");
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.getMethodName();
        if (string == null) {
            return true;
        }
        String methodName = string;
        if (!JUNIT_ASSERT_METHODS.contains(methodName)) {
            return true;
        }
        UElement uElement = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)node));
        if (uElement == null) {
            return true;
        }
        UElement method = uElement;
        UClass uClass = UastUtils.getContainingUClass((UElement)method);
        if (uClass == null) {
            return true;
        }
        UClass methodClass = uClass;
        if (!Intrinsics.areEqual((Object)methodClass.getQualifiedName(), (Object)"org.junit.Assert") && !Intrinsics.areEqual((Object)methodClass.getQualifiedName(), (Object)"junit.framework.Assert")) {
            return true;
        }
        if (this.isBooleanAssert(methodName)) {
            List args = node.getValueArguments();
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null || (psiElement = psiElement.getResolveScope()) == null) {
                return true;
            }
            PsiElement resolveScope = psiElement;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.holder.getProject());
            if (CollectionsKt.last((List)args) instanceof UBinaryExpression && psiFacade.findClass("org.hamcrest.number.OrderingComparison", (GlobalSearchScope)resolveScope) == null) {
                return true;
            }
        }
        Object[] objectArray = new Object[]{"assertThat()"};
        String string2 = JUnitBundle.message("jvm.inspections.migrate.assert.to.matcher.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message2 = string2;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new MigrateToAssertThatQuickFix(this.matcherFqn, this.importMemberOnDemand)};
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UCallExpression)node, (String)message2, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
        return true;
    }

    static {
        Object[] objectArray = new String[]{"assertArrayEquals", "assertEquals", "assertNotEquals", "assertSame", "assertNotSame", "assertNotNull", "assertNull", "assertTrue", "assertFalse"};
        JUNIT_ASSERT_METHODS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/junit/codeInspection/HamcrestAssertionsConverterVisitor$Companion;", "", "()V", "JUNIT_ASSERT_METHODS", "", "", "intellij.junit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

