/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEditorAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.LineHistoryMapper;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CoverageEditorAnnotatorImpl
implements CoverageEditorAnnotator,
Disposable {
    private static final Logger LOG = Logger.getInstance(CoverageEditorAnnotatorImpl.class);
    public static final Key<List<RangeHighlighter>> COVERAGE_HIGHLIGHTERS = Key.create((String)"COVERAGE_HIGHLIGHTERS");
    private static final Key<DocumentListener> COVERAGE_DOCUMENT_LISTENER = Key.create((String)"COVERAGE_DOCUMENT_LISTENER");
    public static final Key<Map<FileEditor, EditorNotificationPanel>> NOTIFICATION_PANELS = Key.create((String)"NOTIFICATION_PANELS");
    private PsiFile myFile;
    private Editor myEditor;
    private Document myDocument;
    private final Project myProject;
    private volatile LineHistoryMapper myMapper;
    private final Object myLock = new Object();
    private Disposable myListenerDisposable;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);

    public CoverageEditorAnnotatorImpl(PsiFile file, Editor editor) {
        this.myFile = file;
        this.myEditor = editor;
        this.myProject = file.getProject();
        this.myDocument = this.myEditor.getDocument();
    }

    @Override
    public final void hideCoverage() {
        Editor editor = this.myEditor;
        PsiFile file = this.myFile;
        Document document = this.myDocument;
        if (editor == null || editor.isDisposed() || file == null || document == null) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        this.removeHighlighters();
        Map map = (Map)file.getCopyableUserData(NOTIFICATION_PANELS);
        if (map != null) {
            VirtualFile vFile = CoverageEditorAnnotatorImpl.getVirtualFile(file);
            boolean freeAll = !fileEditorManager.isFileOpen(vFile);
            file.putCopyableUserData(NOTIFICATION_PANELS, null);
            for (FileEditor fileEditor : map.keySet()) {
                if (!freeAll && !this.isCurrentEditor(fileEditor)) continue;
                fileEditorManager.removeTopComponent(fileEditor, (JComponent)map.get(fileEditor));
            }
        }
    }

    private synchronized void removeHighlighters() {
        Editor editor = this.myEditor;
        if (editor == null || editor.isDisposed()) {
            return;
        }
        List highlighters = (List)editor.getUserData(COVERAGE_HIGHLIGHTERS);
        if (highlighters != null) {
            for (RangeHighlighter highlighter : highlighters) {
                ApplicationManager.getApplication().invokeLater(() -> highlighter.dispose());
            }
            editor.putUserData(COVERAGE_HIGHLIGHTERS, null);
        }
    }

    @Nullable
    private synchronized List<RangeHighlighter> getOrCreateHighlighters(boolean init) {
        Editor editor = this.myEditor;
        if (editor == null || editor.isDisposed()) {
            return null;
        }
        ArrayList highlighters = (ArrayList)editor.getUserData(COVERAGE_HIGHLIGHTERS);
        if (highlighters == null && init) {
            highlighters = new ArrayList();
            editor.putUserData(COVERAGE_HIGHLIGHTERS, highlighters);
        }
        return highlighters;
    }

    private synchronized void registerOrDisposeHighlighter(RangeHighlighter highlighter) {
        List<RangeHighlighter> highlighters = this.getOrCreateHighlighters(false);
        if (highlighters == null) {
            ApplicationManager.getApplication().invokeLater(() -> highlighter.dispose());
        } else {
            highlighters.add(highlighter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void showCoverage(final CoverageSuitesBundle suite2) {
        Int2IntMap oldToNewLineMapping;
        PsiFile psiFile = this.myFile;
        Editor editor = this.myEditor;
        final Document document = this.myDocument;
        if (editor == null || psiFile == null || document == null) {
            return;
        }
        VirtualFile file = CoverageEditorAnnotatorImpl.getVirtualFile(psiFile);
        if (file == null || !file.isValid()) {
            return;
        }
        if (this.getOrCreateHighlighters(false) != null) {
            return;
        }
        CoverageEngine engine = suite2.getCoverageEngine();
        Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
        if (module != null && engine.recompileProjectAndRerunAction(module, suite2, () -> CoverageDataManager.getInstance(this.myProject).chooseSuitesBundle(suite2))) {
            return;
        }
        long fileTimeStamp = file.getTimeStamp();
        long coverageTimeStamp = suite2.getLastCoverageTimeStamp();
        CoverageEditorAnnotatorImpl coverageEditorAnnotatorImpl = this;
        synchronized (coverageEditorAnnotatorImpl) {
            if (this.myMapper == null || this.myMapper.getTimeStamp() != coverageTimeStamp) {
                this.myMapper = new LineHistoryMapper(this.myProject, file, document, coverageTimeStamp);
            }
        }
        if (engine.isInLibrarySource(this.myProject, file)) {
            if (fileTimeStamp > coverageTimeStamp) {
                this.showEditorWarningMessage(CoverageBundle.message("coverage.data.outdated", new Object[0]));
                return;
            }
            oldToNewLineMapping = null;
        } else if (this.myMapper.canGetFastMapping()) {
            oldToNewLineMapping = this.myMapper.getOldToNewLineMapping();
            if (oldToNewLineMapping == null && fileTimeStamp > coverageTimeStamp && CoverageEditorAnnotatorImpl.classesArePresentInCoverageData(suite2, engine.getQualifiedNames(psiFile))) {
                this.showEditorWarningMessage(CoverageBundle.message("coverage.data.outdated", new Object[0]));
                return;
            }
        } else {
            oldToNewLineMapping = null;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                Int2IntMap mapping = this.myMapper.getOldToNewLineMapping();
                if (mapping == null) {
                    return;
                }
                this.removeHighlighters();
                this.myUpdateAlarm.cancelAllRequests();
                Object object = this.myLock;
                synchronized (object) {
                    Disposable listenerDisposable = this.myListenerDisposable;
                    if (listenerDisposable != null) {
                        Disposer.dispose((Disposable)listenerDisposable);
                    }
                }
                this.showCoverage(suite2);
            });
        }
        final MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)this.myProject, (boolean)true);
        if (this.getOrCreateHighlighters(true) == null) {
            return;
        }
        final TreeMap<Integer, LineData> executableLines = new TreeMap<Integer, LineData>();
        final TreeMap<Integer, String> classNames = new TreeMap<Integer, String>();
        this.collectLinesInFile(suite2, psiFile, module, oldToNewLineMapping, markupModel, executableLines, classNames);
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CoverageEditorAnnotatorImpl.this.myMapper.clear();
                int offset = e.getOffset();
                int lineNumber = document.getLineNumber(offset);
                int lastLineNumber = document.getLineNumber(offset + e.getNewLength());
                if (!CoverageEditorAnnotatorImpl.this.removeChangedHighlighters(lineNumber, lastLineNumber, document)) {
                    return;
                }
                if (!CoverageEditorAnnotatorImpl.this.myUpdateAlarm.isDisposed()) {
                    CoverageEditorAnnotatorImpl.this.myUpdateAlarm.addRequest(() -> {
                        Int2IntMap newToOldLineMapping;
                        Int2IntMap int2IntMap = newToOldLineMapping = CoverageEditorAnnotatorImpl.this.myMapper.canGetFastMapping() ? CoverageEditorAnnotatorImpl.this.myMapper.getNewToOldLineMapping() : null;
                        if (newToOldLineMapping != null) {
                            int lastLine = Math.min(document.getLineCount() - 1, lastLineNumber);
                            for (int line = lineNumber; line <= lastLine; ++line) {
                                int oldLineNumber;
                                LineData lineData;
                                if (!newToOldLineMapping.containsKey(line) || (lineData = (LineData)executableLines.get(oldLineNumber = newToOldLineMapping.get(line))) == null) continue;
                                CoverageEditorAnnotatorImpl.this.addHighlighter(markupModel, executableLines, suite2, oldLineNumber, line, (String)classNames.get(oldLineNumber));
                            }
                        }
                    }, 100);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/CoverageEditorAnnotatorImpl$1", "documentChanged"));
            }
        };
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDocument != null) {
                this.myListenerDisposable = Disposer.newDisposable((Disposable)this);
                document.addDocumentListener(documentListener, this.myListenerDisposable);
            }
        }
    }

    private synchronized boolean removeChangedHighlighters(int lineNumber, int lastLineNumber, Document document) {
        List<RangeHighlighter> rangeHighlighters = this.getOrCreateHighlighters(false);
        if (rangeHighlighters == null) {
            return false;
        }
        TextRange changeRange = new TextRange(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lastLineNumber));
        Iterator<RangeHighlighter> it = rangeHighlighters.iterator();
        while (it.hasNext()) {
            RangeHighlighter highlighter = it.next();
            if (highlighter.isValid() && !highlighter.getTextRange().intersects(changeRange)) continue;
            ApplicationManager.getApplication().invokeLater(() -> highlighter.dispose());
            it.remove();
        }
        return true;
    }

    protected void collectLinesInFile(final @NotNull CoverageSuitesBundle suite2, final @NotNull PsiFile psiFile, Module module, final Int2IntMap oldToNewLineMapping, final @NotNull MarkupModel markupModel, final @NotNull TreeMap<Integer, LineData> executableLines, final @NotNull TreeMap<Integer, String> classNames) {
        if (suite2 == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(1);
        }
        if (markupModel == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(2);
        }
        if (executableLines == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(3);
        }
        if (classNames == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(4);
        }
        final Editor editor = this.myEditor;
        final CoverageEngine engine = suite2.getCoverageEngine();
        final ProjectData data = suite2.getCoverageData();
        if (data == null) {
            this.coverageDataNotFound(suite2);
            return;
        }
        class HighlightersCollector {
            HighlightersCollector() {
            }

            private void collect(File outputFile, String qualifiedName) {
                ClassData fileData = data.getClassData(qualifiedName);
                if (fileData != null) {
                    Object[] lines = fileData.getLines();
                    if (lines != null) {
                        Object[] postProcessedLines;
                        for (Object o : postProcessedLines = engine.postProcessExecutableLines(lines, editor)) {
                            int lineNumberInCurrent;
                            LineData lineData;
                            if (!(o instanceof LineData) || engine.isGeneratedCode(CoverageEditorAnnotatorImpl.this.myProject, qualifiedName, lineData = (LineData)o)) continue;
                            int line = lineData.getLineNumber() - 1;
                            if (oldToNewLineMapping != null) {
                                if (!oldToNewLineMapping.containsKey(line)) continue;
                                lineNumberInCurrent = oldToNewLineMapping.get(line);
                            } else {
                                lineNumberInCurrent = line;
                            }
                            executableLines.put(line, lineData);
                            classNames.put(line, qualifiedName);
                            CoverageEditorAnnotatorImpl.this.addHighlighter(markupModel, executableLines, suite2, line, lineNumberInCurrent, qualifiedName);
                        }
                    }
                } else if (outputFile != null && !CoverageDataManager.getInstance(CoverageEditorAnnotatorImpl.this.myProject).isSubCoverageActive() && engine.includeUntouchedFileInCoverage(qualifiedName, outputFile, psiFile, suite2)) {
                    CoverageEditorAnnotatorImpl.this.highlightNonCoveredFile(outputFile, markupModel, executableLines, suite2, oldToNewLineMapping);
                }
            }
        }
        HighlightersCollector collector = new HighlightersCollector();
        Set<File> outputFiles = engine.getCorrespondingOutputFiles(psiFile, module, suite2);
        if (!outputFiles.isEmpty()) {
            for (File outputFile : outputFiles) {
                String qualifiedName = engine.getQualifiedName(outputFile, psiFile);
                if (qualifiedName == null) continue;
                collector.collect(outputFile, qualifiedName);
            }
        } else {
            for (String qName : engine.getQualifiedNames(psiFile)) {
                collector.collect(null, qName);
            }
        }
    }

    private boolean isCoverageByTestApplicable(CoverageSuitesBundle suite2) {
        boolean subCoverageActive = CoverageDataManager.getInstance(this.myProject).isSubCoverageActive();
        return suite2.isCoverageByTestApplicable() && (!subCoverageActive || !suite2.isCoverageByTestEnabled());
    }

    private static boolean classesArePresentInCoverageData(CoverageSuitesBundle suite2, Set<String> qualifiedNames) {
        ProjectData data = suite2.getCoverageData();
        if (data == null) {
            return false;
        }
        for (String qualifiedName : qualifiedNames) {
            if (data.getClassData(qualifiedName) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static RangeHighlighter createBackgroundHighlighter(MarkupModel markupModel, @NotNull TreeMap<Integer, LineData> executableLines, int line, int lineNumberInCurrent) {
        TextAttributesKey attributesKey;
        EditorColorsScheme scheme;
        TextAttributes attributes;
        if (executableLines == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(5);
        }
        if ((attributes = (scheme = EditorColorsManager.getInstance().getGlobalScheme()).getAttributes(attributesKey = CoverageLineMarkerRenderer.getAttributesKey(line, executableLines))).getBackgroundColor() != null) {
            return markupModel.addLineHighlighter(lineNumberInCurrent, 2999, attributes);
        }
        return null;
    }

    private RangeHighlighter createRangeHighlighter(MarkupModel markupModel, @NotNull TreeMap<Integer, LineData> executableLines, @Nullable String className, int line, int lineNumberInCurrent, @NotNull CoverageSuitesBundle coverageSuite) {
        if (executableLines == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(6);
        }
        if (coverageSuite == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(7);
        }
        RangeHighlighter highlighter = markupModel.addLineHighlighter(lineNumberInCurrent, 5999, null);
        Function newToOldConverter = newLine -> {
            Int2IntMap oldLineMapping = this.myMapper.canGetFastMapping() ? this.myMapper.getNewToOldLineMapping() : null;
            return oldLineMapping != null ? oldLineMapping.getOrDefault(newLine.intValue(), -1) : newLine.intValue();
        };
        Function oldToNewConverter = newLine -> {
            Int2IntMap newLineMapping = this.myMapper.canGetFastMapping() ? this.myMapper.getOldToNewLineMapping() : null;
            return newLineMapping != null ? newLineMapping.getOrDefault(newLine.intValue(), -1) : newLine.intValue();
        };
        LineMarkerRendererWithErrorStripe markerRenderer = coverageSuite.getLineMarkerRenderer(line, className, executableLines, this.isCoverageByTestApplicable(coverageSuite), coverageSuite, (Function<? super Integer, Integer>)newToOldConverter, (Function<? super Integer, Integer>)oldToNewConverter, CoverageDataManager.getInstance(this.myProject).isSubCoverageActive());
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)markerRenderer);
        LineData lineData = className != null ? executableLines.get(line) : null;
        Editor editor = this.myEditor;
        if (lineData != null && lineData.getStatus() == 0 && editor != null) {
            highlighter.setErrorStripeMarkColor(markerRenderer.getErrorStripeColor(editor));
            highlighter.setThinErrorStripeMark(true);
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
        return highlighter;
    }

    private void showEditorWarningMessage(final @Nls String message) {
        Editor textEditor = this.myEditor;
        PsiFile file = this.myFile;
        ApplicationManager.getApplication().invokeLater(() -> {
            FileEditor[] editors;
            if (textEditor == null || textEditor.isDisposed() || file == null) {
                return;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            VirtualFile vFile = file.getVirtualFile();
            assert (vFile != null);
            HashMap<FileEditor, 2> map = (HashMap<FileEditor, 2>)file.getCopyableUserData(NOTIFICATION_PANELS);
            if (map == null) {
                map = new HashMap<FileEditor, 2>();
                file.putCopyableUserData(NOTIFICATION_PANELS, map);
            }
            for (FileEditor editor : editors = fileEditorManager.getAllEditors(vFile)) {
                if (!this.isCurrentEditor(editor)) continue;
                EditorNotificationPanel panel = new EditorNotificationPanel(editor, EditorNotificationPanel.Status.Warning){
                    {
                        super(arg0, arg1);
                        this.myLabel.setIcon(AllIcons.General.ExclMark);
                        this.myLabel.setText(message);
                    }
                };
                panel.createActionLabel(CoverageBundle.message("link.label.close", new Object[0]), () -> fileEditorManager.removeTopComponent(editor, (JComponent)panel));
                map.put(editor, panel);
                fileEditorManager.addTopComponent(editor, (JComponent)panel);
                break;
            }
        });
    }

    private boolean isCurrentEditor(FileEditor editor) {
        return editor instanceof TextEditor && ((TextEditor)editor).getEditor() == this.myEditor;
    }

    private void highlightNonCoveredFile(File outputFile, MarkupModel markupModel, TreeMap<Integer, LineData> executableLines, @NotNull CoverageSuitesBundle coverageSuite, Int2IntMap mapping) {
        Document document;
        if (coverageSuite == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(8);
        }
        if ((document = this.myDocument) == null) {
            return;
        }
        int lineCount = document.getLineCount();
        IntRange uncoveredLines = coverageSuite.getCoverageEngine().collectSrcLinesForUntouchedFile(outputFile, coverageSuite);
        if (uncoveredLines != null) {
            for (int lineNumber : uncoveredLines) {
                if (executableLines.containsKey(lineNumber)) continue;
                executableLines.put(lineNumber, new LineData(lineNumber, "unknown"));
            }
        }
        Iterator<Integer> iterator = (uncoveredLines != null ? uncoveredLines : new IntRange(0, lineCount - 1)).iterator();
        while (iterator.hasNext()) {
            int lineNumber;
            int newLine = lineNumber = iterator.next().intValue();
            if (mapping != null) {
                if (!mapping.containsKey(lineNumber)) continue;
                newLine = mapping.get(lineNumber);
            }
            this.addHighlighter(markupModel, executableLines, coverageSuite, lineNumber, newLine, null);
        }
    }

    protected final void addHighlighter(MarkupModel markupModel, @NotNull TreeMap<Integer, LineData> executableLines, CoverageSuitesBundle coverageSuite, int lineNumber, int updatedLineNumber, @Nullable String className) {
        if (executableLines == null) {
            CoverageEditorAnnotatorImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Editor editor = this.myEditor;
            Document document = this.myDocument;
            if (editor == null || editor.isDisposed() || document == null) {
                return;
            }
            if (updatedLineNumber < 0 || updatedLineNumber >= document.getLineCount()) {
                return;
            }
            if (lineNumber < 0) {
                return;
            }
            RangeHighlighter highlighter = this.createRangeHighlighter(markupModel, executableLines, className, lineNumber, updatedLineNumber, coverageSuite);
            this.registerOrDisposeHighlighter(highlighter);
            RangeHighlighter backgroundHighlighter = CoverageEditorAnnotatorImpl.createBackgroundHighlighter(markupModel, executableLines, lineNumber, updatedLineNumber);
            if (backgroundHighlighter != null) {
                this.registerOrDisposeHighlighter(backgroundHighlighter);
            }
        });
    }

    private static VirtualFile getVirtualFile(PsiFile file) {
        VirtualFile vFile = file.getVirtualFile();
        LOG.assertTrue(vFile != null);
        return vFile;
    }

    private void coverageDataNotFound(CoverageSuitesBundle suite2) {
        this.showEditorWarningMessage(CoverageBundle.message("coverage.data.not.found", new Object[0]));
        for (CoverageSuite coverageSuite : suite2.getSuites()) {
            CoverageDataManager.getInstance(this.myProject).removeCoverageSuite(coverageSuite);
        }
    }

    public void dispose() {
        this.hideCoverage();
        this.myEditor = null;
        this.myDocument = null;
        this.myFile = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableLines";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/CoverageEditorAnnotatorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectLinesInFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createBackgroundHighlighter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createRangeHighlighter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightNonCoveredFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addHighlighter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

