/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intentions.XmlChooseColorIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.codeInsight.intentions.JavaFxInjectPageLanguageIntention;
import org.jetbrains.plugins.javaFX.fxml.codeInsight.intentions.JavaFxWrapWithDefineIntention;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxBuiltInTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxColorReference;

public final class JavaFxAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        List<String> langs;
        XmlTagValue tagValue;
        PsiFile containingFile;
        if (element == null) {
            JavaFxAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JavaFxAnnotator.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(containingFile = holder.getCurrentAnnotationSession().getFile())) {
            return;
        }
        if (element instanceof XmlAttributeValue) {
            String value = ((XmlAttributeValue)element).getValue();
            if (!JavaFxPsiUtil.isExpressionBinding(value) && !JavaFxPsiUtil.isIncorrectExpressionBinding(value)) {
                PsiReference[] references;
                for (PsiReference reference : references = element.getReferences()) {
                    if (reference instanceof JavaFxColorReference) {
                        JavaFxAnnotator.attachColorIcon(element, holder, StringUtil.unquoteString((String)element.getText()));
                        continue;
                    }
                    PsiElement resolve = reference.resolve();
                    if (!(resolve instanceof PsiMember) || JavaFxPsiUtil.isVisibleInFxml((PsiMember)resolve)) continue;
                    String symbolPresentation = "'" + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)resolve) + "'";
                    AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, symbolPresentation + (resolve instanceof PsiClass ? JavaFXBundle.message("javafx.annotator.should.be.public", new Object[0]) : JavaFXBundle.message("javafx.annotator.should.be.public.or.fxml.annotated", new Object[0])));
                    if (!(resolve instanceof PsiClass)) {
                        AddAnnotationFix fix = new AddAnnotationFix("javafx.fxml.FXML", (PsiModifierListOwner)((PsiMember)resolve), ArrayUtilRt.EMPTY_STRING_ARRAY);
                        builder = builder.withFix((IntentionAction)fix).newFix((IntentionAction)fix).batch().registerFix();
                    }
                    builder.create();
                }
            }
        } else if (element instanceof XmlAttribute) {
            XmlTag referencedTag;
            XmlTag xmlTag;
            XmlAttributeValue valueElement;
            XmlAttribute attribute = (XmlAttribute)element;
            String attributeName = attribute.getName();
            if (!FxmlConstants.FX_BUILT_IN_ATTRIBUTES.contains(attributeName) && !attribute.isNamespaceDeclaration() && JavaFxPsiUtil.isReadOnly(attributeName, attribute.getParent())) {
                holder.newAnnotation(HighlightSeverity.ERROR, JavaFXBundle.message("javafx.annotator.property.is.read.only", attributeName)).range(element.getNavigationElement()).create();
            }
            if ("source".equals(attributeName) && (valueElement = attribute.getValueElement()) != null && (xmlTag = attribute.getParent()) != null && (referencedTag = JavaFxBuiltInTagDescriptor.getReferencedTag(xmlTag)) != null) {
                if (referencedTag.getTextOffset() > xmlTag.getTextOffset()) {
                    holder.newAnnotation(HighlightSeverity.ERROR, JavaFXBundle.message("javafx.annotator.value.not.found", valueElement.getValue())).range(valueElement.getValueTextRange()).create();
                } else if (xmlTag.getParentTag() == referencedTag.getParentTag()) {
                    holder.newAnnotation(HighlightSeverity.ERROR, JavaFXBundle.message("javafx.annotator.duplicate.child.added", new Object[0])).range(valueElement.getValueTextRange()).withFix((IntentionAction)new JavaFxWrapWithDefineIntention(referencedTag, valueElement.getValue())).create();
                }
            }
        } else if (element instanceof XmlTag && "fx:script".equals(((XmlTag)element).getName()) && !StringUtil.isEmptyOrSpaces((String)(tagValue = ((XmlTag)element).getValue()).getText()) && (langs = JavaFxPsiUtil.parseInjectedLanguages((XmlFile)element.getContainingFile())).isEmpty()) {
            ASTNode openTag = element.getNode().findChildByType(XmlTokenType.XML_NAME);
            holder.newAnnotation(HighlightSeverity.ERROR, JavaFXBundle.message("javafx.annotator.page.language.not.specified", new Object[0])).range(openTag != null ? openTag.getPsi() : element).withFix((IntentionAction)new JavaFxInjectPageLanguageIntention()).create();
        }
    }

    private static void attachColorIcon(PsiElement element, AnnotationHolder holder, String attributeValueText) {
        try {
            Color color = null;
            if (attributeValueText.startsWith("#")) {
                color = ColorUtil.fromHex((String)attributeValueText.substring(1));
            } else {
                String hexCode = ColorMap.getHexCodeForColorName((String)StringUtil.toLowerCase((String)attributeValueText));
                if (hexCode != null) {
                    color = ColorUtil.fromHex((String)hexCode);
                }
            }
            if (color != null) {
                ColorIcon icon = (ColorIcon)JBUIScale.scaleIcon((JBScalableIcon)new ColorIcon(8, color));
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).gutterIconRenderer((GutterIconRenderer)new ColorIconRenderer(icon, element)).create();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ColorIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final ColorIcon myIcon;
        private final PsiElement myElement;

        ColorIconRenderer(ColorIcon icon, PsiElement element) {
            this.myIcon = icon;
            this.myElement = element;
        }

        @NotNull
        public Icon getIcon() {
            ColorIcon colorIcon = this.myIcon;
            if (colorIcon == null) {
                ColorIconRenderer.$$$reportNull$$$0(0);
            }
            return colorIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ColorIconRenderer renderer = (ColorIconRenderer)((Object)o);
            return !(this.myElement != null ? !this.myElement.equals(renderer.myElement) : renderer.myElement != null);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        public AnAction getClickAction() {
            return new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Editor editor;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
                        XmlChooseColorIntentionAction.chooseColor((JComponent)editor.getComponent(), (PsiElement)myElement);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxAnnotator$ColorIconRenderer$1", "actionPerformed"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxAnnotator$ColorIconRenderer", "getIcon"));
        }
    }
}

