/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.UrlFilePath;
import com.intellij.openapi.vfs.VersionManagingFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Paths {
    public static final char DELIM = '/';
    private static boolean myIsCaseSensitive;

    public static String getNameOf(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1 || path.length() == 1) {
            return path;
        }
        return path.substring(i + 1);
    }

    public static String getParentOf(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            return "";
        }
        if (i == 0) {
            i = 1;
        }
        return path.substring(0, i);
    }

    public static String appended(String path, String child) {
        path = Paths.appendParent(path);
        return path + child;
    }

    public static String renamed(String path, String newName) {
        return Paths.appended(Paths.getParentOf(path), newName);
    }

    public static String reparented(String path, String newParentPath) {
        return Paths.appended(newParentPath, Paths.getNameOf(path));
    }

    public static String relativeIfUnder(String path, String root) {
        if (!Paths.isParent(root, path)) {
            return null;
        }
        if ((path = path.substring(root.length())).length() == 0) {
            return "";
        }
        if (path.charAt(0) != '/') {
            return null;
        }
        return path.substring(1);
    }

    public static Iterable<String> split(String path) {
        String root = FileUtil.extractRootPath((String)path);
        if (root == null) {
            return Paths.splitInner(path);
        }
        if (root.length() + 1 == path.length() && path.endsWith("/")) {
            return Collections.singleton(root);
        }
        List<String> tail = Paths.splitInner(path.substring(root.length()));
        return ContainerUtil.concat(Collections.singletonList(root), tail);
    }

    @NotNull
    private static List<String> splitInner(String path) {
        if (path.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                Paths.$$$reportNull$$$0(0);
            }
            return list;
        }
        int s = 0;
        int e = path.length();
        if (path.charAt(0) == '/') {
            ++s;
        }
        if (e > s && path.charAt(e - 1) == '/') {
            --e;
        }
        List list = StringUtil.split((String)path.substring(s, e), (String)String.valueOf('/'), (boolean)true, (boolean)false);
        if (list == null) {
            Paths.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static boolean isParent(String parent, String path) {
        if (Paths.equals(parent, path)) {
            return true;
        }
        parent = Paths.appendParent(parent);
        return myIsCaseSensitive ? path.startsWith(parent) : StringUtil.startsWithIgnoreCase((String)path, (String)parent);
    }

    private static String appendParent(String parent) {
        if (((String)parent).isEmpty()) {
            return parent;
        }
        if (((String)parent).charAt(((String)parent).length() - 1) != '/') {
            parent = (String)parent + "/";
        }
        return parent;
    }

    public static boolean isParentOrChild(String p1, String p2) {
        return Paths.isParent(p1, p2) || Paths.isParent(p2, p1);
    }

    public static boolean equals(String p1, String p2) {
        return myIsCaseSensitive ? p1.equals(p2) : p1.equalsIgnoreCase(p2);
    }

    public static void setCaseSensitive(boolean b) {
        myIsCaseSensitive = b;
    }

    public static boolean isCaseSensitive() {
        return myIsCaseSensitive;
    }

    public static void useSystemCaseSensitivity() {
        myIsCaseSensitive = SystemInfo.isFileSystemCaseSensitive;
    }

    @NotNull
    public static FilePath createDvcsFilePath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            Paths.$$$reportNull$$$0(2);
        }
        return path.contains("://") ? new UrlFilePath(path, isDirectory) : new LocalFilePath(path, isDirectory);
    }

    @NotNull
    public static FilePath createDvcsFilePath(@NotNull VirtualFile file) {
        if (file == null) {
            Paths.$$$reportNull$$$0(3);
        }
        if (VersionManagingFileSystem.isEnforcedNonLocal((VirtualFile)file)) {
            return new UrlFilePath(file.getUrl(), file.isDirectory());
        }
        return new LocalFilePath(file.getPath(), file.isDirectory());
    }

    static {
        Paths.useSystemCaseSensitivity();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/core/Paths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "splitInner";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/core/Paths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDvcsFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

