/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventIdName;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0000*\u0006\b\u0001\u0010\u0002 \u00002\u00020\u0003B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0013H\u0016J\u001b\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0014\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0007H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\nX\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "T1", "T2", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "", "description", "field1", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "field2", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/events/EventField;Lcom/intellij/internal/statistic/eventLog/events/EventField;)V", "buildUsageData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "value1", "value2", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "getFields", "", "log", "", "(Ljava/lang/Object;Ljava/lang/Object;)V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Ljava/lang/Object;)V", "metric", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/internal/statistic/beans/MetricEvent;", "toString", "intellij.platform.statistics"})
public final class EventId2<T1, T2>
extends BaseEventId {
    @NotNull
    private final EventLogGroup group;
    @NotNull
    private final EventField<T1> field1;
    @NotNull
    private final EventField<T2> field2;

    public EventId2(@NotNull EventLogGroup group, @EventIdName @NonNls @NotNull String eventId, @NonNls @Nullable String description, @NotNull EventField<T1> field1, @NotNull EventField<T2> field2) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(field1, (String)"field1");
        Intrinsics.checkNotNullParameter(field2, (String)"field2");
        super(eventId, group.getRecorder(), description);
        this.group = group;
        this.field1 = field1;
        this.field2 = field2;
    }

    public final void log(T1 value1, T2 value2) {
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), this.buildUsageData(value1, value2).build(), false);
    }

    public final void log(@Nullable Project project, T1 value1, T2 value2) {
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), this.buildUsageData(value1, value2).addProject(project).build(), false);
    }

    @NotNull
    public final MetricEvent metric(T1 value1, T2 value2) {
        return new MetricEvent(this.getEventId(), this.buildUsageData(value1, value2), this.group.getRecorder());
    }

    private final FeatureUsageData buildUsageData(T1 value1, T2 value2) {
        FeatureUsageData data = new FeatureUsageData(this.group.getRecorder());
        this.field1.addData(data, value1);
        this.field2.addData(data, value2);
        return data;
    }

    @Override
    @NotNull
    public List<EventField<?>> getFields() {
        Object[] objectArray = new EventField[]{this.field1, this.field2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String toString() {
        return "EventId2(eventId='" + this.getEventId() + "')";
    }
}

