/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.CompilerReferenceWriter;
import org.jetbrains.jps.backwardRefs.JavaCompilerBackwardReferenceIndex;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.javac.ast.api.JavacRef;

public final class JavaBackwardReferenceIndexWriter
extends CompilerReferenceWriter<CompiledFileData> {
    public static final String PROP_KEY = "jps.backward.ref.index.builder";
    public static final String FS_KEY = "jps.backward.ref.index.builder.fs.case.sensitive";
    private static volatile JavaBackwardReferenceIndexWriter ourInstance;
    private static int ourInitAttempt;

    private JavaBackwardReferenceIndexWriter(JavaCompilerBackwardReferenceIndex index) {
        super(index);
    }

    public static synchronized void closeIfNeeded(boolean clearIndex) {
        if (ourInstance != null) {
            File dir = clearIndex ? JavaBackwardReferenceIndexWriter.ourInstance.myIndex.getIndicesDir() : null;
            try {
                ourInstance.close();
            }
            finally {
                ourInstance = null;
                if (dir != null) {
                    FileUtil.delete((File)dir);
                }
            }
        }
    }

    static JavaBackwardReferenceIndexWriter getInstance() {
        return ourInstance;
    }

    public static void initialize(@NotNull CompileContext context) {
        if (context == null) {
            JavaBackwardReferenceIndexWriter.$$$reportNull$$$0(0);
        }
        if (ourInstance != null) {
            return;
        }
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        File buildDir = dataManager.getDataPaths().getDataStorageRoot();
        if (JavaBackwardReferenceIndexWriter.isEnabled()) {
            boolean isRebuild = JavaBackwardReferenceIndexWriter.isRebuildInAllJavaModules(context);
            if (!"Javac".equals(JavaBuilder.getUsedCompilerId(context)) || !((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue()) {
                CompilerReferenceIndex.removeIndexFiles(buildDir);
                return;
            }
            boolean cleanupOk = true;
            if (isRebuild) {
                CompilerReferenceIndex.removeIndexFiles(buildDir);
                cleanupOk = !CompilerReferenceIndex.exists(buildDir);
            } else if (CompilerReferenceIndex.versionDiffers(buildDir, 7)) {
                CompilerReferenceIndex.removeIndexFiles(buildDir);
                if (ourInitAttempt++ == 0 && JavaBackwardReferenceIndexWriter.areAllJavaModulesAffected(context)) {
                    throw new BuildDataCorruptedException("backward reference index will be updated to actual version");
                }
                return;
            }
            if (cleanupOk) {
                JavaCompilerBackwardReferenceIndex index = new JavaCompilerBackwardReferenceIndex(buildDir, dataManager.getRelativizer(), false, JavaBackwardReferenceIndexWriter.isCompilerReferenceFSCaseSensitive());
                ourInstance = new JavaBackwardReferenceIndexWriter(index);
                ShutDownTracker.getInstance().registerShutdownTask(() -> JavaBackwardReferenceIndexWriter.closeIfNeeded(false));
            }
        } else {
            CompilerReferenceIndex.removeIndexFiles(buildDir);
        }
    }

    public static boolean isEnabled() {
        return SystemProperties.getBooleanProperty((String)PROP_KEY, (boolean)false);
    }

    @ApiStatus.Experimental
    public static boolean isCompilerReferenceFSCaseSensitive() {
        String value = System.getProperty(FS_KEY);
        if (value == null) {
            return SystemInfo.isFileSystemCaseSensitive;
        }
        return Boolean.parseBoolean(value);
    }

    @NotNull
    synchronized CompilerRef.JavaCompilerClassRef asClassUsage(JavacRef aClass) throws IOException {
        return new CompilerRef.JavaCompilerClassRef(JavaBackwardReferenceIndexWriter.id(aClass, this.myIndex.getByteSeqEum()));
    }

    @Nullable
    CompilerRef enumerateNames(JavacRef ref, Function<? super String, Integer> ownerIdReplacer) throws IOException {
        NameEnumerator nameEnumerator = this.myIndex.getByteSeqEum();
        if (ref instanceof JavacRef.JavacClass) {
            if (!JavaBackwardReferenceIndexWriter.isPrivate(ref) && !((JavacRef.JavacClass)ref).isAnonymous()) {
                return new CompilerRef.JavaCompilerClassRef(JavaBackwardReferenceIndexWriter.id(ref, nameEnumerator));
            }
        } else {
            if (JavaBackwardReferenceIndexWriter.isPrivate(ref)) {
                return null;
            }
            String ownerName = ref.getOwnerName();
            Integer ownerPrecalculatedId = (Integer)ownerIdReplacer.fun((Object)ownerName);
            if (ref instanceof JavacRef.JavacField) {
                return new CompilerRef.JavaCompilerFieldRef(ownerPrecalculatedId != null ? ownerPrecalculatedId : JavaBackwardReferenceIndexWriter.id(ownerName, nameEnumerator), JavaBackwardReferenceIndexWriter.id(ref, nameEnumerator));
            }
            if (ref instanceof JavacRef.JavacMethod) {
                byte paramCount = ((JavacRef.JavacMethod)ref).getParamCount();
                return new CompilerRef.JavaCompilerMethodRef(ownerPrecalculatedId != null ? ownerPrecalculatedId : JavaBackwardReferenceIndexWriter.id(ownerName, nameEnumerator), JavaBackwardReferenceIndexWriter.id(ref, nameEnumerator), paramCount);
            }
            throw new AssertionError((Object)("unexpected symbol: " + ref + " class: " + ref.getClass()));
        }
        return null;
    }

    private static boolean isPrivate(JavacRef ref) {
        return ref.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    private static int id(JavacRef ref, NameEnumerator nameEnumerator) throws IOException {
        return JavaBackwardReferenceIndexWriter.id(ref.getName(), nameEnumerator);
    }

    private static int id(String name, NameEnumerator nameEnumerator) throws IOException {
        return nameEnumerator.enumerate(name);
    }

    private static boolean isRebuildInAllJavaModules(CompileContext context) {
        for (JavaModuleBuildTargetType type : JavaModuleBuildTargetType.ALL_TYPES) {
            for (ModuleBuildTarget target : context.getProjectDescriptor().getBuildTargetIndex().getAllTargets(type)) {
                if (context.getScope().isBuildForced(target)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean areAllJavaModulesAffected(CompileContext context) {
        for (JavaModuleBuildTargetType type : JavaModuleBuildTargetType.ALL_TYPES) {
            for (ModuleBuildTarget target : context.getProjectDescriptor().getBuildTargetIndex().getAllTargets(type)) {
                if (context.getScope().isWholeTargetAffected(target)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        ourInitAttempt = 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/backwardRefs/JavaBackwardReferenceIndexWriter", "initialize"));
    }
}

