/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.Utils;

public final class FileNode
implements Node<FileNode, Diff> {
    private final JvmNodeReferenceID myId;
    private final Iterable<Usage> myUsages;

    public FileNode(String name, @NotNull Iterable<Usage> usages) {
        if (usages == null) {
            FileNode.$$$reportNull$$$0(0);
        }
        this.myId = new JvmNodeReferenceID(name);
        this.myUsages = usages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileNode(GraphDataInput in) throws IOException {
        this.myId = new JvmNodeReferenceID(in);
        SmartList usages = new SmartList();
        try {
            int groupCount = in.readInt();
            while (groupCount-- > 0) {
                in.readGraphElementCollection(usages);
            }
        }
        finally {
            this.myUsages = usages;
        }
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        this.myId.write(out);
        HashMap<Class, List> usageGroups = new HashMap<Class, List>();
        for (Usage usage : this.myUsages) {
            usageGroups.computeIfAbsent(usage.getClass(), k -> new SmartList()).add(usage);
        }
        out.writeInt(usageGroups.size());
        for (Map.Entry entry : usageGroups.entrySet()) {
            out.writeGraphElementCollection((Class)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    @Override
    @NotNull
    public JvmNodeReferenceID getReferenceID() {
        JvmNodeReferenceID jvmNodeReferenceID = this.myId;
        if (jvmNodeReferenceID == null) {
            FileNode.$$$reportNull$$$0(1);
        }
        return jvmNodeReferenceID;
    }

    @NotNull
    public String getName() {
        String string = this.myId.getNodeName();
        if (string == null) {
            FileNode.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public Iterable<Usage> getUsages() {
        return this.myUsages;
    }

    @Override
    public boolean isSame(DiffCapable<?, ?> other) {
        if (!(other instanceof FileNode)) {
            return false;
        }
        FileNode that = (FileNode)other;
        return this.myId.equals(that.myId);
    }

    @Override
    public int diffHashCode() {
        return this.myId.hashCode();
    }

    @Override
    public Diff difference(FileNode past) {
        return new Diff(past);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/FileNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/FileNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Diff
    implements Difference {
        private final Supplier<Difference.Specifier<Usage, ?>> myUsagesDiff = Utils.lazyValue(() -> Difference.diff(past.getUsages(), FileNode.this.getUsages()));

        public Diff(FileNode past) {
        }

        @Override
        public boolean unchanged() {
            return this.usages().unchanged();
        }

        public Difference.Specifier<Usage, ?> usages() {
            return this.myUsagesDiff.get();
        }
    }
}

