/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginAction;
import org.jetbrains.plugins.gradle.codeInsight.actions.PluginDescriptor;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;

class AddGradleDslPluginActionHandler
implements CodeInsightActionHandler {
    private final List<PluginDescriptor> myPlugins;

    AddGradleDslPluginActionHandler(List<PluginDescriptor> plugins) {
        this.myPlugins = plugins;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            AddGradleDslPluginActionHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AddGradleDslPluginActionHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AddGradleDslPluginActionHandler.$$$reportNull$$$0(2);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{file})) {
            return;
        }
        JBList list = new JBList(this.myPlugins);
        list.setSelectionMode(0);
        list.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
        Runnable runnable = () -> {
            PluginDescriptor selected = (PluginDescriptor)list.getSelectedValue();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName(GradleBundle.message((String)"gradle.codeInsight.action.apply_plugin.text", (Object[])new Object[0])).run(() -> {
                if (selected == null) {
                    return;
                }
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
                GrStatement grStatement = factory.createStatementFromText((CharSequence)String.format("apply plugin: '%s'", selected.name()), null);
                PsiElement anchor = file.findElementAt(editor.getCaretModel().getOffset());
                PsiElement currentElement = PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{GrClosableBlock.class, GroovyFile.class});
                if (currentElement != null) {
                    currentElement.addAfter((PsiElement)grStatement, anchor);
                } else {
                    file.addAfter((PsiElement)grStatement, file.findElementAt(editor.getCaretModel().getOffset() - 1));
                }
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = documentManager.getDocument(file);
                if (document != null) {
                    documentManager.commitDocument(document);
                }
            });
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PluginDescriptor descriptor = (PluginDescriptor)ContainerUtil.find(this.myPlugins, value -> value.name().equals(AddGradleDslPluginAction.TEST_THREAD_LOCAL.get()));
            list.setSelectedValue((Object)descriptor, false);
            runnable.run();
        } else {
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(GradleBundle.message((String)"gradle.codeInsight.action.apply_plugin.popup.title", (Object[])new Object[0])).setItemChosenCallback(runnable).setNamerForFiltering(o -> o.name()).createPopup().showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginActionHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyListCellRenderer
    implements ListCellRenderer<PluginDescriptor> {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myNameLabel;
        private final JLabel myDescLabel;

        MyListCellRenderer() {
            this.myPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
            this.myNameLabel = new JLabel();
            this.myPanel.add((Component)this.myNameLabel, "West");
            this.myPanel.add(new JLabel("     "));
            this.myDescLabel = new JLabel();
            this.myPanel.add((Component)this.myDescLabel, "East");
            Font font = EditorFontType.getGlobalPlainFont();
            this.myNameLabel.setFont(font);
            this.myDescLabel.setFont(font);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PluginDescriptor> list, PluginDescriptor value, int index, boolean isSelected, boolean cellHasFocus) {
            Color backgroundColor = isSelected ? list.getSelectionBackground() : list.getBackground();
            this.myNameLabel.setText(value.name());
            this.myNameLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.myPanel.setBackground(backgroundColor);
            String description = new HtmlBuilder().append(value.description()).wrapWith(HtmlChunk.div().attr("WIDTH", "400")).wrapWith("html").toString();
            this.myDescLabel.setText(description);
            this.myDescLabel.setForeground(LookupCellRenderer.getGrayedForeground((boolean)isSelected));
            this.myDescLabel.setBackground(backgroundColor);
            return this.myPanel;
        }
    }
}

