/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.core.util.TermSize;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.TerminalFocusModel;
import org.jetbrains.plugins.terminal.block.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.block.output.BlockTerminalSearchSession;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputController;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionController;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptController;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModelKt;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderingInfo;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.ShellCommandExecutionManager;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandSentListener;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.fus.TerminalShellInfoStatistics;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 02\u00020\u0001:\u0002/0B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u001a\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00112\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0018H\u0007J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\b\u0010$\u001a\u00020\u0018H\u0002J\u000e\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'J\u001c\u0010(\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0003J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0007J\b\u0010.\u001a\u00020\u0018H\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/plugins/terminal/block/BlockTerminalController;", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "outputController", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;", "promptController", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;", "selectionController", "Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionController;", "focusModel", "Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionController;Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;)V", "listeners", "", "Lorg/jetbrains/plugins/terminal/block/BlockTerminalController$BlockTerminalControllerListener;", "<set-?>", "Lorg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession;", "searchSession", "getSearchSession", "()Lorg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession;", "activateSearchSession", "", "addListener", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "finishCommandBlock", "exitCode", "", "finishSearchSession", "getDisposed", "Lkotlin/Function0;", "", "onSearchClosed", "resize", "newSize", "Lcom/jediterm/core/util/TermSize;", "startCommandBlock", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "startCommandExecution", "startSearchSession", "BlockTerminalControllerListener", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nBlockTerminalController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalController.kt\norg/jetbrains/plugins/terminal/block/BlockTerminalController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1855#2,2:202\n1855#2,2:205\n1#3:204\n*S KotlinDebug\n*F\n+ 1 BlockTerminalController.kt\norg/jetbrains/plugins/terminal/block/BlockTerminalController\n*L\n155#1:202,2\n175#1:205,2\n*E\n"})
public final class BlockTerminalController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final TerminalOutputController outputController;
    @NotNull
    private final TerminalPromptController promptController;
    @NotNull
    private final TerminalSelectionController selectionController;
    @NotNull
    private final TerminalFocusModel focusModel;
    @NotNull
    private final List<BlockTerminalControllerListener> listeners;
    @Nullable
    private BlockTerminalSearchSession searchSession;
    @NotNull
    private static final DataKey<BlockTerminalController> KEY = DataKey.Companion.create("BlockTerminalController");

    public BlockTerminalController(@NotNull Project project, @NotNull BlockTerminalSession session2, @NotNull TerminalOutputController outputController, @NotNull TerminalPromptController promptController, @NotNull TerminalSelectionController selectionController, @NotNull TerminalFocusModel focusModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputController, (String)"outputController");
        Intrinsics.checkNotNullParameter((Object)promptController, (String)"promptController");
        Intrinsics.checkNotNullParameter((Object)selectionController, (String)"selectionController");
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        this.project = project;
        this.session = session2;
        this.outputController = outputController;
        this.promptController = promptController;
        this.selectionController = selectionController;
        this.focusModel = focusModel;
        this.listeners = new CopyOnWriteArrayList();
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void initialized() {
                this.finishCommandBlock(0);
            }

            @Override
            public void shellInfoReceived(@NotNull String rawShellInfo) {
                Intrinsics.checkNotNullParameter((Object)rawShellInfo, (String)"rawShellInfo");
                1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Started shell info: " + rawShellInfo);
                ApplicationManager.getApplication().executeOnPooledThread(() -> 1.shellInfoReceived$lambda$1(rawShellInfo, this));
            }

            @Override
            public void commandFinished(@NotNull CommandFinishedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.finishCommandBlock(event.getExitCode());
                TerminalUsageTriggerCollector.INSTANCE.triggerCommandFinished-Wn2Vu4Y(project, event.getCommand(), event.getExitCode(), event.getDuration-UwyO8pc());
            }

            @Override
            public void commandStarted(@NotNull String command2) {
                Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
                Function0 function0 = this.getDisposed();
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                TerminalUiUtilsKt.invokeLater((Function0<Boolean>)function0, modalityState, () -> 1.commandStarted$lambda$2(this, command2));
            }

            private static final void shellInfoReceived$lambda$1(String $rawShellInfo, BlockTerminalController this$0) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)$rawShellInfo, (String)"$rawShellInfo");
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    TerminalShellInfoStatistics.LoggableShellInfo loggableShellInfo = TerminalShellInfoStatistics.INSTANCE.getLoggableShellInfo($rawShellInfo);
                    if (loggableShellInfo == null) break block0;
                    TerminalShellInfoStatistics.LoggableShellInfo it = loggableShellInfo;
                    boolean bl = false;
                    TerminalUsageTriggerCollector.INSTANCE.triggerLocalShellStarted$intellij_terminal(this$0.project, this$0.session.getShellIntegration().getShellType().toString(), it);
                }
            }

            private static final void commandStarted$lambda$2(BlockTerminalController this$0, String $command) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
                if (!this$0.outputController.isCommandRunning()) {
                    this$0.startCommandBlock($command, this$0.promptController.getModel().getRenderingInfo());
                }
            }
        }, null, 2, null);
        ShellCommandExecutionManager.addListener$default(this.session.getCommandExecutionManager$intellij_terminal(), new ShellCommandSentListener(){

            @Override
            public void userCommandSent(@NotNull String userCommand) {
                Intrinsics.checkNotNullParameter((Object)userCommand, (String)"userCommand");
                Function0 function0 = this.getDisposed();
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                TerminalUiUtilsKt.invokeLaterIfNeeded((Function0<Boolean>)function0, modalityState, () -> 2.userCommandSent$lambda$0(this, userCommand));
            }

            private static final void userCommandSent$lambda$0(BlockTerminalController this$0, String $userCommand) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$userCommand, (String)"$userCommand");
                this$0.outputController.doWhenNextBlockCanBeStarted((Function0<Unit>)((Function0)new Function0<Unit>(this$0, $userCommand){
                    final /* synthetic */ BlockTerminalController this$0;
                    final /* synthetic */ String $userCommand;
                    {
                        this.this$0 = $receiver;
                        this.$userCommand = $userCommand;
                        super(0);
                    }

                    public final void invoke() {
                        BlockTerminalController.access$startCommandBlock(this.this$0, this.$userCommand, BlockTerminalController.access$getPromptController$p(this.this$0).getModel().getRenderingInfo());
                    }
                }));
            }
        }, null, 2, null);
        this.startCommandBlock(null, null);
    }

    @Nullable
    public final BlockTerminalSearchSession getSearchSession() {
        return this.searchSession;
    }

    public final void resize(@NotNull TermSize newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        this.session.postResize(newSize);
    }

    @RequiresEdt
    public final void startCommandExecution(@NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        if (StringsKt.isBlank((CharSequence)command2)) {
            TerminalPromptModelKt.clearCommandAndResetUndoRedoStack(this.promptController.getModel());
            this.outputController.insertEmptyLine();
        } else {
            this.session.getCommandExecutionManager$intellij_terminal().sendCommandToExecute(command2);
            TerminalUsageLocalStorage.Companion.getInstance().recordCommandExecuted(this.session.getShellIntegration().getShellType().toString());
        }
        TerminalUsageTriggerCollector.triggerCommandStarted(this.project, command2, true);
    }

    @RequiresEdt(generateAssertion=false)
    private final void startCommandBlock(String command2, TerminalPromptRenderingInfo prompt) {
        this.outputController.startCommandBlock(command2, prompt);
        Disposable disposable = Disposer.newDisposable((Disposable)this.session);
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        this.outputController.getOutputModel().addListener(new TerminalOutputModelListener(this, disposable2){
            final /* synthetic */ BlockTerminalController this$0;
            final /* synthetic */ Disposable $disposable;
            {
                this.this$0 = $receiver;
                this.$disposable = $disposable;
            }

            public void blockCreated(@NotNull CommandBlock block2) {
                Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
                BlockTerminalController.access$getPromptController$p(this.this$0).setPromptIsVisible(false);
                Disposer.dispose((Disposable)this.$disposable);
            }
        }, disposable2);
        this.session.getModel().setCommandRunning(true);
    }

    private final void finishCommandBlock(int exitCode) {
        this.outputController.finishCommandBlock(exitCode);
        this.session.getModel().setCommandRunning(false);
        Function0<Boolean> function0 = this.getDisposed();
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> BlockTerminalController.finishCommandBlock$lambda$0(this));
    }

    @RequiresEdt
    public final void startSearchSession() {
        BlockTerminalSearchSession session2;
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)this.project).getFindInFileModel());
        findModel.setWholeWordsOnly(false);
        BlockTerminalSearchSession.Companion.setSearchInBlock(findModel, this.selectionController.getPrimarySelection() != null);
        EditorEx editor = this.outputController.getOutputModel().getEditor();
        FindUtil.configureFindModel((boolean)false, (Editor)((Editor)editor), (FindModel)findModel, (boolean)false);
        findModel.setGlobal(false);
        this.searchSession = session2 = new BlockTerminalSearchSession(this.project, editor, findModel, this.outputController.getOutputModel(), this.outputController.getSelectionModel(), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                BlockTerminalController.access$onSearchClosed((BlockTerminalController)this.receiver);
            }
        }));
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockTerminalControllerListener it = (BlockTerminalControllerListener)element$iv;
            boolean bl = false;
            it.searchSessionStarted(session2);
        }
        session2.getComponent().requestFocusInTheSearchFieldAndSelectContent(this.project);
    }

    @RequiresEdt
    public final void activateSearchSession() {
        BlockTerminalSearchSession blockTerminalSearchSession = this.searchSession;
        if (blockTerminalSearchSession == null) {
            return;
        }
        BlockTerminalSearchSession session2 = blockTerminalSearchSession;
        EditorEx editor = this.outputController.getOutputModel().getEditor();
        session2.getComponent().requestFocusInTheSearchFieldAndSelectContent(this.project);
        FindUtil.configureFindModel((boolean)false, (Editor)((Editor)editor), (FindModel)session2.getFindModel(), (boolean)false);
        BlockTerminalSearchSession.Companion.setSearchInBlock(session2.getFindModel(), this.selectionController.getPrimarySelection() != null);
        session2.getFindModel().setGlobal(false);
    }

    @RequiresEdt
    public final void finishSearchSession() {
        block0: {
            BlockTerminalSearchSession blockTerminalSearchSession = this.searchSession;
            if (blockTerminalSearchSession == null) break block0;
            blockTerminalSearchSession.close();
        }
    }

    private final void onSearchClosed() {
        BlockTerminalSearchSession blockTerminalSearchSession = this.searchSession;
        if (blockTerminalSearchSession != null) {
            BlockTerminalSearchSession session2 = blockTerminalSearchSession;
            boolean bl = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockTerminalControllerListener it = (BlockTerminalControllerListener)element$iv;
                boolean bl2 = false;
                it.searchSessionFinished(session2);
            }
        }
        this.searchSession = null;
        if (this.selectionController.getPrimarySelection() != null || this.session.getModel().isCommandRunning()) {
            this.focusModel.focusOutput();
        } else {
            this.focusModel.focusPrompt();
        }
    }

    public final void addListener(@NotNull BlockTerminalControllerListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, () -> BlockTerminalController.addListener$lambda$4(this, listener));
        }
    }

    public static /* synthetic */ void addListener$default(BlockTerminalController blockTerminalController, BlockTerminalControllerListener blockTerminalControllerListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        blockTerminalController.addListener(blockTerminalControllerListener, disposable);
    }

    private final Function0<Boolean> getDisposed() {
        return TerminalUiUtilsKt.getDisposed((Editor)this.outputController.getOutputModel().getEditor());
    }

    private static final void finishCommandBlock$lambda$0(BlockTerminalController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TerminalPromptModelKt.clearCommandAndResetUndoRedoStack(this$0.promptController.getModel());
        this$0.promptController.setPromptIsVisible(true);
    }

    private static final void addListener$lambda$4(BlockTerminalController this$0, BlockTerminalControllerListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.listeners.remove($listener);
    }

    public static final /* synthetic */ void access$onSearchClosed(BlockTerminalController $this) {
        $this.onSearchClosed();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/BlockTerminalController$BlockTerminalControllerListener;", "", "searchSessionFinished", "", "session", "Lcom/intellij/find/SearchSession;", "searchSessionStarted", "intellij.terminal"})
    public static interface BlockTerminalControllerListener {
        default public void searchSessionStarted(@NotNull SearchSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        }

        default public void searchSessionFinished(@NotNull SearchSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/block/BlockTerminalController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/block/BlockTerminalController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<BlockTerminalController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

