/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editor;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.util.JavaXmlDocumentKt;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class EditorColorSchemeTestCase
extends LightPlatformTestCase {
    protected static EditorColorsScheme loadScheme(@NotNull String docText) throws IOException, SAXException {
        if (docText == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(0);
        }
        Document doc = JavaXmlDocumentKt.createDocumentBuilder().parse(new InputSource(new StringReader(docText)));
        Element root2 = new DOMBuilder().build(doc.getDocumentElement());
        EditorColorsScheme defaultScheme = EditorColorsManager.getInstance().getScheme(EditorColorsScheme.getDefaultSchemeName());
        EditorColorsSchemeImpl targetScheme = new EditorColorsSchemeImpl(defaultScheme);
        targetScheme.readExternal(root2);
        return targetScheme;
    }

    @NotNull
    protected Pair<EditorColorsScheme, TextAttributes> doTestWriteRead(@NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        if (key == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(2);
        }
        EditorColorsScheme defaultScheme = EditorColorsManager.getInstance().getScheme(EditorColorsScheme.getDefaultSchemeName());
        EditorColorsScheme sourceScheme = (EditorColorsScheme)defaultScheme.clone();
        sourceScheme.setName("test");
        sourceScheme.setAttributes(key, attributes);
        Element root2 = new Element("scheme");
        ((AbstractColorsScheme)sourceScheme).writeExternal(root2);
        EditorColorsSchemeImpl targetScheme = new EditorColorsSchemeImpl(defaultScheme);
        targetScheme.readExternal(root2);
        EditorColorSchemeTestCase.assertEquals((String)"test", (String)targetScheme.getName());
        TextAttributes targetAttrs = targetScheme.getAttributes(key);
        Pair pair = Pair.create((Object)targetScheme, (Object)targetAttrs);
        if (pair == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(3);
        }
        return pair;
    }

    public static void assertXmlOutputEquals(String expected, Element root2) {
        EditorColorSchemeTestCase.assertEquals((String)expected, (String)JDOMUtil.write((Element)root2));
    }

    protected Element serialize(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(4);
        }
        Element root2 = new Element("scheme");
        ((AbstractColorsScheme)scheme).writeExternal(root2);
        EditorColorSchemeTestCase.fixPlatformSpecificValues(root2);
        root2.removeChildren("metaInfo");
        return root2;
    }

    protected Element serializeWithFixedMeta(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(5);
        }
        Element root2 = new Element("scheme");
        ((AbstractColorsScheme)scheme).writeExternal(root2);
        EditorColorSchemeTestCase.fixPlatformSpecificValues(root2);
        Element metaInfo = root2.getChild("metaInfo");
        if (metaInfo != null) {
            metaInfo.getChildren().forEach(child -> {
                Attribute name = child.getAttribute("name");
                if (!child.getName().equals("property") || name == null || !RainbowHighlighter.isRainbowKey((Object)name.getValue())) {
                    child.removeContent();
                }
            });
        }
        return root2;
    }

    @NotNull
    public static Element serializeWithSelectedMetaInfo(@NotNull AbstractColorsScheme scheme, String ... properties) {
        if (scheme == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(6);
        }
        Element root2 = new Element("scheme");
        scheme.writeExternal(root2);
        EditorColorSchemeTestCase.fixPlatformSpecificValues(root2);
        Element metaInfo = root2.getChild("metaInfo");
        if (metaInfo == null) {
            Element element2 = root2;
            if (element2 == null) {
                EditorColorSchemeTestCase.$$$reportNull$$$0(7);
            }
            return element2;
        }
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (Element element3 : metaInfo.getChildren()) {
            Attribute name = element3.getAttribute("name");
            boolean result2 = false;
            for (String t : properties) {
                if (!t.equals(name.getValue())) continue;
                result2 = true;
                break;
            }
            if (element3.getName().equals("property") && name != null && result2) continue;
            toRemove.add(element3);
        }
        for (Element child : toRemove) {
            metaInfo.removeContent((Content)child);
        }
        Element element4 = root2;
        if (element4 == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(8);
        }
        return element4;
    }

    private static void fixPlatformSpecificValues(@NotNull Element root2) {
        if (root2 == null) {
            EditorColorSchemeTestCase.$$$reportNull$$$0(9);
        }
        ArrayList fontOptions = new ArrayList(root2.getChildren("option"));
        for (Element option : fontOptions) {
            String name = option.getAttributeValue("name");
            if (name == null) continue;
            if ("FONT_SCALE".equals(name) || "EDITOR_FONT_SIZE".equals(name) || "EDITOR_FONT_NAME".equals(name)) {
                root2.removeContent((Content)option);
                continue;
            }
            if (!"CONSOLE_FONT_NAME".equals(name)) continue;
            option.setAttribute("value", "Test");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/editor/EditorColorSchemeTestCase";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/editor/EditorColorSchemeTestCase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doTestWriteRead";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeWithSelectedMetaInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadScheme";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doTestWriteRead";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeWithFixedMeta";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeWithSelectedMetaInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fixPlatformSpecificValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8 -> new IllegalStateException(string);
        };
    }
}

