/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.mock;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetType;
import com.intellij.facet.mock.MockFacetConfiguration;
import com.intellij.facet.mock.MockFacetType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MockFacet
extends Facet<MockFacetConfiguration>
implements FacetRootsProvider {
    private boolean myInitialized;
    private boolean myDisposed;
    private boolean myConfigured;
    private static int constructorCounter;

    public MockFacet(@NotNull Module module2, String name) {
        if (module2 == null) {
            MockFacet.$$$reportNull$$$0(0);
        }
        this(module2, name, new MockFacetConfiguration());
    }

    public MockFacet(Module module2, String name, MockFacetConfiguration configuration) {
        super((FacetType)MockFacetType.getInstance(), module2, name, (FacetConfiguration)configuration, null);
        ++constructorCounter;
    }

    public void initFacet() {
        this.myInitialized = true;
    }

    public void disposeFacet() {
        this.myDisposed = true;
    }

    public boolean isConfigured() {
        return this.myConfigured;
    }

    public void configure() {
        this.myConfigured = true;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void addRoot(VirtualFile root2) {
        ((MockFacetConfiguration)this.getConfiguration()).addRoot(root2);
        this.fireFacetChangedEvent();
    }

    private void fireFacetChangedEvent() {
        FacetManager.getInstance((Module)this.getModule()).facetConfigurationChanged((Facet)this);
    }

    public void removeRoot(VirtualFile root2) {
        ((MockFacetConfiguration)this.getConfiguration()).removeRoot(root2);
        this.fireFacetChangedEvent();
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        List list = ContainerUtil.mapNotNull(((MockFacetConfiguration)this.getConfiguration()).getRootUrls(), arg_0 -> ((VirtualFileManager)VirtualFileManager.getInstance()).findFileByUrl(arg_0));
        if (list == null) {
            MockFacet.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static int getConstructorCounter() {
        return constructorCounter;
    }

    public static void setConstructorCounter(int constructorCounter) {
        MockFacet.constructorCounter = constructorCounter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/mock/MockFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/mock/MockFacet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

