/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.core;

import com.intellij.rt.execution.junit.FileComparisonData;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.FileInfo;
import org.opentest4j.ValueWrapper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0016\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0002\u000e\u000fB9\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/testFramework/core/FileComparisonFailedError;", "Lorg/opentest4j/AssertionFailedError;", "Lcom/intellij/rt/execution/junit/FileComparisonData;", "message", "", "expected", "actual", "expectedFilePath", "actualFilePath", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getActualFilePath", "getActualStringPresentation", "getExpectedStringPresentation", "getFilePath", "Companion", "PresentableFileInfo", "intellij.platform.testFramework.core"})
public class FileComparisonFailedError
extends AssertionFailedError
implements FileComparisonData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Charset CONTENT_CHARSET = StandardCharsets.UTF_8;

    @JvmOverloads
    public FileComparisonFailedError(@Nullable String message, @NotNull String expected, @NotNull String actual, @Nullable String expectedFilePath, @Nullable String actualFilePath) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        super(message, (Object)FileComparisonFailedError.Companion.createFileInfo(expected, expectedFilePath), (Object)FileComparisonFailedError.Companion.createFileInfo(actual, actualFilePath));
        if (!(expectedFilePath == null || new File(expectedFilePath).isFile())) {
            boolean $i$a$-require-FileComparisonFailedError$32 = false;
            String $i$a$-require-FileComparisonFailedError$32 = "'expectedFilePath' should point to the existing file or be null";
            throw new IllegalArgumentException($i$a$-require-FileComparisonFailedError$32.toString());
        }
        if (!(actualFilePath == null || new File(actualFilePath).isFile())) {
            boolean bl = false;
            String string = "'actualFilePath' should point to the existing file or be null";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ FileComparisonFailedError(String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        this(string, string2, string3, string4, string5);
    }

    @Nullable
    public String getFilePath() {
        ValueWrapper valueWrapper = this.getExpected();
        Intrinsics.checkNotNullExpressionValue((Object)valueWrapper, (String)"getExpected(...)");
        return FileComparisonFailedError.Companion.getFilePath(valueWrapper);
    }

    @Nullable
    public String getActualFilePath() {
        ValueWrapper valueWrapper = this.getActual();
        Intrinsics.checkNotNullExpressionValue((Object)valueWrapper, (String)"getActual(...)");
        return FileComparisonFailedError.Companion.getFilePath(valueWrapper);
    }

    @NotNull
    public String getActualStringPresentation() {
        ValueWrapper valueWrapper = this.getActual();
        Intrinsics.checkNotNullExpressionValue((Object)valueWrapper, (String)"getActual(...)");
        return FileComparisonFailedError.Companion.getFileText(valueWrapper);
    }

    @NotNull
    public String getExpectedStringPresentation() {
        ValueWrapper valueWrapper = this.getExpected();
        Intrinsics.checkNotNullExpressionValue((Object)valueWrapper, (String)"getExpected(...)");
        return FileComparisonFailedError.Companion.getFileText(valueWrapper);
    }

    @JvmOverloads
    public FileComparisonFailedError(@Nullable String message, @NotNull String expected, @NotNull String actual, @Nullable String expectedFilePath) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        this(message, expected, actual, expectedFilePath, null, 16, null);
    }

    @JvmOverloads
    public FileComparisonFailedError(@Nullable String message, @NotNull String expected, @NotNull String actual) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        this(message, expected, actual, null, null, 24, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/testFramework/core/FileComparisonFailedError$Companion;", "", "()V", "CONTENT_CHARSET", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "createFileInfo", "Lorg/opentest4j/ValueWrapper;", "text", "", "path", "getFilePath", "valueWrapper", "getFileText", "intellij.platform.testFramework.core"})
    public static final class Companion {
        private Companion() {
        }

        private final ValueWrapper createFileInfo(String text, String path) {
            String string = text;
            Charset charset = CONTENT_CHARSET;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"access$getCONTENT_CHARSET$cp(...)");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] contents = byArray;
            if (path != null) {
                PresentableFileInfo fileInfo = new PresentableFileInfo(path, contents);
                ValueWrapper valueWrapper = ValueWrapper.create((Object)((Object)fileInfo));
                Intrinsics.checkNotNullExpressionValue((Object)valueWrapper, (String)"create(...)");
                return valueWrapper;
            }
            ValueWrapper valueWrapper = ValueWrapper.create((Object)text);
            Intrinsics.checkNotNullExpressionValue((Object)valueWrapper, (String)"create(...)");
            return valueWrapper;
        }

        private final String getFileText(ValueWrapper valueWrapper) {
            Serializable serializable = valueWrapper.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"getValue(...)");
            Serializable value2 = serializable;
            if (value2 instanceof FileInfo) {
                String string = ((FileInfo)value2).getContentsAsString(CONTENT_CHARSET);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentsAsString(...)");
                return string;
            }
            return (String)((Object)value2);
        }

        private final String getFilePath(ValueWrapper valueWrapper) {
            Serializable serializable = valueWrapper.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"getValue(...)");
            Serializable value2 = serializable;
            if (value2 instanceof FileInfo) {
                return ((FileInfo)value2).getPath();
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/testFramework/core/FileComparisonFailedError$PresentableFileInfo;", "Lorg/opentest4j/FileInfo;", "path", "", "contents", "", "(Ljava/lang/String;[B)V", "toString", "intellij.platform.testFramework.core"})
    private static final class PresentableFileInfo
    extends FileInfo {
        public PresentableFileInfo(@NotNull String path, @NotNull byte[] contents) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            super(path, contents);
        }

        @NotNull
        public String toString() {
            String string = this.getContentsAsString(CONTENT_CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentsAsString(...)");
            return string;
        }
    }
}

