/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.testFramework.utils.module.CollectionAssertionsKt;
import com.intellij.testFramework.utils.module.ModuleAssertions;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u001a/\u0010\u0000\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\r\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0005\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0011\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00100\b\u001a/\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0014\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u001a7\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0017\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u001a'\u0010\u0018\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005\"\u00020\f\u00a2\u0006\u0002\u0010\u001a\u001a\u001c\u0010\u0018\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\b\u001a'\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005\"\u00020\f\u00a2\u0006\u0002\u0010\u001b\u001a\u001c\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\b\u001a'\u0010\u001c\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005\"\u00020\f\u00a2\u0006\u0002\u0010\u001a\u001a\u001c\u0010\u001c\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\b\u001a'\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005\"\u00020\f\u00a2\u0006\u0002\u0010\u001b\u001a\u001c\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\b\u00a8\u0006\u001d"}, d2={"assertContentRoots", "", "module", "Lcom/intellij/openapi/module/Module;", "expectedRoots", "", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/module/Module;[Ljava/nio/file/Path;)V", "", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Ljava/nio/file/Path;)V", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "(Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;[Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;)V", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;[Ljava/nio/file/Path;)V", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;Lcom/intellij/platform/workspace/storage/EntityStorage;Ljava/lang/String;[Ljava/nio/file/Path;)V", "assertModules", "expectedNames", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)V", "(Lcom/intellij/platform/workspace/storage/EntityStorage;[Ljava/lang/String;)V", "assertModulesContains", "intellij.platform.testFramework"})
@JvmName(name="ModuleAssertions")
@SourceDebugExtension(value={"SMAP\nModuleAssertions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleAssertions.kt\ncom/intellij/testFramework/utils/module/ModuleAssertions\n+ 2 EntityStorage.kt\ncom/intellij/platform/workspace/storage/EntityStorageKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n59#2:104\n59#2:105\n1549#3:106\n1620#3,3:107\n1549#3:110\n1620#3,3:111\n*S KotlinDebug\n*F\n+ 1 ModuleAssertions.kt\ncom/intellij/testFramework/utils/module/ModuleAssertions\n*L\n33#1:104\n51#1:105\n92#1:106\n92#1:107,3\n101#1:110\n101#1:111,3\n*E\n"})
public final class ModuleAssertions {
    public static final void assertModules(@NotNull Project project2, String ... expectedNames) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)expectedNames, (String)"expectedNames");
        ModuleAssertions.assertModules(project2, (List<String>)ArraysKt.asList((Object[])expectedNames));
    }

    public static final void assertModules(@NotNull Project project2, @NotNull List<String> expectedNames) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(expectedNames, (String)"expectedNames");
        ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)project2).getCurrentSnapshot();
        ModuleAssertions.assertModules((EntityStorage)storage, expectedNames);
    }

    public static final void assertModules(@NotNull EntityStorage storage, String ... expectedNames) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)expectedNames, (String)"expectedNames");
        ModuleAssertions.assertModules(storage, (List<String>)ArraysKt.asList((Object[])expectedNames));
    }

    public static final void assertModules(@NotNull EntityStorage storage, @NotNull List<String> expectedNames) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(expectedNames, (String)"expectedNames");
        EntityStorage $this$entities$iv = storage;
        boolean $i$f$entities = false;
        List actualNames2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)$this$entities$iv.entities(ModuleEntity.class), (Function1)assertModules.actualNames.1.INSTANCE));
        CollectionAssertionsKt.assertEqualsUnordered((Collection)expectedNames, actualNames2);
    }

    public static final void assertModulesContains(@NotNull Project project2, String ... expectedNames) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)expectedNames, (String)"expectedNames");
        ModuleAssertions.assertModulesContains(project2, (List<String>)ArraysKt.asList((Object[])expectedNames));
    }

    public static final void assertModulesContains(@NotNull Project project2, @NotNull List<String> expectedNames) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(expectedNames, (String)"expectedNames");
        ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)project2).getCurrentSnapshot();
        ModuleAssertions.assertModulesContains((EntityStorage)storage, expectedNames);
    }

    public static final void assertModulesContains(@NotNull EntityStorage storage, String ... expectedNames) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)expectedNames, (String)"expectedNames");
        ModuleAssertions.assertModulesContains(storage, (List<String>)ArraysKt.asList((Object[])expectedNames));
    }

    public static final void assertModulesContains(@NotNull EntityStorage storage, @NotNull List<String> expectedNames) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(expectedNames, (String)"expectedNames");
        EntityStorage $this$entities$iv = storage;
        boolean $i$f$entities = false;
        List actualNames2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)$this$entities$iv.entities(ModuleEntity.class), (Function1)assertModulesContains.actualNames.1.INSTANCE));
        CollectionAssertionsKt.assertContains((Collection)expectedNames, actualNames2);
    }

    public static final void assertContentRoots(@NotNull Module module2, Path ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ModuleAssertions.assertContentRoots(module2, ArraysKt.asList((Object[])expectedRoots));
    }

    public static final void assertContentRoots(@NotNull Module module2, @NotNull List<? extends Path> expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String string = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        ModuleAssertions.assertContentRoots(project2, string, expectedRoots);
    }

    public static final void assertContentRoots(@NotNull Project project2, @NotNull String moduleName, Path ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ModuleAssertions.assertContentRoots(project2, moduleName, (List<? extends Path>)ArraysKt.asList((Object[])expectedRoots));
    }

    public static final void assertContentRoots(@NotNull Project project2, @NotNull String moduleName, @NotNull List<? extends Path> expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        WorkspaceModel workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)project2);
        ImmutableEntityStorage storage = workspaceModel.getCurrentSnapshot();
        VirtualFileUrlManager virtualFileUrlManager = workspaceModel.getVirtualFileUrlManager();
        ModuleAssertions.assertContentRoots(virtualFileUrlManager, (EntityStorage)storage, moduleName, expectedRoots);
    }

    public static final void assertContentRoots(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull EntityStorage storage, @NotNull String moduleName, Path ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ModuleAssertions.assertContentRoots(virtualFileUrlManager, storage, moduleName, ArraysKt.asList((Object[])expectedRoots));
    }

    public static final void assertContentRoots(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull EntityStorage storage, @NotNull String moduleName, @NotNull List<? extends Path> expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        ModuleId moduleId = new ModuleId(moduleName);
        ModuleEntity moduleEntity = (ModuleEntity)storage.resolve((SymbolicEntityId)moduleId);
        Assertions.assertNotNull((Object)moduleEntity, () -> ModuleAssertions.assertContentRoots$lambda$0(moduleName));
        ModuleEntity moduleEntity2 = moduleEntity;
        Intrinsics.checkNotNull((Object)moduleEntity2);
        ModuleAssertions.assertContentRoots(virtualFileUrlManager, moduleEntity2, expectedRoots);
    }

    public static final void assertContentRoots(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull ModuleEntity moduleEntity, Path ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ModuleAssertions.assertContentRoots(virtualFileUrlManager, moduleEntity, (List<? extends Path>)ArraysKt.asList((Object[])expectedRoots));
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertContentRoots(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull ModuleEntity moduleEntity, @NotNull List<? extends Path> expectedRoots) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        Iterable $this$map$iv = expectedRoots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path2 = it.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
            collection.add(VirtualFileUrlImplKt.toVirtualFileUrl((Path)path2, (VirtualFileUrlManager)virtualFileUrlManager));
        }
        List expectedRootUrls = (List)destination$iv$iv;
        ModuleAssertions.assertContentRoots(moduleEntity, expectedRootUrls);
    }

    public static final void assertContentRoots(@NotNull ModuleEntity moduleEntity, VirtualFileUrl ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ModuleAssertions.assertContentRoots(moduleEntity, ArraysKt.asList((Object[])expectedRoots));
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertContentRoots(@NotNull ModuleEntity moduleEntity, @NotNull List<? extends VirtualFileUrl> expectedRoots) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        Iterable $this$map$iv = moduleEntity.getContentRoots();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ContentRootEntity contentRootEntity = (ContentRootEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        List actualRoots = (List)destination$iv$iv;
        CollectionAssertionsKt.assertEqualsUnordered((Collection)expectedRoots, actualRoots);
    }

    private static final String assertContentRoots$lambda$0(String $moduleName) {
        Intrinsics.checkNotNullParameter((Object)$moduleName, (String)"$moduleName");
        return "The module '" + $moduleName + "' doesn't exist";
    }
}

