/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsBranchComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsCommitInfoComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsCommitsComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsTitleComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CommitPresentation;
import com.intellij.collaboration.ui.codereview.details.ReviewDetailsUIUtil;
import com.intellij.collaboration.ui.codereview.details.data.ReviewRequestState;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewBranchesViewModel;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewChangesViewModel;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewDetailsViewModel;
import com.intellij.collaboration.ui.util.MigLayoutUtilKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.ActionLink;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.comment.GHMarkdownToHtmlConverterKt;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRDetailsActionsComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRDetailsComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStatusChecksComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.impl.GHPRDetailsViewModel;
import org.jetbrains.plugins.github.ui.util.GHHtmlPaneUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRDetailsComponentFactory;", "", "()V", "create", "Ljavax/swing/JComponent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "detailsVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/impl/GHPRDetailsViewModel;", "commitFilesBrowserComponent", "createCommitsPopupPresenter", "Lcom/intellij/collaboration/ui/codereview/details/CommitPresentation;", "commit", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "showTimelineAction", "", "parentComponent", "intellij.vcs.github"})
public final class GHPRDetailsComponentFactory {
    @NotNull
    public static final GHPRDetailsComponentFactory INSTANCE = new GHPRDetailsComponentFactory();

    private GHPRDetailsComponentFactory() {
    }

    @NotNull
    public final JComponent create(@NotNull CoroutineScope scope, @NotNull Project project, @NotNull GHPRDetailsViewModel detailsVm2, @NotNull JComponent commitFilesBrowserComponent) {
        JPanel jPanel;
        JPanel jPanel2;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)detailsVm2, (String)"detailsVm");
        Intrinsics.checkNotNullParameter((Object)commitFilesBrowserComponent, (String)"commitFilesBrowserComponent");
        AnAction anAction = ActionManager.getInstance().getAction("Github.PullRequest.Details.Popup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        CodeReviewDetailsViewModel codeReviewDetailsViewModel = detailsVm2;
        String string = GithubBundle.message("open.on.github.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        JComponent title2 = CodeReviewDetailsTitleComponentFactory.INSTANCE.create(scope, codeReviewDetailsViewModel, string, actionGroup, (Function0)create.title.1.INSTANCE);
        String string2 = CollaborationToolsBundle.message((String)"review.details.view.timeline.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        ActionLink timelineLink2 = new ActionLink(string2, (Function1)create.timelineLink.1.INSTANCE);
        JPanel $this$create_u24lambda_u240 = jPanel2 = new JPanel((LayoutManager)new MigLayout(MigLayoutUtilKt.emptyBorders((LC)new LC()).fill(), new AC().gap("push")));
        boolean bl = false;
        $this$create_u24lambda_u240.setOpaque(false);
        $this$create_u24lambda_u240.add(CodeReviewDetailsCommitsComponentFactory.INSTANCE.create(scope, (CodeReviewChangesViewModel)detailsVm2.getChangesVm(), (Function1)new Function1<GHCommit, CommitPresentation>(project, detailsVm2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GHPRDetailsViewModel $detailsVm;
            {
                this.$project = $project;
                this.$detailsVm = $detailsVm;
                super(1);
            }

            @NotNull
            public final CommitPresentation invoke(@NotNull GHCommit commit) {
                Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
                return GHPRDetailsComponentFactory.access$createCommitsPopupPresenter(GHPRDetailsComponentFactory.INSTANCE, this.$project, commit, this.$detailsVm.getSecurityService().getGhostUser());
            }
        }));
        $this$create_u24lambda_u240.add(CodeReviewDetailsBranchComponentFactory.INSTANCE.create(scope, (CodeReviewBranchesViewModel)detailsVm2.getBranchesVm()));
        JPanel commitsAndBranches2 = jPanel2;
        JComponent statusChecks = GHPRStatusChecksComponentFactory.INSTANCE.create(scope, project, detailsVm2.getStatusVm(), detailsVm2.getReviewFlowVm(), detailsVm2.getSecurityService(), detailsVm2.getAvatarIconsProvider());
        JComponent actionsComponent = GHPRDetailsActionsComponentFactory.INSTANCE.create(scope, project, (Flow<? extends ReviewRequestState>)detailsVm2.getReviewRequestState(), detailsVm2.getReviewFlowVm());
        JPanel $this$create_u24lambda_u241 = jPanel = new JPanel((LayoutManager)new MigLayout(MigLayoutUtilKt.emptyBorders((LC)new LC()).fill().flowY().noGrid().hideMode(3)));
        boolean bl2 = false;
        $this$create_u24lambda_u241.setOpaque(false);
        Component component = ReviewDetailsUIUtil.INSTANCE.createTitlePanel(title2, (JComponent)timelineLink2);
        CC cC = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC, (String)"growX(...)");
        $this$create_u24lambda_u241.add(component, MigLayoutUtilKt.gap((CC)cC, (Insets)ReviewDetailsUIUtil.INSTANCE.getTITLE_GAPS()));
        Component component2 = commitsAndBranches2;
        CC cC2 = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC2, (String)"growX(...)");
        $this$create_u24lambda_u241.add(component2, MigLayoutUtilKt.gap((CC)cC2, (Insets)ReviewDetailsUIUtil.INSTANCE.getCOMMIT_POPUP_BRANCHES_GAPS()));
        Component component3 = CodeReviewDetailsCommitInfoComponentFactory.INSTANCE.create(scope, (Flow)detailsVm2.getChangesVm().getSelectedCommit(), (Function1)new Function1<GHCommit, CommitPresentation>(project, detailsVm2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GHPRDetailsViewModel $detailsVm;
            {
                this.$project = $project;
                this.$detailsVm = $detailsVm;
                super(1);
            }

            @NotNull
            public final CommitPresentation invoke(@NotNull GHCommit commit) {
                Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
                return GHPRDetailsComponentFactory.access$createCommitsPopupPresenter(GHPRDetailsComponentFactory.INSTANCE, this.$project, commit, this.$detailsVm.getSecurityService().getGhostUser());
            }
        }, (Function0)new Function0<JEditorPane>(detailsVm2){
            final /* synthetic */ GHPRDetailsViewModel $detailsVm;
            {
                this.$detailsVm = $detailsVm;
                super(0);
            }

            @NotNull
            public final JEditorPane invoke() {
                JEditorPane jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, null, null, (int)13, null);
                GHPRDetailsViewModel gHPRDetailsViewModel = this.$detailsVm;
                JEditorPane $this$invoke_u24lambda_u240 = jEditorPane;
                boolean bl = false;
                GHHtmlPaneUtilKt.addGithubHyperlinkListener($this$invoke_u24lambda_u240, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)gHPRDetailsViewModel){

                    public final void invoke(long p0) {
                        ((GHPRDetailsViewModel)this.receiver).openPullRequestInfoAndTimeline(p0);
                    }
                }));
                return jEditorPane;
            }
        });
        CC cC3 = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC3, (String)"growX(...)");
        $this$create_u24lambda_u241.add(component3, MigLayoutUtilKt.gap((CC)cC3, (Insets)ReviewDetailsUIUtil.INSTANCE.getCOMMIT_INFO_GAPS()));
        $this$create_u24lambda_u241.add((Component)commitFilesBrowserComponent, new CC().grow().shrinkPrioY(200));
        Component component4 = statusChecks;
        CC cC4 = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC4, (String)"growX(...)");
        $this$create_u24lambda_u241.add(component4, MigLayoutUtilKt.gap((CC)cC4, (Insets)ReviewDetailsUIUtil.INSTANCE.getSTATUSES_GAPS()).maxHeight(String.valueOf(ReviewDetailsUIUtil.INSTANCE.getSTATUSES_MAX_HEIGHT())));
        Component component5 = actionsComponent;
        CC cC5 = new CC().growX().pushX();
        Intrinsics.checkNotNullExpressionValue((Object)cC5, (String)"pushX(...)");
        $this$create_u24lambda_u241.add(component5, MigLayoutUtilKt.gap((CC)cC5, (Insets)ReviewDetailsUIUtil.INSTANCE.getACTIONS_GAPS()).minHeight("pref"));
        PopupHandler.installPopupMenu((JComponent)$this$create_u24lambda_u241, (ActionGroup)actionGroup, (String)"popup");
        return jPanel;
    }

    private final void showTimelineAction(JComponent parentComponent) {
        AnAction anAction = ActionManager.getInstance().getAction("Github.PullRequest.Timeline.Show");
        if (anAction == null) {
            return;
        }
        AnAction action2 = anAction;
        ActionUtil.invokeAction((AnAction)action2, (Component)parentComponent, (String)"unknown", null, null);
    }

    private final CommitPresentation createCommitsPopupPresenter(Project project, GHCommit commit, GHUser ghostUser) {
        String string = GHMarkdownToHtmlConverterKt.convertToHtml(commit.getMessageHeadline(), project);
        String string2 = GHMarkdownToHtmlConverterKt.convertToHtml(commit.getMessageBody(), project);
        Object object = commit.getAuthor();
        if (object == null || (object = ((GHGitActor)object).getUser()) == null) {
            object = ghostUser;
        }
        return new CommitPresentation(string, string2, ((GHUser)object).getPresentableName(), commit.getCommittedDate());
    }

    public static final /* synthetic */ void access$showTimelineAction(GHPRDetailsComponentFactory $this, JComponent parentComponent) {
        $this.showTimelineAction(parentComponent);
    }

    public static final /* synthetic */ CommitPresentation access$createCommitsPopupPresenter(GHPRDetailsComponentFactory $this, Project project, GHCommit commit, GHUser ghostUser) {
        return $this.createCommitsPopupPresenter(project, commit, ghostUser);
    }
}

