/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.diff;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.action.ImmutableToolbarLabelAction;
import com.intellij.collaboration.ui.codereview.diff.CodeReviewDiffHandlerHelper;
import com.intellij.collaboration.util.KeyValuePair;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.tools.combined.CombinedDiffComponentProcessor;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewThreadsReloadAction;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffServiceKt;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.review.GHPRReviewViewModel;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/diff/GHPRDiffService;", "", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "base", "Lcom/intellij/collaboration/ui/codereview/diff/CodeReviewDiffHandlerHelper;", "createCombinedDiffProcessor", "Lcom/intellij/diff/tools/combined/CombinedDiffComponentProcessor;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "createDiffContext", "", "Lcom/intellij/collaboration/util/KeyValuePair;", "vm", "Lorg/jetbrains/plugins/github/pullrequest/ui/diff/GHPRDiffViewModel;", "createDiffRequestProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "intellij.vcs.github"})
public final class GHPRDiffService {
    @NotNull
    private final Project project;
    @NotNull
    private final CodeReviewDiffHandlerHelper base;

    public GHPRDiffService(@NotNull Project project, @NotNull CoroutineScope parentCs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        this.project = project;
        this.base = new CodeReviewDiffHandlerHelper(this.project, parentCs);
    }

    @NotNull
    public final DiffRequestProcessor createDiffRequestProcessor(@NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        Flow vm2 = GHPRDiffServiceKt.access$findDiffVm(this.project, repository, pullRequest);
        return this.base.createDiffRequestProcessor(vm2, new Function1<GHPRDiffViewModel, List<? extends KeyValuePair<?>>>(this){

            @NotNull
            public final List<KeyValuePair<?>> invoke(@NotNull GHPRDiffViewModel p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GHPRDiffService.access$createDiffContext((GHPRDiffService)this.receiver, p0);
            }
        });
    }

    @NotNull
    public final CombinedDiffComponentProcessor createCombinedDiffProcessor(@NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        Flow vm2 = GHPRDiffServiceKt.access$findDiffVm(this.project, repository, pullRequest);
        return this.base.createCombinedDiffModel(vm2, new Function1<GHPRDiffViewModel, List<? extends KeyValuePair<?>>>(this){

            @NotNull
            public final List<KeyValuePair<?>> invoke(@NotNull GHPRDiffViewModel p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GHPRDiffService.access$createDiffContext((GHPRDiffService)this.receiver, p0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<KeyValuePair<?>> createDiffContext(GHPRDiffViewModel vm2) {
        void $this$createDiffContext_u24lambda_u241_u24lambda_u240;
        Object[] objectArray;
        List list;
        List $this$createDiffContext_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$createDiffContext_u24lambda_u241.add(new KeyValuePair(GHPRDiffViewModel.Companion.getKEY(), (Object)vm2));
        Key key = DiffUserDataKeys.DATA_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"DATA_PROVIDER");
        Object[] objectArray2 = objectArray = new GenericDataProvider();
        Key key2 = key;
        List list2 = $this$createDiffContext_u24lambda_u241;
        boolean bl2 = false;
        $this$createDiffContext_u24lambda_u241_u24lambda_u240.putData(GHPRDiffViewModel.Companion.getDATA_KEY(), (Object)vm2);
        $this$createDiffContext_u24lambda_u241_u24lambda_u240.putData(GHPRReviewViewModel.Companion.getDATA_KEY(), (Object)vm2.getReviewVm());
        Unit unit = Unit.INSTANCE;
        Object[] objectArray3 = objectArray;
        Key key3 = key2;
        list2.add(new KeyValuePair(key3, (Object)objectArray3));
        Key key4 = DiffUserDataKeys.CONTEXT_ACTIONS;
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"CONTEXT_ACTIONS");
        objectArray = new AnAction[3];
        String string = CollaborationToolsBundle.message((String)"review.diff.toolbar.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = new ImmutableToolbarLabelAction(string);
        objectArray[1] = new GHPRDiffReviewThreadsReloadAction();
        objectArray[2] = ActionManager.getInstance().getAction("Github.PullRequest.Review.Submit");
        $this$createDiffContext_u24lambda_u241.add(new KeyValuePair(key4, (Object)CollectionsKt.listOf((Object[])objectArray)));
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public final DiffRequestProcessor createDiffRequestProcessor(@NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Flow vm2 = GHPRDiffServiceKt.access$findDiffVm(this.project, repository);
        return this.base.createDiffRequestProcessor(vm2, (Function1)createDiffRequestProcessor.2.INSTANCE);
    }

    @NotNull
    public final CombinedDiffComponentProcessor createCombinedDiffProcessor(@NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Flow vm2 = GHPRDiffServiceKt.access$findDiffVm(this.project, repository);
        return this.base.createCombinedDiffModel(vm2, (Function1)createCombinedDiffProcessor.2.INSTANCE);
    }

    public static final /* synthetic */ List access$createDiffContext(GHPRDiffService $this, GHPRDiffViewModel vm2) {
        return $this.createDiffContext(vm2);
    }
}

