/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.AstUtilKt;
import org.jetbrains.yaml.ImportantSchema;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0001\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"SCHEMA_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/yaml/ImportantSchema;", "detect", "tree", "Lcom/intellij/lang/LighterAST;", "getSchema", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.yaml"})
public final class YamlFileTypeUsageDescriptorKt {
    @NotNull
    private static final Key<ImportantSchema> SCHEMA_KEY;

    @RequiresReadLock
    @NotNull
    public static final ImportantSchema getSchema(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileViewProvider viewProvider = PsiManager.getInstance((Project)project).findViewProvider(file);
        if (viewProvider == null) {
            return ImportantSchema.NONE;
        }
        List list = viewProvider.getAllFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllFiles(...)");
        List files = list;
        for (PsiFile f : files) {
            if (!(f instanceof PsiFileImpl) || !Intrinsics.areEqual((Object)((PsiFileImpl)f).getFileType(), (Object)YAMLFileType.YML)) continue;
            FileElement astTree = (FileElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)f, () -> YamlFileTypeUsageDescriptorKt.getSchema$lambda$0(f));
            LighterAST lighterAST = astTree.getLighterAST();
            Intrinsics.checkNotNullExpressionValue((Object)lighterAST, (String)"getLighterAST(...)");
            return YamlFileTypeUsageDescriptorKt.detect(lighterAST);
        }
        return ImportantSchema.NONE;
    }

    private static final ImportantSchema detect(LighterAST tree) {
        Ref.BooleanRef hasApiVersion = new Ref.BooleanRef();
        Ref.BooleanRef hasKind = new Ref.BooleanRef();
        Ref.BooleanRef hasOpenapi = new Ref.BooleanRef();
        Ref.BooleanRef hasSwagger = new Ref.BooleanRef();
        Ref.BooleanRef hasServices = new Ref.BooleanRef();
        Ref.BooleanRef hasResources = new Ref.BooleanRef();
        Ref.BooleanRef hasAwsFormat = new Ref.BooleanRef();
        Ref.ObjectRef schema = new Ref.ObjectRef();
        AstUtilKt.visitTopLevelKeyPairs(tree, (Function2<? super CharSequence, ? super LighterASTNode, Boolean>)((Function2)new Function2<CharSequence, LighterASTNode, Boolean>(hasKind, hasApiVersion, hasOpenapi, hasSwagger, hasServices, hasResources, hasAwsFormat, (Ref.ObjectRef<ImportantSchema>)schema){
            final /* synthetic */ Ref.BooleanRef $hasKind;
            final /* synthetic */ Ref.BooleanRef $hasApiVersion;
            final /* synthetic */ Ref.BooleanRef $hasOpenapi;
            final /* synthetic */ Ref.BooleanRef $hasSwagger;
            final /* synthetic */ Ref.BooleanRef $hasServices;
            final /* synthetic */ Ref.BooleanRef $hasResources;
            final /* synthetic */ Ref.BooleanRef $hasAwsFormat;
            final /* synthetic */ Ref.ObjectRef<ImportantSchema> $schema;
            {
                this.$hasKind = $hasKind;
                this.$hasApiVersion = $hasApiVersion;
                this.$hasOpenapi = $hasOpenapi;
                this.$hasSwagger = $hasSwagger;
                this.$hasServices = $hasServices;
                this.$hasResources = $hasResources;
                this.$hasAwsFormat = $hasAwsFormat;
                this.$schema = $schema;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull CharSequence key, @NotNull LighterASTNode lighterASTNode) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)lighterASTNode, (String)"<anonymous parameter 1>");
                CharSequence charSequence = key;
                if (Intrinsics.areEqual((Object)charSequence, (Object)"kind")) {
                    this.$hasKind.element = true;
                } else if (Intrinsics.areEqual((Object)charSequence, (Object)"apiVersion")) {
                    this.$hasApiVersion.element = true;
                } else if (Intrinsics.areEqual((Object)charSequence, (Object)"openapi")) {
                    this.$hasOpenapi.element = true;
                } else if (Intrinsics.areEqual((Object)charSequence, (Object)"swagger")) {
                    this.$hasSwagger.element = true;
                } else if (Intrinsics.areEqual((Object)charSequence, (Object)"services")) {
                    this.$hasServices.element = true;
                } else if (Intrinsics.areEqual((Object)charSequence, (Object)"Resources")) {
                    this.$hasResources.element = true;
                } else if (Intrinsics.areEqual((Object)charSequence, (Object)"AWSTemplateFormatVersion")) {
                    this.$hasAwsFormat.element = true;
                }
                this.$schema.element = this.$hasOpenapi.element ? ImportantSchema.OPENAPI : (this.$hasSwagger.element ? ImportantSchema.SWAGGER : (this.$hasApiVersion.element && this.$hasKind.element ? ImportantSchema.KUBERNETES : (this.$hasServices.element ? ImportantSchema.DOCKER_COMPOSE : (this.$hasResources.element || this.$hasAwsFormat.element ? ImportantSchema.CLOUD_FORMATION : null))));
                return this.$schema.element == null;
            }
        }));
        ImportantSchema importantSchema = (ImportantSchema)((Object)schema.element);
        if (importantSchema == null) {
            importantSchema = ImportantSchema.NONE;
        }
        return importantSchema;
    }

    private static final FileElement getSchema$lambda$0(PsiFile $f) {
        Intrinsics.checkNotNullParameter((Object)$f, (String)"$f");
        return ((PsiFileImpl)$f).calcTreeElement();
    }

    public static final /* synthetic */ Key access$getSCHEMA_KEY$p() {
        return SCHEMA_KEY;
    }

    static {
        Key key = Key.create((String)"YAML_USAGE_SCHEMA");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SCHEMA_KEY = key;
    }
}

