/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.resolve.YAMLAliasReference;
import org.jetbrains.yaml.structureView.DuplicatedPsiTreeElementBase;
import org.jetbrains.yaml.structureView.YAMLStructureViewFactory;

public class YAMLAliasResolveNodeProvider
implements FileStructureNodeProvider<StructureViewTreeElement>,
ActionShortcutProvider {
    @NonNls
    public static final String ID = "YAML_SHOW_RESOLVED_ALIAS_VALUES";

    @NotNull
    public String getCheckBoxText() {
        String string = YAMLBundle.message((String)"YAMLAliasResolveNodeProvider.action.name", (Object[])new Object[0]);
        if (string == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Shortcut @NotNull [] getShortcut() {
        throw new IncorrectOperationException("see getActionIdForShortcut()");
    }

    @NotNull
    public String getActionIdForShortcut() {
        return "FileStructurePopup";
    }

    @NotNull
    public Collection<StructureViewTreeElement> provideNodes(@NotNull TreeElement node) {
        String details;
        Object psiElem;
        if (node == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(1);
        }
        if (node instanceof DuplicatedPsiTreeElementBase) {
            DuplicatedPsiTreeElementBase yamlNode = (DuplicatedPsiTreeElementBase)node;
            psiElem = yamlNode.getElement();
            details = yamlNode.getDetails();
        } else if (node instanceof PsiTreeElementBase) {
            PsiTreeElementBase yamlNode = (PsiTreeElementBase)node;
            psiElem = yamlNode.getElement();
            if (psiElem == null) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    YAMLAliasResolveNodeProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
            details = YAMLAliasResolveNodeProvider.calculateStartPath(psiElem);
        } else {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                YAMLAliasResolveNodeProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        YAMLPsiElement yamlElem = psiElem instanceof YAMLPsiElement ? (YAMLPsiElement)psiElem : null;
        YAMLValue value = YAMLAliasResolveNodeProvider.getContainedValue(yamlElem);
        if (!(value instanceof YAMLAlias)) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                YAMLAliasResolveNodeProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection<StructureViewTreeElement> collection2 = YAMLStructureViewFactory.createChildrenViewTreeElements((YAMLPsiElement)YAMLAliasResolveNodeProvider.resolveAlias((YAMLAlias)value), details);
        if (collection2 == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(5);
        }
        return collection2;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(YAMLBundle.message((String)"YAMLAliasResolveNodeProvider.action.name", (Object[])new Object[0]), YAMLBundle.message((String)"YAMLAliasResolveNodeProvider.action.description", (Object[])new Object[0]), YAMLStructureViewFactory.ALIAS_ICON);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    @Nullable
    private static YAMLValue resolveAlias(@NotNull YAMLAlias alias) {
        YAMLAliasReference ref;
        if (alias == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(6);
        }
        YAMLAnchor anchor = (ref = alias.getReference()) == null ? null : ref.resolve();
        return anchor != null ? anchor.getMarkedValue() : null;
    }

    @Contract(value="null -> null")
    @Nullable
    private static YAMLValue getContainedValue(@Nullable YAMLPsiElement element) {
        if (element == null) {
            return null;
        }
        final Ref result = Ref.create();
        element.accept((PsiElementVisitor)new YamlPsiElementVisitor(){

            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                if (keyValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.set((Object)keyValue.getValue());
            }

            public void visitSequenceItem(@NotNull YAMLSequenceItem sequenceItem) {
                if (sequenceItem == null) {
                    1.$$$reportNull$$$0(1);
                }
                result.set((Object)sequenceItem.getValue());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "keyValue";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sequenceItem";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/yaml/structureView/YAMLAliasResolveNodeProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitKeyValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSequenceItem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (YAMLValue)result.get();
    }

    @NotNull
    private static String calculateStartPath(@NotNull PsiElement psiElem) {
        if (psiElem == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(7);
        }
        if (!(psiElem instanceof YAMLPsiElement)) {
            return "";
        }
        String string = YAMLUtil.getConfigFullName((YAMLPsiElement)((YAMLPsiElement)psiElem));
        if (string == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/structureView/YAMLAliasResolveNodeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckBoxText";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/structureView/YAMLAliasResolveNodeProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "provideNodes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateStartPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "provideNodes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveAlias";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateStartPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

