/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.FormHighlightingPass;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.editor.MyEditorState;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.SlowOperations;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class UIFormEditor
extends UserDataHolderBase
implements FileEditor,
PossiblyDumbAware {
    private final VirtualFile file;
    private final GuiEditor editor;
    private MyBackgroundEditorHighlighter myBackgroundEditorHighlighter;

    public UIFormEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            UIFormEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            UIFormEditor.$$$reportNull$$$0(1);
        }
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-307701");){
            VirtualFile vf = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getOriginalFile() : file;
            Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)vf, (Project)project);
            if (module2 == null) {
                throw new IllegalArgumentException("No module for file " + file + " in project " + project);
            }
            this.file = file;
            this.editor = new GuiEditor(this, project, module2, file);
        }
    }

    UIFormEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull Module module2) {
        if (project == null) {
            UIFormEditor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            UIFormEditor.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            UIFormEditor.$$$reportNull$$$0(4);
        }
        this.file = file;
        this.editor = new GuiEditor(this, project, module2, file);
    }

    @NotNull
    public JComponent getComponent() {
        GuiEditor guiEditor = this.editor;
        if (guiEditor == null) {
            UIFormEditor.$$$reportNull$$$0(5);
        }
        return guiEditor;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.editor);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.editor.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = UIDesignerBundle.message("title.gui.designer", new Object[0]);
        if (string == null) {
            UIFormEditor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public GuiEditor getEditor() {
        GuiEditor guiEditor = this.editor;
        if (guiEditor == null) {
            UIFormEditor.$$$reportNull$$$0(7);
        }
        return guiEditor;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            UIFormEditor.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return FileDocumentManager.getInstance().getDocument(this.file) != null && FileTypeRegistry.getInstance().isFileOfType(this.file, (FileType)GuiFormFileType.INSTANCE);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UIFormEditor.$$$reportNull$$$0(9);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UIFormEditor.$$$reportNull$$$0(10);
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myBackgroundEditorHighlighter == null) {
            this.myBackgroundEditorHighlighter = new MyBackgroundEditorHighlighter(this.editor);
        }
        return this.myBackgroundEditorHighlighter;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel ignored) {
        Document document;
        if (ignored == null) {
            UIFormEditor.$$$reportNull$$$0(11);
        }
        long modificationStamp = (document = FileDocumentManager.getInstance().getCachedDocument(this.file)) != null ? document.getModificationStamp() : this.file.getModificationStamp();
        ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(this.editor);
        String[] ids = new String[selection.size()];
        for (int i = ids.length - 1; i >= 0; --i) {
            ids[i] = selection.get(i).getId();
        }
        return new MyEditorState(modificationStamp, ids);
    }

    public void setState(@NotNull FileEditorState state) {
        String[] ids;
        if (state == null) {
            UIFormEditor.$$$reportNull$$$0(12);
        }
        FormEditingUtil.clearSelection(this.editor.getRootContainer());
        for (String id : ids = ((MyEditorState)state).getSelectedComponentIds()) {
            RadComponent component = (RadComponent)FormEditingUtil.findComponent(this.editor.getRootContainer(), id);
            if (component == null) continue;
            component.setSelected(true);
        }
    }

    public void selectComponent(@NotNull String binding) {
        RadComponent component;
        if (binding == null) {
            UIFormEditor.$$$reportNull$$$0(13);
        }
        if ((component = (RadComponent)FormEditingUtil.findComponentWithBinding(this.editor.getRootContainer(), binding)) != null) {
            FormEditingUtil.selectSingleComponent(this.getEditor(), component);
        }
    }

    public void selectComponentById(@NotNull String id) {
        RadComponent component;
        if (id == null) {
            UIFormEditor.$$$reportNull$$$0(14);
        }
        if ((component = (RadComponent)FormEditingUtil.findComponent(this.editor.getRootContainer(), id)) != null) {
            FormEditingUtil.selectSingleComponent(this.getEditor(), component);
        }
    }

    public boolean isDumbAware() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/editor/UIFormEditor";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/editor/UIFormEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "selectComponent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectComponentById";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class MyBackgroundEditorHighlighter
    implements BackgroundEditorHighlighter {
        private final HighlightingPass[] myPasses;

        MyBackgroundEditorHighlighter(GuiEditor editor) {
            this.myPasses = new HighlightingPass[]{new FormHighlightingPass(editor)};
        }

        public HighlightingPass @NotNull [] createPassesForEditor() {
            if (this.myPasses == null) {
                MyBackgroundEditorHighlighter.$$$reportNull$$$0(0);
            }
            return this.myPasses;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/editor/UIFormEditor$MyBackgroundEditorHighlighter", "createPassesForEditor"));
        }
    }
}

