/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.palette.PaletteItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.HSpacer;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.VSpacer;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.radComponents.RadAtomicComponent;
import icons.UIDesignerIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentItem
implements Cloneable,
PaletteItem {
    private static final Logger LOG = Logger.getInstance(ComponentItem.class);
    public static final DataKey<ComponentItem> DATA_KEY = DataKey.create((String)ComponentItem.class.getName());
    @NonNls
    private String myClassName;
    private final GridConstraints myDefaultConstraints;
    private Icon myIcon;
    private Icon mySmallIcon;
    private String myIconPath;
    final String myToolTipText;
    private final HashMap<String, StringDescriptor> myPropertyName2initialValue;
    private final boolean myRemovable;
    private boolean myAutoCreateBinding;
    private boolean myCanAttachLabel;
    private boolean myIsContainer;
    private boolean myAnyComponent;
    private Dimension myInitialSize;
    @NotNull
    private final Project myProject;

    public ComponentItem(@NotNull Project project, @NotNull String className, @Nullable String iconPath, @Nullable String toolTipText, @NotNull GridConstraints defaultConstraints, @NotNull HashMap<String, StringDescriptor> propertyName2initialValue, boolean removable, boolean autoCreateBinding, boolean canAttachLabel) {
        if (project == null) {
            ComponentItem.$$$reportNull$$$0(0);
        }
        if (className == null) {
            ComponentItem.$$$reportNull$$$0(1);
        }
        if (defaultConstraints == null) {
            ComponentItem.$$$reportNull$$$0(2);
        }
        if (propertyName2initialValue == null) {
            ComponentItem.$$$reportNull$$$0(3);
        }
        this.myAutoCreateBinding = autoCreateBinding;
        this.myCanAttachLabel = canAttachLabel;
        this.myProject = project;
        this.setClassName(className);
        this.setIconPath(iconPath);
        this.myToolTipText = toolTipText;
        this.myDefaultConstraints = defaultConstraints;
        this.myPropertyName2initialValue = propertyName2initialValue;
        this.myRemovable = removable;
    }

    public boolean isRemovable() {
        return this.myRemovable;
    }

    private static String calcToolTipText(@NotNull String className) {
        int lastDotIndex;
        if (className == null) {
            ComponentItem.$$$reportNull$$$0(4);
        }
        if ((lastDotIndex = className.lastIndexOf(46)) != -1 && lastDotIndex != className.length() - 1) {
            return className.substring(lastDotIndex + 1) + " (" + className.substring(0, lastDotIndex) + ")";
        }
        return className;
    }

    public ComponentItem clone() {
        ComponentItem result = new ComponentItem(this.myProject, this.myClassName, this.myIconPath, this.myToolTipText, (GridConstraints)this.myDefaultConstraints.clone(), (HashMap)this.myPropertyName2initialValue.clone(), this.myRemovable, this.myAutoCreateBinding, this.myCanAttachLabel);
        result.setIsContainer(this.myIsContainer);
        return result;
    }

    @Nullable
    String getIconPath() {
        return this.myIconPath;
    }

    void setIconPath(@Nullable String iconPath) {
        this.myIcon = null;
        this.mySmallIcon = null;
        this.myIconPath = iconPath;
        if (iconPath != null && iconPath.startsWith("/com/intellij/uiDesigner/icons/") && iconPath.endsWith(".png")) {
            this.myIconPath = iconPath.substring(0, iconPath.length() - 4) + ".svg";
        }
    }

    @NotNull
    public Icon getIcon() {
        if (this.myIcon != null) {
            Icon icon = this.myIcon;
            if (icon == null) {
                ComponentItem.$$$reportNull$$$0(5);
            }
            return icon;
        }
        if (this.myIconPath != null && !this.myIconPath.isEmpty()) {
            VirtualFile iconFile = ResourceFileUtil.findResourceFileInScope((String)this.myIconPath, (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            if (iconFile != null) {
                try {
                    this.myIcon = new ImageIcon(iconFile.contentsToByteArray());
                }
                catch (IOException e) {
                    this.myIcon = null;
                }
            } else {
                this.myIcon = IconLoader.findIcon((String)this.myIconPath, (ClassLoader)ComponentItem.class.getClassLoader());
            }
        }
        if (this.myIcon == null) {
            this.myIcon = UIDesignerIcons.Unknown;
        }
        Icon icon = this.myIcon;
        if (icon == null) {
            ComponentItem.$$$reportNull$$$0(6);
        }
        return icon;
    }

    @NotNull
    public Icon getSmallIcon() {
        if (this.mySmallIcon != null) {
            Icon icon = this.myIcon;
            if (icon == null) {
                ComponentItem.$$$reportNull$$$0(7);
            }
            return icon;
        }
        Icon icon = this.getIcon();
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            this.mySmallIcon = new MySmallIcon(imageIcon.getImage());
        } else {
            this.mySmallIcon = icon;
        }
        Icon icon2 = this.mySmallIcon;
        if (icon2 == null) {
            ComponentItem.$$$reportNull$$$0(8);
        }
        return icon2;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            ComponentItem.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NlsSafe
    public String getClassShortName() {
        int lastDotIndex = this.myClassName.lastIndexOf(46);
        if (lastDotIndex != -1 && lastDotIndex != this.myClassName.length() - 1) {
            return this.myClassName.substring(lastDotIndex + 1).replace('$', '.');
        }
        return this.myClassName.replace('$', '.');
    }

    public void setClassName(@NotNull String className) {
        if (className == null) {
            ComponentItem.$$$reportNull$$$0(10);
        }
        this.myClassName = className;
    }

    @NlsSafe
    public String getToolTipText() {
        return this.myToolTipText != null ? this.myToolTipText : ComponentItem.calcToolTipText(this.myClassName);
    }

    @NotNull
    public GridConstraints getDefaultConstraints() {
        GridConstraints gridConstraints = this.myDefaultConstraints;
        if (gridConstraints == null) {
            ComponentItem.$$$reportNull$$$0(11);
        }
        return gridConstraints;
    }

    public Object getInitialValue(IntrospectedProperty property) {
        return this.myPropertyName2initialValue.get(property.getName());
    }

    HashMap<String, StringDescriptor> getInitialValues() {
        return this.myPropertyName2initialValue;
    }

    public boolean isAutoCreateBinding() {
        return this.myAutoCreateBinding;
    }

    public void setAutoCreateBinding(boolean autoCreateBinding) {
        this.myAutoCreateBinding = autoCreateBinding;
    }

    public boolean isCanAttachLabel() {
        return this.myCanAttachLabel;
    }

    public void setCanAttachLabel(boolean canAttachLabel) {
        this.myCanAttachLabel = canAttachLabel;
    }

    public boolean isContainer() {
        return this.myIsContainer;
    }

    public void setIsContainer(boolean isContainer) {
        this.myIsContainer = isContainer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentItem)) {
            return false;
        }
        ComponentItem componentItem = (ComponentItem)o;
        if (this.myClassName != null ? !this.myClassName.equals(componentItem.myClassName) : componentItem.myClassName != null) {
            return false;
        }
        if (this.myDefaultConstraints != null ? !this.myDefaultConstraints.equals((Object)componentItem.myDefaultConstraints) : componentItem.myDefaultConstraints != null) {
            return false;
        }
        if (this.myIconPath != null ? !this.myIconPath.equals(componentItem.myIconPath) : componentItem.myIconPath != null) {
            return false;
        }
        if (this.myPropertyName2initialValue != null ? !this.myPropertyName2initialValue.equals(componentItem.myPropertyName2initialValue) : componentItem.myPropertyName2initialValue != null) {
            return false;
        }
        return !(this.myToolTipText != null ? !this.myToolTipText.equals(componentItem.myToolTipText) : componentItem.myToolTipText != null);
    }

    public int hashCode() {
        int result = this.myClassName != null ? this.myClassName.hashCode() : 0;
        result = 29 * result + (this.myDefaultConstraints != null ? this.myDefaultConstraints.hashCode() : 0);
        result = 29 * result + (this.myIconPath != null ? this.myIconPath.hashCode() : 0);
        result = 29 * result + (this.myToolTipText != null ? this.myToolTipText.hashCode() : 0);
        result = 29 * result + (this.myPropertyName2initialValue != null ? this.myPropertyName2initialValue.hashCode() : 0);
        return result;
    }

    @Override
    public void customizeCellRenderer(ColoredListCellRenderer cellRenderer, boolean selected, boolean hasFocus) {
        cellRenderer.setIcon(this.getSmallIcon());
        if (this.myAnyComponent) {
            cellRenderer.append(UIDesignerBundle.message("palette.non.palette.component", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            cellRenderer.setToolTipText(UIDesignerBundle.message("palette.non.palette.component.tooltip", new Object[0]));
        } else {
            cellRenderer.append(this.getClassShortName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            cellRenderer.setToolTipText(this.getToolTipText());
        }
    }

    @Override
    @Nullable
    public DnDDragStartBean startDragging() {
        if (this.isAnyComponent()) {
            return null;
        }
        return new DnDDragStartBean((Object)this);
    }

    @Override
    @Nullable
    public ActionGroup getPopupActionGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction("GuiDesigner.PaletteComponentPopupMenu");
    }

    @Override
    @Nullable
    public Object getData(@NotNull Project project, @NotNull String dataId) {
        if (project == null) {
            ComponentItem.$$$reportNull$$$0(12);
        }
        if (dataId == null) {
            ComponentItem.$$$reportNull$$$0(13);
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (GroupItem.DATA_KEY.is(dataId)) {
            return Palette.getInstance(project).findGroup(this);
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            return slowId -> this.getSlowData(slowId, project);
        }
        return null;
    }

    @Nullable
    private Object getSlowData(@NotNull String dataId, @NotNull Project project) {
        if (dataId == null) {
            ComponentItem.$$$reportNull$$$0(14);
        }
        if (project == null) {
            ComponentItem.$$$reportNull$$$0(15);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return JavaPsiFacade.getInstance((Project)project).findClass(this.myClassName, GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    @Nullable
    public PsiFile getBoundForm() {
        if (this.myClassName.isEmpty() || this.myClassName.startsWith("javax.swing")) {
            return null;
        }
        List<PsiFile> boundForms = FormClassIndex.findFormsBoundToClass(this.myProject, this.myClassName.replace('$', '.'));
        if (!boundForms.isEmpty()) {
            return boundForms.get(0);
        }
        return null;
    }

    @NotNull
    public Dimension getInitialSize(JComponent parent, ClassLoader loader) {
        if (this.myInitialSize != null) {
            Dimension dimension = this.myInitialSize;
            if (dimension == null) {
                ComponentItem.$$$reportNull$$$0(16);
            }
            return dimension;
        }
        this.myInitialSize = new Dimension(this.myDefaultConstraints.myPreferredSize);
        if (this.myInitialSize.width <= 0 || this.myInitialSize.height <= 0) {
            try {
                Class<?> aClass = Class.forName(this.getClassName(), true, loader);
                RadAtomicComponent component = new RadAtomicComponent(aClass, "", Palette.getInstance(this.myProject));
                component.initDefaultProperties(this);
                JComponent delegee = component.getDelegee();
                if (parent != null) {
                    Font font = parent.getFont();
                    delegee.setFont(font);
                }
                Dimension prefSize = delegee.getPreferredSize();
                Dimension minSize = delegee.getMinimumSize();
                if (this.myInitialSize.width <= 0) {
                    this.myInitialSize.width = prefSize.width;
                }
                if (this.myInitialSize.height <= 0) {
                    this.myInitialSize.height = prefSize.height;
                }
                this.myInitialSize.width = Math.max(this.myInitialSize.width, minSize.width);
                this.myInitialSize.height = Math.max(this.myInitialSize.height, minSize.height);
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
        Dimension dimension = this.myInitialSize;
        if (dimension == null) {
            ComponentItem.$$$reportNull$$$0(17);
        }
        return dimension;
    }

    public static ComponentItem createAnyComponentItem(Project project) {
        ComponentItem result = new ComponentItem(project, "", null, null, new GridConstraints(), new HashMap<String, StringDescriptor>(), false, false, false);
        result.myAnyComponent = true;
        return result;
    }

    public boolean isAnyComponent() {
        return this.myAnyComponent;
    }

    public boolean isSpacer() {
        return this.myClassName.equals(HSpacer.class.getName()) || this.myClassName.equals(VSpacer.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 11, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultConstraints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName2initialValue";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/palette/ComponentItem";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/palette/ComponentItem";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstraints";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcToolTipText";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setClassName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 11, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static final class MySmallIcon
    implements Icon {
        private final Image myImage;

        MySmallIcon(@NotNull Image delegate) {
            if (delegate == null) {
                MySmallIcon.$$$reportNull$$$0(0);
            }
            this.myImage = delegate;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this.myImage, 2, 2, 14, 14, c);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/uiDesigner/palette/ComponentItem$MySmallIcon", "<init>"));
        }
    }
}

