/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.services.ServiceViewContributorDeleteProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.platform.execution.dashboard.tree.GroupingNode;
import com.intellij.platform.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class RunDashboardServiceViewDeleteProvider
implements ServiceViewContributorDeleteProvider {
    private DeleteProvider myDelegate;

    RunDashboardServiceViewDeleteProvider() {
    }

    public void setFallbackProvider(DeleteProvider provider) {
        this.myDelegate = provider;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            RunDashboardServiceViewDeleteProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        List<ConfigurationType> targetTypes;
        if (dataContext == null) {
            RunDashboardServiceViewDeleteProvider.$$$reportNull$$$0(1);
        }
        if ((targetTypes = RunDashboardServiceViewDeleteProvider.getTargetTypes(dataContext)).isEmpty()) {
            if (this.myDelegate != null) {
                this.myDelegate.deleteElement(dataContext);
            }
            return;
        }
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ConfigurationType onlyType = (ConfigurationType)ContainerUtil.getOnlyItem(targetTypes);
        String message = onlyType != null ? ExecutionBundle.message((String)"run.dashboard.remove.run.configuration.type.confirmation", (Object[])new Object[]{onlyType.getDisplayName()}) : ExecutionBundle.message((String)"run.dashboard.remove.run.configuration.types.confirmation", (Object[])new Object[]{targetTypes.size()});
        if (!((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"button.remove", (Object[])new Object[0]), (String)message).yesText(IdeBundle.message((String)"button.remove", (Object[])new Object[0]))).icon(Messages.getWarningIcon())).ask(project)) {
            return;
        }
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
        HashSet types = new HashSet(runDashboardManager.getTypes());
        for (ConfigurationType type : targetTypes) {
            types.remove(type.getId());
        }
        runDashboardManager.setTypes(types);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        List<ConfigurationType> targetTypes;
        if (dataContext == null) {
            RunDashboardServiceViewDeleteProvider.$$$reportNull$$$0(2);
        }
        return !(targetTypes = RunDashboardServiceViewDeleteProvider.getTargetTypes(dataContext)).isEmpty() || this.myDelegate != null && this.myDelegate.canDeleteElement(dataContext);
    }

    private static List<ConfigurationType> getTargetTypes(DataContext dataContext) {
        Object[] items = (Object[])dataContext.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
        if (items == null) {
            return Collections.emptyList();
        }
        SmartList types = new SmartList();
        for (Object item : items) {
            RunDashboardGroup group;
            ConfigurationType type;
            if (!(item instanceof GroupingNode) || (type = (ConfigurationType)ObjectUtils.tryCast(((RunDashboardGroupImpl)(group = ((GroupingNode)((Object)item)).getGroup())).getValue(), ConfigurationType.class)) == null) {
                return Collections.emptyList();
            }
            types.add(type);
        }
        return types;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewDeleteProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewDeleteProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

