/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.platform.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.platform.execution.dashboard.tree.GroupingNode;
import com.intellij.platform.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class RestoreHiddenConfigurationsAction
extends DumbAwareAction {
    RestoreHiddenConfigurationsAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (ActionPlaces.getActionGroupPopupPlace((String)"ServicesToolbar").equals(e.getPlace())) {
            presentation.setEnabledAndVisible(RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project));
            presentation.setText(ExecutionBundle.message((String)"run.dashboard.restore.hidden.configurations.toolbar.action.name", (Object[])new Object[0]));
            return;
        }
        presentation.setText(ExecutionBundle.message((String)"run.dashboard.restore.hidden.configurations.popup.action.name", (Object[])new Object[0]));
        RunDashboardServiceViewContributor root = (RunDashboardServiceViewContributor)ServiceViewActionUtils.getTarget((AnActionEvent)e, RunDashboardServiceViewContributor.class);
        if (root != null) {
            presentation.setEnabledAndVisible(RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project));
            return;
        }
        if (!PropertiesComponent.getInstance((Project)project).getBoolean("ConfigurationTypeDashboardGroupingRule", true)) {
            List nodes = ServiceViewActionUtils.getTargets((AnActionEvent)e, RunDashboardNode.class);
            presentation.setEnabledAndVisible(!nodes.isEmpty() && RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project));
            return;
        }
        Set<ConfigurationType> types = RestoreHiddenConfigurationsAction.getTargetTypes(e);
        if (types.isEmpty()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        Set<RunConfiguration> hiddenConfigurations = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project)).getHiddenConfigurations();
        List configurations = ContainerUtil.filter(hiddenConfigurations, configuration -> types.contains(configuration.getType()));
        presentation.setEnabledAndVisible(!configurations.isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        RunDashboardServiceViewContributor root = (RunDashboardServiceViewContributor)ServiceViewActionUtils.getTarget((AnActionEvent)e, RunDashboardServiceViewContributor.class);
        if (ActionPlaces.getActionGroupPopupPlace((String)"ServicesToolbar").equals(e.getPlace()) || root != null || !PropertiesComponent.getInstance((Project)project).getBoolean("ConfigurationTypeDashboardGroupingRule", true)) {
            RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
            runDashboardManager.restoreConfigurations(new HashSet<RunConfiguration>(runDashboardManager.getHiddenConfigurations()));
            return;
        }
        Set<ConfigurationType> types = RestoreHiddenConfigurationsAction.getTargetTypes(e);
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
        List configurations = ContainerUtil.filter(runDashboardManager.getHiddenConfigurations(), configuration -> types.contains(configuration.getType()));
        runDashboardManager.restoreConfigurations(configurations);
    }

    private static boolean hasHiddenConfiguration(Project project) {
        return !((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project)).getHiddenConfigurations().isEmpty();
    }

    private static Set<ConfigurationType> getTargetTypes(AnActionEvent e) {
        List targets = ServiceViewActionUtils.getTargets((AnActionEvent)e, RunDashboardNode.class);
        if (targets.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ConfigurationType> types = new HashSet<ConfigurationType>();
        for (RunDashboardNode node : targets) {
            if (node instanceof RunDashboardRunConfigurationNode) {
                types.add(((RunDashboardRunConfigurationNode)node).getConfigurationSettings().getType());
                continue;
            }
            if (node instanceof GroupingNode) {
                RunDashboardGroupImpl group = (RunDashboardGroupImpl)((GroupingNode)node).getGroup();
                ConfigurationType type = (ConfigurationType)ObjectUtils.tryCast(group.getValue(), ConfigurationType.class);
                if (type == null) {
                    return Collections.emptySet();
                }
                types.add(type);
                continue;
            }
            return Collections.emptySet();
        }
        return types;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/actions/RestoreHiddenConfigurationsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/actions/RestoreHiddenConfigurationsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

