/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.composite;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtensionUpdatableIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructureExtensionUpdateComputation;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.events.VfsEventsMerger;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MergedValueContainer;
import com.intellij.util.io.MeasurableIndexStore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public abstract class CompositeInvertedIndexBase<Key, Value, FileIndexMetaData>
implements FileBasedIndexInfrastructureExtensionUpdatableIndex<Key, Value, FileContent, FileIndexMetaData>,
MeasurableIndexStore {
    @NotNull
    protected final UpdatableIndex<Key, Value, FileContent, FileIndexMetaData> myBaseIndex;
    protected final ID<Key, Value> myId;

    public CompositeInvertedIndexBase(@NotNull ID<Key, Value> id, @NotNull UpdatableIndex<Key, Value, FileContent, FileIndexMetaData> baseIndex) {
        if (id == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(0);
        }
        if (baseIndex == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(1);
        }
        this.myId = id;
        this.myBaseIndex = baseIndex;
    }

    @NotNull
    public final IndexInfrastructureExtensionUpdateComputation mapInputAndPrepareUpdate(int inputId, @Nullable FileContent content) {
        Computable<Boolean> baseIndexUpdate;
        boolean hasSharedIndex;
        Computable<Boolean> secondaryIndexUpdate;
        if (content != null && !IndexingDataKeys.REBUILD_REQUESTED.isIn((UserDataHolder)content.getFile())) {
            IndexInfrastructureUpdate update = this.tryToMapWithSecondaryIndex(inputId, content);
            secondaryIndexUpdate = update.update;
            hasSharedIndex = update.isIndexProvided;
            if (hasSharedIndex) {
                VfsEventsMerger.tryLog((String)"w/_shi", (IndexedFile)content, () -> "id=" + this.myId);
                baseIndexUpdate = this.updateBaseIndex(inputId, null);
            } else {
                VfsEventsMerger.tryLog((String)"w/o_shi", (IndexedFile)content, () -> "id=" + this.myId);
                baseIndexUpdate = this.updateBaseIndex(inputId, content);
            }
        } else {
            VfsEventsMerger.tryLog(() -> "event=remove_from_shared, f=" + (content == null ? null : content.getFile()) + ",file_id=" + inputId);
            secondaryIndexUpdate = this.removeFromSecondaryIndex(inputId);
            baseIndexUpdate = this.updateBaseIndex(inputId, content);
            hasSharedIndex = false;
        }
        return new IndexInfrastructureExtensionUpdateComputation(() -> Boolean.TRUE.equals(secondaryIndexUpdate.get()) && Boolean.TRUE.equals(baseIndexUpdate.get()), hasSharedIndex);
    }

    @NotNull
    public Computable<Boolean> prepareUpdate(int inputId, @NotNull InputData<Key, Value> data) {
        if (data == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(2);
        }
        Computable computable = this.myBaseIndex.prepareUpdate(inputId, data);
        if (computable == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(3);
        }
        return computable;
    }

    public final void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(4);
        }
        this.myBaseIndex.updateWithMap(updateData);
    }

    public final void setBufferingEnabled(boolean enabled) {
        this.myBaseIndex.setBufferingEnabled(enabled);
        this.setSecondaryIndexBufferingEnabled(enabled);
    }

    public final void cleanupMemoryStorage() {
        this.myBaseIndex.cleanupMemoryStorage();
        this.cleanupSecondaryIndexMemoryStorage();
    }

    @TestOnly
    public final void cleanupForNextTest() {
        this.myBaseIndex.cleanupForNextTest();
        this.cleanupSecondaryIndexForNextTest();
    }

    @NotNull
    public final ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(5);
        }
        SmartList data = new SmartList();
        data.add(this.myBaseIndex.getData(key));
        this.getSecondaryIndexData(key, ((List)data)::add);
        return new MergedValueContainer((List)data);
    }

    public final boolean processAllKeys(@NotNull Processor<? super Key> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(7);
        }
        if (!this.myBaseIndex.processAllKeys(processor, scope, idFilter)) {
            return false;
        }
        return this.processAllKeysBySecondaryIndex(processor, scope, idFilter);
    }

    @NotNull
    public final ReadWriteLock getLock() {
        ReadWriteLock readWriteLock = this.myBaseIndex.getLock();
        if (readWriteLock == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(8);
        }
        return readWriteLock;
    }

    @NotNull
    public final Map<Key, Value> getIndexedFileData(int fileId) throws StorageException {
        FileBasedIndex.IndexWritingFile indexingFile = FileBasedIndex.getInstance().getFileWritingCurrentlyIndexes();
        if (indexingFile != null) {
            return this.doGetIndexedFileData(fileId, indexingFile.fileId);
        }
        VirtualFile file = FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed();
        if (file != null) {
            return this.doGetIndexedFileData(fileId, FileBasedIndex.getFileId((VirtualFile)file));
        }
        Map<Key, Value> secondaryFileData = this.getSecondaryIndexFileData(fileId);
        if (secondaryFileData != null) {
            Map<Key, Value> map = secondaryFileData;
            if (map == null) {
                CompositeInvertedIndexBase.$$$reportNull$$$0(9);
            }
            return map;
        }
        Map map = this.myBaseIndex.getIndexedFileData(fileId);
        if (map == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    private Map<Key, Value> doGetIndexedFileData(int fileId, int indexingFileId) throws StorageException {
        Map data = this.myBaseIndex.getIndexedFileData(fileId);
        if (indexingFileId != fileId) {
            String filePath;
            try {
                VirtualFile file = ManagingFS.getInstance().findFileById(fileId);
                filePath = file == null ? "<invalid>" : file.getPath();
            }
            catch (InvalidVirtualFileAccessException e) {
                filePath = "<invalid>";
            }
            String message = "Indexing process should not rely on non-indexed file data.\nIndexing file = " + filePath + ", file id = " + indexingFileId + ", queried file id = " + fileId;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                FileBasedIndexImpl.LOG.warn(message);
            } else {
                FileBasedIndexImpl.LOG.error(message);
            }
        }
        Map map = data;
        if (map == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(11);
        }
        return map;
    }

    public FileIndexMetaData getFileIndexMetaData(@NotNull IndexedFile file) {
        if (file == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(12);
        }
        return (FileIndexMetaData)this.myBaseIndex.getFileIndexMetaData(file);
    }

    public final void setIndexedStateForFileOnFileIndexMetaData(int fileId, @Nullable FileIndexMetaData fileIndexMetaData, boolean isProvidedByInfrastructureExtension) {
        if (isProvidedByInfrastructureExtension) {
            this.myBaseIndex.setUnindexedStateForFile(fileId);
            IndexingStamp.setFileIndexedStateCurrent((int)fileId, this.myId, (boolean)isProvidedByInfrastructureExtension);
        } else {
            this.myBaseIndex.setIndexedStateForFileOnFileIndexMetaData(fileId, fileIndexMetaData, isProvidedByInfrastructureExtension);
        }
    }

    public final void setIndexedStateForFile(int fileId, @NotNull IndexedFile file, boolean isProvidedByInfrastructureExtension) {
        if (file == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(13);
        }
        if (isProvidedByInfrastructureExtension) {
            this.myBaseIndex.setUnindexedStateForFile(fileId);
            IndexingStamp.setFileIndexedStateCurrent((int)fileId, this.myId, (boolean)isProvidedByInfrastructureExtension);
        } else {
            this.myBaseIndex.setIndexedStateForFile(fileId, file, isProvidedByInfrastructureExtension);
        }
    }

    public final void invalidateIndexedStateForFile(int fileId) {
        this.myBaseIndex.invalidateIndexedStateForFile(fileId);
    }

    public final void setUnindexedStateForFile(int fileId) {
        this.myBaseIndex.setUnindexedStateForFile(fileId);
    }

    @NotNull
    public final FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file) {
        if (file == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(14);
        }
        FileIndexingState fileIndexingState = this.myBaseIndex.getIndexingStateForFile(fileId, file);
        if (fileIndexingState == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(15);
        }
        return fileIndexingState;
    }

    public final long getModificationStamp() {
        return this.myBaseIndex.getModificationStamp();
    }

    public final void removeTransientDataForFile(int inputId) {
        this.myBaseIndex.removeTransientDataForFile(inputId);
    }

    public final void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<Key, Value> diffBuilder) {
        if (diffBuilder == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(16);
        }
        this.myBaseIndex.removeTransientDataForKeys(inputId, diffBuilder);
    }

    @NotNull
    public final IndexExtension<Key, Value, FileContent> getExtension() {
        IndexExtension indexExtension = this.myBaseIndex.getExtension();
        if (indexExtension == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(17);
        }
        return indexExtension;
    }

    public final void clear() throws StorageException {
        try {
            this.clearSecondaryIndex();
        }
        finally {
            this.myBaseIndex.clear();
        }
    }

    public final void dispose() {
        try {
            this.disposeSecondaryIndex();
        }
        finally {
            this.myBaseIndex.dispose();
        }
    }

    public int keysCountApproximately() {
        return MeasurableIndexStore.keysCountApproximatelyIfPossible(this.myBaseIndex);
    }

    public final void flush() throws StorageException {
        try {
            this.myBaseIndex.flush();
        }
        finally {
            this.flushSecondaryIndex();
        }
    }

    @NotNull
    protected final Computable<Boolean> updateBaseIndex(int inputId, @Nullable FileContent content) {
        Computable computable = CompositeInvertedIndexBase.mustUseOnlyIndexInfrastructureExtension() ? () -> Boolean.TRUE : this.myBaseIndex.mapInputAndPrepareUpdate(inputId, (Object)content);
        if (computable == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(18);
        }
        return computable;
    }

    private static boolean mustUseOnlyIndexInfrastructureExtension() {
        return SystemProperties.getBooleanProperty((String)"idea.use.only.index.infrastructure.extension", (boolean)false);
    }

    @NotNull
    public final UpdatableIndex<Key, Value, FileContent, FileIndexMetaData> getBaseIndex() {
        UpdatableIndex<Key, Value, FileContent, FileIndexMetaData> updatableIndex = this.myBaseIndex;
        if (updatableIndex == null) {
            CompositeInvertedIndexBase.$$$reportNull$$$0(19);
        }
        return updatableIndex;
    }

    protected abstract void getSecondaryIndexData(@NotNull Key var1, Consumer<? super ValueContainer<Value>> var2) throws StorageException;

    protected abstract void disposeSecondaryIndex();

    protected abstract void flushSecondaryIndex() throws StorageException;

    protected abstract void clearSecondaryIndex() throws StorageException;

    @NotNull
    protected abstract IndexInfrastructureUpdate tryToMapWithSecondaryIndex(int var1, @NotNull FileContent var2);

    @NotNull
    protected abstract Computable<Boolean> removeFromSecondaryIndex(int var1);

    @Nullable
    protected abstract Map<Key, Value> getSecondaryIndexFileData(int var1) throws StorageException;

    protected abstract boolean processAllKeysBySecondaryIndex(@NotNull Processor<? super Key> var1, @NotNull GlobalSearchScope var2, @Nullable IdFilter var3) throws StorageException;

    protected abstract void setSecondaryIndexBufferingEnabled(boolean var1);

    protected abstract void cleanupSecondaryIndexMemoryStorage();

    @TestOnly
    protected abstract void cleanupSecondaryIndexForNextTest();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9, 10, 11, 15, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/composite/CompositeInvertedIndexBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/composite/CompositeInvertedIndexBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetIndexedFileData";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingStateForFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "updateBaseIndex";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareUpdate";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileIndexMetaData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStateForFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9, 10, 11, 15, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    protected static class IndexInfrastructureUpdate {
        private final boolean isIndexProvided;
        private final Computable<Boolean> update;

        public IndexInfrastructureUpdate(boolean isIndexProvided, Computable<Boolean> update) {
            this.isIndexProvided = isIndexProvided;
            this.update = update;
        }
    }
}

