/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.intellij.indexing.shared.platform.impl.SharedIndexMainZipStorage;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u001c\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a0\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0002\u001a\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\r\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "doTakeSnapshotRecursively", "", "", "", "root", "Ljava/nio/file/Path;", "ensureSnapshotsEqual", "", "expectedSnapshot", "actualSnapshot", "takeSourceChunkSnapshot", "chunkPath", "takeStoredChunkSnapshot", "chunkRoot", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexMainZipStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexMainZipStorage.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexMainZipStorageKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,235:1\n13#2:236\n*S KotlinDebug\n*F\n+ 1 SharedIndexMainZipStorage.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexMainZipStorageKt\n*L\n28#1:236\n*E\n"})
public final class SharedIndexMainZipStorageKt {
    @NotNull
    private static final Logger LOG;

    private static final void ensureSnapshotsEqual(Map<String, Long> expectedSnapshot, Map<String, Long> actualSnapshot) throws IOException {
        MapDifference diff = Maps.difference(actualSnapshot, expectedSnapshot);
        Map missedFiles = diff.entriesOnlyOnLeft();
        Map differedFiles = diff.entriesDiffering();
        Map superfluousFiles = diff.entriesOnlyOnRight();
        if (missedFiles.isEmpty() && differedFiles.isEmpty() && superfluousFiles.isEmpty()) {
            return;
        }
        Intrinsics.checkNotNull((Object)missedFiles);
        if (!missedFiles.isEmpty()) {
            throw new IOException("Shared index chunk files " + missedFiles.keySet() + " were not copied to shared index central storage");
        }
        Intrinsics.checkNotNull((Object)superfluousFiles);
        if (!superfluousFiles.isEmpty()) {
            LOG.error("Superfluous files has been observed after chunk was copied " + superfluousFiles.keySet());
            return;
        }
        Intrinsics.checkNotNull((Object)differedFiles);
        if (!differedFiles.isEmpty()) {
            throw new IOException("Shared index chunk files " + differedFiles + " corrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, Long> takeSourceChunkSnapshot(Path chunkPath) {
        Map<String, Long> map;
        Closeable closeable = UncompressedZipFileSystem.create(chunkPath);
        Throwable throwable = null;
        try {
            UncompressedZipFileSystem chunkFs = (UncompressedZipFileSystem)closeable;
            boolean bl = false;
            Path path = chunkFs.getRootDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getRootDirectory(...)");
            map = SharedIndexMainZipStorageKt.doTakeSnapshotRecursively(path);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map;
    }

    private static final Map<String, Long> takeStoredChunkSnapshot(Path chunkRoot) {
        return SharedIndexMainZipStorageKt.doTakeSnapshotRecursively(chunkRoot);
    }

    private static final Map<String, Long> doTakeSnapshotRecursively(Path root) {
        Map snapshot2 = new LinkedHashMap();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(root, (Map<String, Long>)snapshot2){
            final /* synthetic */ Path $root;
            final /* synthetic */ Map<String, Long> $snapshot;
            {
                this.$root = $root;
                this.$snapshot = $snapshot;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    String normalized = StringsKt.removePrefix((String)StringsKt.removePrefix((String)((Object)file.toAbsolutePath()).toString(), (CharSequence)((Object)this.$root).toString()), (CharSequence)"/");
                    this.$snapshot.put(normalized, Files.size(file));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Map<String, Long> map = Collections.unmodifiableMap(snapshot2);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        return map;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Map access$takeSourceChunkSnapshot(Path chunkPath) {
        return SharedIndexMainZipStorageKt.takeSourceChunkSnapshot(chunkPath);
    }

    public static final /* synthetic */ Map access$takeStoredChunkSnapshot(Path chunkRoot) {
        return SharedIndexMainZipStorageKt.takeStoredChunkSnapshot(chunkRoot);
    }

    public static final /* synthetic */ void access$ensureSnapshotsEqual(Map expectedSnapshot, Map actualSnapshot) {
        SharedIndexMainZipStorageKt.ensureSnapshotsEqual(expectedSnapshot, actualSnapshot);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexMainZipStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

