/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.CachingExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.UnindexedFilesScannerExecutor;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import icons.GradleIcons;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.GradleAutoImportAware;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.settings.GradleConfigurable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public final class GradleManager
implements ExternalSystemConfigurableAware,
ExternalSystemUiAware,
ExternalSystemAutoImportAware,
StartupActivity,
ExternalSystemManager<GradleProjectSettings, GradleSettingsListener, GradleSettings, GradleLocalSettings, GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleManager.class);
    @NotNull
    private final ExternalSystemAutoImportAware myAutoImportDelegate = new CachingExternalSystemAutoImportAware((ExternalSystemAutoImportAware)new GradleAutoImportAware());

    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            GradleManager.$$$reportNull$$$0(0);
        }
        return projectSystemId;
    }

    @NotNull
    public Function<Project, GradleSettings> getSettingsProvider() {
        Function function = project2 -> GradleSettings.getInstance(project2);
        if (function == null) {
            GradleManager.$$$reportNull$$$0(1);
        }
        return function;
    }

    @NotNull
    public Function<Project, GradleLocalSettings> getLocalSettingsProvider() {
        Function function = project2 -> GradleLocalSettings.getInstance(project2);
        if (function == null) {
            GradleManager.$$$reportNull$$$0(2);
        }
        return function;
    }

    @NotNull
    public Function<Pair<Project, String>, GradleExecutionSettings> getExecutionSettingsProvider() {
        Function function = pair -> {
            Project project2 = (Project)pair.first;
            String projectPath = (String)pair.second;
            GradleSettings settings2 = GradleSettings.getInstance(project2);
            GradleProjectSettings projectLevelSettings = (GradleProjectSettings)settings2.getLinkedProjectSettings(projectPath);
            String rootProjectPath = projectLevelSettings != null ? projectLevelSettings.getExternalProjectPath() : projectPath;
            GradleInstallationManager gradleInstallationManager = GradleInstallationManager.getInstance();
            File gradleHome2 = gradleInstallationManager.getGradleHome(project2, rootProjectPath);
            String localGradlePath = null;
            if (gradleHome2 != null) {
                try {
                    localGradlePath = gradleHome2.getCanonicalPath();
                }
                catch (IOException e) {
                    localGradlePath = gradleHome2.getAbsolutePath();
                }
            }
            DistributionType distributionType = projectLevelSettings == null ? (GradleUtil.isGradleDefaultWrapperFilesExist(rootProjectPath) ? DistributionType.DEFAULT_WRAPPED : DistributionType.BUNDLED) : (projectLevelSettings.getDistributionType() == null ? DistributionType.LOCAL : projectLevelSettings.getDistributionType());
            GradleExecutionSettings result = new GradleExecutionSettings(localGradlePath, settings2.getServiceDirectoryPath(), distributionType, settings2.getGradleVmOptions(), settings2.isOfflineWork());
            String javaHome = gradleInstallationManager.getGradleJvmPath(project2, rootProjectPath);
            if (!StringUtil.isEmpty((String)javaHome)) {
                LOG.info("Instructing gradle to use java from " + javaHome);
            }
            result.setJavaHome(javaHome);
            GradleSystemSettings systemSettings = GradleSystemSettings.getInstance();
            String vmOptions = Objects.requireNonNullElse(settings2.getGradleVmOptions(), "");
            if (vmOptions.contains("-Didea.gradle.download.sources.force=false")) {
                result.setDownloadSources(false);
            } else {
                result.setDownloadSources(systemSettings.isDownloadSources());
            }
            result.setParallelModelFetch(settings2.isParallelModelFetch());
            Object ideProjectPath = project2.getBasePath() == null || project2.getProjectFilePath() != null && StringUtil.endsWith((CharSequence)project2.getProjectFilePath(), (CharSequence)".ipr") ? rootProjectPath : project2.getBasePath() + "/.idea/modules";
            result.setIdeProjectPath((String)ideProjectPath);
            if (projectLevelSettings != null) {
                result.setResolveModulePerSourceSet(projectLevelSettings.isResolveModulePerSourceSet());
                result.setUseQualifiedModuleNames(projectLevelSettings.isUseQualifiedModuleNames());
            }
            boolean delegatedBuildEnabled = GradleProjectSettings.isDelegatedBuildEnabled(project2, projectPath);
            result.setDelegatedBuild(delegatedBuildEnabled);
            GradleManager.configureExecutionWorkspace(projectLevelSettings, settings2, result, project2, projectPath);
            return result;
        };
        if (function == null) {
            GradleManager.$$$reportNull$$$0(3);
        }
        return function;
    }

    private static void configureExecutionWorkspace(@Nullable GradleProjectSettings compositeRootSettings, GradleSettings settings2, GradleExecutionSettings result, Project project2, String projectPath) {
        if (compositeRootSettings == null || compositeRootSettings.getCompositeBuild() == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = compositeRootSettings.getCompositeBuild();
        if (compositeBuild.getCompositeDefinitionSource() == CompositeDefinitionSource.SCRIPT) {
            if (FileUtil.pathsEqual((String)compositeRootSettings.getExternalProjectPath(), (String)projectPath)) {
                return;
            }
            for (BuildParticipant buildParticipant : compositeBuild.getCompositeParticipants()) {
                if (FileUtil.pathsEqual((String)buildParticipant.getRootPath(), (String)projectPath) || Path.of(buildParticipant.getRootPath(), new String[0]).endsWith("buildSrc") || buildParticipant.getProjects().stream().anyMatch(path -> FileUtil.pathsEqual((String)path, (String)projectPath))) continue;
                result.getExecutionWorkspace().addBuildParticipant(new GradleBuildParticipant(buildParticipant.getRootPath()));
            }
            return;
        }
        for (GradleProjectSettings projectSettings : settings2.getLinkedProjectsSettings()) {
            if (projectSettings == compositeRootSettings || compositeBuild.getCompositeParticipants().stream().noneMatch(participant -> FileUtil.pathsEqual((String)participant.getRootPath(), (String)projectSettings.getExternalProjectPath()))) continue;
            GradleBuildParticipant buildParticipant = new GradleBuildParticipant(projectSettings.getExternalProjectPath());
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(project2, GradleConstants.SYSTEM_ID, projectSettings.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) continue;
            Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE);
            for (DataNode moduleNode : moduleNodes) {
                ModuleData moduleData = (ModuleData)moduleNode.getData();
                if (moduleData.getArtifacts().isEmpty()) {
                    Collection sourceSetNodes = ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY);
                    for (DataNode sourceSetNode : sourceSetNodes) {
                        buildParticipant.addModule((ModuleData)sourceSetNode.getData());
                    }
                    continue;
                }
                buildParticipant.addModule(moduleData);
            }
            result.getExecutionWorkspace().addBuildParticipant(buildParticipant);
        }
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) {
        if (parameters == null) {
            GradleManager.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Class<? extends ExternalSystemProjectResolver<GradleExecutionSettings>> getProjectResolverClass() {
        return GradleProjectResolver.class;
    }

    public Class<? extends ExternalSystemTaskManager<GradleExecutionSettings>> getTaskManagerClass() {
        return GradleTaskManager.class;
    }

    @NotNull
    public Configurable getConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            GradleManager.$$$reportNull$$$0(5);
        }
        return new GradleConfigurable(project2);
    }

    @Nullable
    public FileChooserDescriptor getExternalProjectConfigDescriptor() {
        return FileChooserDescriptorFactory.createSingleFolderDescriptor();
    }

    @Nullable
    public Icon getProjectIcon() {
        return GradleIcons.GradleFile;
    }

    @Nullable
    public Icon getTaskIcon() {
        return DefaultExternalSystemUiAware.INSTANCE.getTaskIcon();
    }

    @NotNull
    public String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        if (targetProjectPath == null) {
            GradleManager.$$$reportNull$$$0(6);
        }
        String string2 = ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)rootProjectPath);
        if (string2 == null) {
            GradleManager.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @NotNull
    public String getProjectRepresentationName(@NotNull Project project2, @NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        GradleProjectSettings projectSettings;
        if (project2 == null) {
            GradleManager.$$$reportNull$$$0(8);
        }
        if (targetProjectPath == null) {
            GradleManager.$$$reportNull$$$0(9);
        }
        if ((projectSettings = (GradleProjectSettings)GradleSettings.getInstance(project2).getLinkedProjectSettings(targetProjectPath)) != null && projectSettings.getCompositeBuild() != null) {
            for (BuildParticipant buildParticipant : projectSettings.getCompositeBuild().getCompositeParticipants()) {
                if (!buildParticipant.getProjects().contains(targetProjectPath)) continue;
                String string2 = ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)buildParticipant.getRootPath());
                if (string2 == null) {
                    GradleManager.$$$reportNull$$$0(10);
                }
                return string2;
            }
        }
        String string3 = ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)rootProjectPath);
        if (string3 == null) {
            GradleManager.$$$reportNull$$$0(11);
        }
        return string3;
    }

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project2) {
        if (changedFileOrDirPath == null) {
            GradleManager.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            GradleManager.$$$reportNull$$$0(13);
        }
        return this.myAutoImportDelegate.getAffectedExternalProjectPath(changedFileOrDirPath, project2);
    }

    public List<File> getAffectedExternalProjectFiles(String projectPath, @NotNull Project project2) {
        if (project2 == null) {
            GradleManager.$$$reportNull$$$0(14);
        }
        return this.myAutoImportDelegate.getAffectedExternalProjectFiles(projectPath, project2);
    }

    public boolean isApplicable(@Nullable ProjectResolverPolicy resolverPolicy) {
        return this.myAutoImportDelegate.isApplicable(resolverPolicy);
    }

    @NotNull
    public FileChooserDescriptor getExternalProjectDescriptor() {
        FileChooserDescriptor fileChooserDescriptor2 = GradleUtil.getGradleProjectFileChooserDescriptor();
        if (fileChooserDescriptor2 == null) {
            GradleManager.$$$reportNull$$$0(15);
        }
        return fileChooserDescriptor2;
    }

    @Nullable
    public GlobalSearchScope getSearchScope(@NotNull Project project2, @NotNull ExternalSystemTaskExecutionSettings taskExecutionSettings) {
        String projectPath;
        if (project2 == null) {
            GradleManager.$$$reportNull$$$0(16);
        }
        if (taskExecutionSettings == null) {
            GradleManager.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmpty((String)(projectPath = taskExecutionSettings.getExternalProjectPath()))) {
            return null;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)((GradleSettings)((Object)this.getSettingsProvider().fun((Object)project2))).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return null;
        }
        if (!projectSettings.isResolveModulePerSourceSet()) {
            return null;
        }
        List modules = JBIterable.of((Object[])ModuleManager.getInstance((Project)project2).getModules()).filter(module -> StringUtil.equals((CharSequence)projectPath, (CharSequence)ExternalSystemApiUtil.getExternalProjectPath((Module)module))).toList();
        return modules.isEmpty() ? null : ExecutionSearchScopes.executionScope((Collection)modules);
    }

    @NotNull
    public List<ExtensionPointName<?>> getExtensionPointsForResolver() {
        List<ExtensionPointName<?>> list2 = List.of(GradleProjectResolverExtension.EP_NAME);
        if (list2 == null) {
            GradleManager.$$$reportNull$$$0(18);
        }
        return list2;
    }

    public void runActivity(final @NotNull Project project2) {
        if (project2 == null) {
            GradleManager.$$$reportNull$$$0(19);
        }
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(GradleSettings.getInstance(project2).getChangesTopic(), (Object)new GradleSettingsListener(){

            @Override
            public void onServiceDirectoryPathChange(@Nullable String oldPath, @Nullable String newPath) {
                for (GradleProjectSettings projectSettings : GradleSettings.getInstance(project2).getLinkedProjectsSettings()) {
                    ExternalProjectsManager.getInstance((Project)project2).getExternalProjectsWatcher().markDirty(projectSettings.getExternalProjectPath());
                }
            }

            @Override
            public void onGradleHomeChange(@Nullable String oldPath, @Nullable String newPath, @NotNull String linkedProjectPath) {
                if (linkedProjectPath == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExternalProjectsManager.getInstance((Project)project2).getExternalProjectsWatcher().markDirty(linkedProjectPath);
            }

            @Override
            public void onGradleDistributionTypeChange(DistributionType currentValue, @NotNull String linkedProjectPath) {
                if (linkedProjectPath == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExternalProjectsManager.getInstance((Project)project2).getExternalProjectsWatcher().markDirty(linkedProjectPath);
            }

            @Override
            public void onBuildDelegationChange(boolean delegatedBuild, @NotNull String linkedProjectPath) {
                if (linkedProjectPath == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!this.updateOutputRoots(delegatedBuild, linkedProjectPath)) {
                    ExternalProjectsManager.getInstance((Project)project2).getExternalProjectsWatcher().markDirty(linkedProjectPath);
                }
            }

            private boolean updateOutputRoots(final boolean delegatedBuild, @NotNull String linkedProjectPath) {
                ExternalProjectInfo projectInfo;
                if (linkedProjectPath == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((projectInfo = ProjectDataManager.getInstance().getExternalProjectData(project2, GradleConstants.SYSTEM_ID, linkedProjectPath)) == null) {
                    return false;
                }
                String buildNumber = projectInfo.getBuildNumber();
                if (buildNumber == null) {
                    return false;
                }
                final DataNode projectStructure = projectInfo.getExternalProjectStructure();
                if (projectStructure == null) {
                    return false;
                }
                final String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{((ProjectData)projectStructure.getData()).getExternalName(), projectInfo.getProjectSystemId().getReadableName()});
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, title, false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        UnindexedFilesScannerExecutor.getInstance((Project)project2).suspendScanningAndIndexingThenRun(title, () -> {
                            for (DataNode moduleDataNode : ExternalSystemApiUtil.findAll((DataNode)projectStructure, (Key)ProjectKeys.MODULE)) {
                                ((ModuleData)moduleDataNode.getData()).useExternalCompilerOutput(delegatedBuild);
                                for (DataNode sourceSetDataNode : ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, GradleSourceSetData.KEY)) {
                                    ((GradleSourceSetData)((Object)((Object)sourceSetDataNode.getData()))).useExternalCompilerOutput(delegatedBuild);
                                }
                                GradleManager.configureExcludeOutDir((DataNode<ModuleData>)moduleDataNode, delegatedBuild);
                            }
                            ProjectDataManager.getInstance().importData(projectStructure, project2);
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/gradle/GradleManager$1$1", "run"));
                    }
                });
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "linkedProjectPath";
                objectArray2[1] = "org/jetbrains/plugins/gradle/GradleManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onGradleHomeChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onGradleDistributionTypeChange";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBuildDelegationChange";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateOutputRoots";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Map<String, String> adjustedPaths = GradleManager.patchLinkedProjects(project2);
        if (adjustedPaths == null) {
            return;
        }
        GradleLocalSettings localSettings = GradleLocalSettings.getInstance(project2);
        GradleManager.patchRecentTasks(adjustedPaths, localSettings);
        GradleManager.patchAvailableProjects(adjustedPaths, localSettings);
    }

    private static void configureExcludeOutDir(DataNode<ModuleData> moduleDataNode, boolean delegatedBuild) {
        ModuleData module = (ModuleData)moduleDataNode.getData();
        File ideaOutDir = new File(module.getLinkedExternalProjectPath(), "out");
        module.useExternalCompilerOutput(delegatedBuild);
        if (!delegatedBuild) {
            GradleUtil.excludeOutDir(moduleDataNode, ideaOutDir);
        } else {
            GradleUtil.unexcludeOutDir(moduleDataNode, ideaOutDir);
        }
    }

    @Nullable
    private static Map<String, String> patchLinkedProjects(@NotNull Project project2) {
        if (project2 == null) {
            GradleManager.$$$reportNull$$$0(20);
        }
        GradleSettings settings2 = GradleSettings.getInstance(project2);
        ArrayList<GradleProjectSettings> correctedSettings = new ArrayList<GradleProjectSettings>();
        HashMap<String, String> adjustedPaths = new HashMap<String, String>();
        for (GradleProjectSettings projectSettings : settings2.getLinkedProjectsSettings()) {
            String oldPath = projectSettings.getExternalProjectPath();
            if (oldPath != null && new File(oldPath).isFile() && FileUtilRt.extensionEquals((String)oldPath, (String)"gradle")) {
                try {
                    String newPath = new File(oldPath).getParentFile().getCanonicalPath();
                    projectSettings.setExternalProjectPath(newPath);
                    adjustedPaths.put(oldPath, newPath);
                }
                catch (IOException e) {
                    LOG.warn(String.format("Unexpected exception occurred on attempt to re-point linked gradle project path from build.gradle to its parent dir. Path: %s", oldPath), (Throwable)e);
                }
            }
            correctedSettings.add(projectSettings);
        }
        if (adjustedPaths.isEmpty()) {
            return null;
        }
        settings2.setLinkedProjectsSettings(correctedSettings);
        return adjustedPaths;
    }

    private static void patchAvailableProjects(@NotNull Map<String, String> adjustedPaths, @NotNull GradleLocalSettings localSettings) {
        if (adjustedPaths == null) {
            GradleManager.$$$reportNull$$$0(21);
        }
        if (localSettings == null) {
            GradleManager.$$$reportNull$$$0(22);
        }
        HashMap<ExternalProjectPojo, Collection> adjustedAvailableProjects = new HashMap<ExternalProjectPojo, Collection>();
        for (Map.Entry entry : localSettings.getAvailableProjects().entrySet()) {
            String newPath = adjustedPaths.get(((ExternalProjectPojo)entry.getKey()).getPath());
            if (newPath == null) {
                adjustedAvailableProjects.put((ExternalProjectPojo)entry.getKey(), (Collection)entry.getValue());
                continue;
            }
            adjustedAvailableProjects.put(new ExternalProjectPojo(((ExternalProjectPojo)entry.getKey()).getName(), newPath), (Collection)entry.getValue());
        }
        localSettings.setAvailableProjects(adjustedAvailableProjects);
    }

    private static void patchRecentTasks(@NotNull Map<String, String> adjustedPaths, @NotNull GradleLocalSettings localSettings) {
        if (adjustedPaths == null) {
            GradleManager.$$$reportNull$$$0(23);
        }
        if (localSettings == null) {
            GradleManager.$$$reportNull$$$0(24);
        }
        for (ExternalTaskExecutionInfo taskInfo : localSettings.getRecentTasks()) {
            ExternalSystemTaskExecutionSettings s = taskInfo.getSettings();
            String newPath = adjustedPaths.get(s.getExternalProjectPath());
            if (newPath == null) continue;
            s.setExternalProjectPath(newPath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 8, 9, 12, 13, 14, 16, 17, 19, 20, 21, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/GradleManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProjectPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFileOrDirPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutionSettings";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjustedPaths";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSettingsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionSettingsProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/GradleManager";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRepresentationName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPointsForResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enhanceRemoteProcessing";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurable";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRepresentationName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedExternalProjectPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedExternalProjectFiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "patchLinkedProjects";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "patchAvailableProjects";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "patchRecentTasks";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 4, 5, 6, 8, 9, 12, 13, 14, 16, 17, 19, 20, 21, 22, 23, 24 -> new IllegalArgumentException(string2);
        };
    }
}

