/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.util.lang.JavaVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.ConfigurableGradleBuildIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleJvmBuildIssue;", "Lorg/jetbrains/plugins/gradle/issue/ConfigurableGradleBuildIssue;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "projectPath", "", "(Lorg/gradle/util/GradleVersion;Lcom/intellij/util/lang/JavaVersion;Ljava/lang/String;)V", "intellij.gradle"})
final class UnsupportedGradleJvmBuildIssue
extends ConfigurableGradleBuildIssue {
    public UnsupportedGradleJvmBuildIssue(@NotNull GradleVersion gradleVersion2, @Nullable JavaVersion javaVersion, @NotNull String projectPath) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        JavaVersion oldestSupportedJavaVersionByIdea = GradleJvmSupportMatrix.Companion.getOldestSupportedJavaVersionByIdea();
        JavaVersion oldestSupportedJavaVersionByGradle = GradleJvmSupportMatrix.Companion.suggestOldestSupportedJavaVersion(gradleVersion2);
        JavaVersion javaVersion2 = oldestSupportedJavaVersionByGradle;
        if (javaVersion2 == null) {
            javaVersion2 = oldestSupportedJavaVersionByIdea;
        }
        JavaVersion oldestSupportedJavaVersion = javaVersion2;
        String string2 = GradleBundle.message("gradle.build.issue.gradle.jvm.unsupported.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.setTitle(string2);
        if (javaVersion == null) {
            String string3 = GradleBundle.message("gradle.build.issue.gradle.jvm.unsupported.unknown.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this.addDescription(string3);
        } else {
            objectArray = new Object[]{javaVersion};
            String string4 = GradleBundle.message("gradle.build.issue.gradle.jvm.unsupported.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            this.addDescription(string4);
        }
        objectArray = new Object[]{oldestSupportedJavaVersion};
        String string5 = GradleBundle.message("gradle.build.issue.gradle.jvm.supported.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        this.addDescription(string5);
        this.addGradleJvmQuickFix(projectPath, oldestSupportedJavaVersion);
    }
}

