/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jxmpp.jid.Jid;

public class BytestreamsProvider
extends IQProvider<Bytestream> {
    @Override
    public Bytestream parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        boolean done = false;
        Bytestream toReturn = new Bytestream();
        String id = parser.getAttributeValue("", "sid");
        String mode = parser.getAttributeValue("", "mode");
        Jid JID = null;
        String host = null;
        String port2 = null;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            String elementName = parser.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (elementName.equals(Bytestream.StreamHost.ELEMENTNAME)) {
                    JID = ParserUtils.getJidAttribute(parser);
                    host = parser.getAttributeValue("", "host");
                    port2 = parser.getAttributeValue("", "port");
                    continue;
                }
                if (elementName.equals(Bytestream.StreamHostUsed.ELEMENTNAME)) {
                    toReturn.setUsedHost(ParserUtils.getJidAttribute(parser));
                    continue;
                }
                if (!elementName.equals(Bytestream.Activate.ELEMENTNAME)) continue;
                toReturn.setToActivate(ParserUtils.getJidAttribute(parser));
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT) continue;
            if (elementName.equals("streamhost")) {
                if (port2 == null) {
                    toReturn.addStreamHost(JID, host);
                } else {
                    toReturn.addStreamHost(JID, host, Integer.parseInt(port2));
                }
                JID = null;
                host = null;
                port2 = null;
                continue;
            }
            if (!elementName.equals("query")) continue;
            done = true;
        }
        if (mode == null) {
            toReturn.setMode(Bytestream.Mode.tcp);
        } else {
            toReturn.setMode(Bytestream.Mode.fromName(mode));
        }
        toReturn.setSessionID(id);
        return toReturn;
    }
}

