/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import java.io.Serializable;
import java.util.Hashtable;

public class ASN1OID
implements Serializable {
    private static Hashtable id2name = new Hashtable(50);
    private static Hashtable name2id = new Hashtable(50);
    public static String rsadsi = "1 2 840 113549";
    public static String x9_57 = "1 2 840 10040";
    public static String ansi_x942 = "1 2 840 10046";
    public static String digestAlgorithm = rsadsi + " 2";
    public static String md2 = digestAlgorithm + " 2";
    public static String md4 = digestAlgorithm + " 4";
    public static String md5 = digestAlgorithm + " 5";
    public static String encryptionAlgorithm = rsadsi + " 3";
    public static String rc2_cbc = encryptionAlgorithm + " 2";
    public static String des_ede3_cbc = encryptionAlgorithm + " 7";
    public static String pkcs = rsadsi + " 1";
    public static String pkcs_1 = pkcs + " 1";
    public static String rsaEncryption = pkcs_1 + " 1";
    public static String md2WithRSAEncryption = pkcs_1 + " 2";
    public static String md4WithRSAEncryption = pkcs_1 + " 3";
    public static String md5WithRSAEncryption = pkcs_1 + " 4";
    public static String sha1WithRSAEncryption = pkcs_1 + " 5";
    public static String pkcs_5 = pkcs + " 5";
    public static String pbeWithMD2AndDES_CBC = pkcs_5 + " 1";
    public static String pbeWithMD5AndDES_CBC = pkcs_5 + " 3";
    public static String pbeWithSHA1AndDES_CBC = pkcs_5 + " 10";
    public static String pbeWithSHA1AndRC2_CBC = pkcs_5 + " 11";
    public static String pbeWithSHA1AndRC4 = pkcs_5 + " 12";
    public static String pkcs_9 = pkcs + " 9";
    public static String emailAddress = pkcs_9 + " 1";
    public static String unstructuredName = pkcs_9 + " 2";
    public static String contentType = pkcs_9 + " 3";
    public static String messageDigest = pkcs_9 + " 4";
    public static String signingTime = pkcs_9 + " 5";
    public static String countersignature = pkcs_9 + " 6";
    public static String challengePassword = pkcs_9 + " 7";
    public static String unstructuredAddress = pkcs_9 + " 8";
    public static String extendedCertificateAttributes = pkcs_9 + " 9";
    public static String friendlyName = pkcs_9 + " 20";
    public static String localKeyID = pkcs_9 + " 21";
    public static String certTypes = pkcs_9 + " 22";
    public static String x509Certificate = certTypes + " 1";
    public static String sdsiCertificate = certTypes + " 2";
    public static String crlTypes = pkcs_9 + " 23";
    public static String x509Crl = crlTypes + " 1";
    public static String pkcs_7 = pkcs + " 7";
    public static String data = pkcs_7 + " 1";
    public static String signedData = pkcs_7 + " 2";
    public static String envelopedData = pkcs_7 + " 3";
    public static String signedAndEnvelopedData = pkcs_7 + " 4";
    public static String digestedData = pkcs_7 + " 5";
    public static String encryptedData = pkcs_7 + " 6";
    public static String ct_authData = pkcs_9 + " 16 1 2";
    public static String macValue = pkcs_9 + " 16 2 8";
    public static String pkcs_12 = pkcs + " 12";
    public static String pkcs_12PbeIds = pkcs_12 + " 1";
    public static String pbeWithSHA1And128BitRC4 = pkcs_12PbeIds + " 1";
    public static String pbeWithSHA1And40BitRC4 = pkcs_12PbeIds + " 2";
    public static String pbeWithSHA1And3DES = pkcs_12PbeIds + " 3";
    public static String pbeWithSHA1And2DES = pkcs_12PbeIds + " 4";
    public static String pbeWithSHA1And128BitRC2 = pkcs_12PbeIds + " 5";
    public static String pbeWithSHA1And40BitRC2 = pkcs_12PbeIds + " 6";
    public static String pkcs_12Version1 = pkcs_12 + " 10";
    public static String pkcs_12BagIds = pkcs_12Version1 + " 1";
    public static String keyBag = pkcs_12BagIds + " 1";
    public static String pkcs_8ShroudedKeyBag = pkcs_12BagIds + " 2";
    public static String certBag = pkcs_12BagIds + " 3";
    public static String crlBag = pkcs_12BagIds + " 4";
    public static String secretBag = pkcs_12BagIds + " 5";
    public static String safeContentsBag = pkcs_12BagIds + " 6";
    public static String pkcs_12CertBagIds = pkcs_12 + " 4";
    public static String x509CertCRLBagId = pkcs_12CertBagIds + " 1";
    public static String SDSICertBagId = pkcs_12CertBagIds + " 2";
    public static String X500 = "2 5";
    public static String X509 = X500 + " 4";
    public static String commonName = X509 + " 3";
    public static String country = X509 + " 6";
    public static String locality = X509 + " 7";
    public static String stateOrProvince = X509 + " 8";
    public static String organization = X509 + " 10";
    public static String organizationalUnit = X509 + " 11";
    public static String surname = X509 + " 4";
    public static String serialNumber = X509 + " 5";
    public static String title = X509 + " 12";
    public static String description = X509 + " 13";
    public static String givenName = X509 + " 42";
    public static String initials = X509 + " 43";
    public static String uniqueIdentifier = X509 + " 45";
    public static String ld_ce = "2.5.29";
    public static String subjectKeyIdentifier = ld_ce + ".14";
    public static String keyUsage = ld_ce + ".15";
    public static String privateKeyUsagePeriod = ld_ce + ".16";
    public static String subjectAltName = ld_ce + ".17";
    public static String issuerAltName = ld_ce + ".18";
    public static String basicConstraints = ld_ce + ".19";
    public static String crlNumber = ld_ce + ".20";
    public static String nameConstraints = ld_ce + ".30";
    public static String crlDistributionPoints = ld_ce + ".31";
    public static String certificatePolicies = ld_ce + ".32";
    public static String policyMappings = ld_ce + ".33";
    public static String authorityKeyIdentifier = ld_ce + ".35";
    public static String policyConstraints = ld_ce + ".36";
    public static String extendedKeyUsage = ld_ce + ".37";
    public static String id_pkix_dot = "1.3.6.1.5.5.7";
    public static String id_pe_dot = id_pkix_dot + ".1";
    public static String id_pe_authorityInfoAccess = id_pe_dot + ".1";
    public static String CRLReason = ld_ce + " 21";
    public static String CRLNumber = ld_ce + " 20";
    public static String invalidityDate = ld_ce + " 24";
    public static String deltaCRLIndicator = ld_ce + " 27";
    public static String certIssuer = ld_ce + " 29";
    public static String issuingDPoint = ld_ce + " 28";
    public static String id_pkix = "1 3 6 1 5 5 7";
    public static String id_pe = id_pkix + " 1";
    public static String id_ad = id_pkix + " 48";
    public static String authInfoAccessOCSP = id_ad + " 1";
    public static String authInfoAccesscaIssuers = id_ad + " 2";
    public static String cpsOID = id_pkix + " 2 1";
    public static String userNoticeOID = id_pkix + " 2 2";
    public static String id_kp = id_pkix + " 3";
    public static String id_kp_serverAuth = id_kp + " 1";
    public static String id_kp_clientAuth = id_kp + " 2";
    public static String id_kp_codeSigning = id_kp + " 3";
    public static String id_kp_emailProtection = id_kp + " 4";
    public static String id_kp_ipsecEndSystem = id_kp + " 5";
    public static String id_kp_ipsecTunnel = id_kp + " 6";
    public static String id_kp_ipsecUser = id_kp + " 7";
    public static String id_kp_timeStamping = id_kp + " 8";
    public static String id_kp_OCSPSigning = id_kp + " 9";
    public static String id_dsa = x9_57 + "4 1";
    public static String dhpublicnumber = ansi_x942 + "2 1";
    public static String algorithm = "1 3 14 3 2";
    public static String sha = algorithm + " 18";
    public static String sha1 = algorithm + " 26";
    public static String shaWithRSAEncryption = algorithm + " 15";
    public static String netscape = "2 16 840 1 113730";
    public static String netscapeCertExt = netscape + " 1";
    public static String netscapeCertType = netscapeCertExt + " 1";
    public static String netscapeComment = netscapeCertExt + " 13";

    public static String getName(String id) {
        String name = (String)id2name.get(id);
        if (name == null) {
            return id;
        }
        return name;
    }

    public static String getID(String name) {
        String id = (String)name2id.get(name);
        if (id == null) {
            return name;
        }
        return id;
    }

    private static void register(String id, String name) {
        id2name.put(id, name);
        name2id.put(name, id);
    }

    static {
        ASN1OID.register(md2, "md2");
        ASN1OID.register(md4, "md4");
        ASN1OID.register(md5, "md5");
        ASN1OID.register(sha1, "sha1");
        ASN1OID.register(rsaEncryption, "rsaEncryption");
        ASN1OID.register(des_ede3_cbc, "des_ede3_cbc");
        ASN1OID.register(rc2_cbc, "rc2_cbc");
        ASN1OID.register(md2WithRSAEncryption, "md2WithRSAEncryption");
        ASN1OID.register(md4WithRSAEncryption, "md4WithRSAEncryption");
        ASN1OID.register(md5WithRSAEncryption, "md5WithRSAEncryption");
        ASN1OID.register(sha1WithRSAEncryption, "sha1WithRSAEncryption");
        ASN1OID.register(country, "country");
        ASN1OID.register(stateOrProvince, "stateOrProvince");
        ASN1OID.register(locality, "locality");
        ASN1OID.register(organization, "organization");
        ASN1OID.register(organizationalUnit, "organizationalUnit");
        ASN1OID.register(commonName, "commonName");
        ASN1OID.register(surname, "surname");
        ASN1OID.register(serialNumber, "serialNumber");
        ASN1OID.register(title, "title");
        ASN1OID.register(description, "description");
        ASN1OID.register(givenName, "givenName");
        ASN1OID.register(initials, "initials");
        ASN1OID.register(uniqueIdentifier, "uniqueIdentifier");
        ASN1OID.register(emailAddress, "emailAddress");
        ASN1OID.register(unstructuredName, "unstructuredName");
        ASN1OID.register(contentType, "contentType");
        ASN1OID.register(messageDigest, "messageDigest");
        ASN1OID.register(signingTime, "signingTime");
        ASN1OID.register(countersignature, "countersignature");
        ASN1OID.register(challengePassword, "challengePassword");
        ASN1OID.register(unstructuredAddress, "unstructuredAddress");
        ASN1OID.register(data, "data");
        ASN1OID.register(signedData, "signedData");
        ASN1OID.register(envelopedData, "envelopedData");
        ASN1OID.register(signedAndEnvelopedData, "signedAndEnvelopedData");
        ASN1OID.register(digestedData, "digestedData");
        ASN1OID.register(encryptedData, "encryptedData");
        ASN1OID.register(ct_authData, "ct_authData");
        ASN1OID.register(macValue, "macValue");
        ASN1OID.register(subjectKeyIdentifier, "Subject Key Identifier");
        ASN1OID.register(keyUsage, "Key Usage");
        ASN1OID.register(privateKeyUsagePeriod, "Private Key Usage Period");
        ASN1OID.register(subjectAltName, "Subject Alternative Name");
        ASN1OID.register(issuerAltName, "Issuer Alternative Name");
        ASN1OID.register(basicConstraints, "Basic Constraints");
        ASN1OID.register(crlNumber, "CRL Number");
        ASN1OID.register(nameConstraints, "Name Constraints");
        ASN1OID.register(crlDistributionPoints, "CRL Distribution Points");
        ASN1OID.register(certificatePolicies, "Certificate Policies");
        ASN1OID.register(policyMappings, "Policy Mappings");
        ASN1OID.register(authorityKeyIdentifier, "Authority Key Identifier");
        ASN1OID.register(policyConstraints, "Policy Constraints");
        ASN1OID.register(extendedKeyUsage, "Extended Key Usage");
        ASN1OID.register(id_pe_authorityInfoAccess, "Authority Information Access");
        ASN1OID.register(netscapeCertType, "Netscape Cert Type");
        ASN1OID.register(netscapeComment, "Netscape Comment");
        ASN1OID.register(netscapeCertExt, "Netscape Certificate Extension");
        ASN1OID.register(id_kp_serverAuth, "TLS Web server authentication");
        ASN1OID.register(id_kp_clientAuth, "TLS Web client authentication");
        ASN1OID.register(id_kp_codeSigning, "Code signing");
        ASN1OID.register(id_kp_emailProtection, "E-mail protection");
        ASN1OID.register(id_kp_ipsecEndSystem, "IP security end system");
        ASN1OID.register(id_kp_ipsecTunnel, "IP security tunnel termination");
        ASN1OID.register(id_kp_ipsecUser, "IP security user");
        ASN1OID.register(id_kp_timeStamping, "Timestamping");
        ASN1OID.register(id_kp_OCSPSigning, "OCSP Signing");
        ASN1OID.register("1 3 6 1 4 1 311 20 2 2", "Smart Card Logon");
        ASN1OID.register(id_dsa, "id-dsa");
        ASN1OID.register(dhpublicnumber, "dhpublicnumber");
    }
}

