/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class JoiningTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private Class[] columnTypes;
    private ArrayList models = new ArrayList();
    private TableChangeHandler changeHandler = new TableChangeHandler();
    private int rowCount;
    public static final String TABLE_PREFIX_COLUMN = "TablePrefix";

    public synchronized void addTableModel(String string, TableModel tableModel) {
        this.models.add(new TablePosition(tableModel, string));
        tableModel.addTableModelListener(this.changeHandler);
        this.updateStructure();
    }

    public synchronized void removeTableModel(TableModel tableModel) {
        for (int i = 0; i < this.models.size(); ++i) {
            TablePosition tablePosition = (TablePosition)this.models.get(i);
            if (tablePosition.getTableModel() != tableModel) continue;
            this.models.remove(tableModel);
            tableModel.removeTableModelListener(this.changeHandler);
            this.updateStructure();
            return;
        }
    }

    public synchronized int getTableModelCount() {
        return this.models.size();
    }

    public synchronized TableModel getTableModel(int n) {
        TablePosition tablePosition = (TablePosition)this.models.get(n);
        return tablePosition.getTableModel();
    }

    protected synchronized void updateStructure() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        int n2 = 1;
        arrayList.add(TABLE_PREFIX_COLUMN);
        arrayList2.add(String.class);
        for (int i = 0; i < this.models.size(); ++i) {
            TablePosition tablePosition = (TablePosition)this.models.get(i);
            tablePosition.updateOffsets(n, n2);
            TableModel tableModel = tablePosition.getTableModel();
            n += tableModel.getRowCount();
            n2 += tableModel.getColumnCount();
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                arrayList.add(tablePosition.getPrefix() + "." + tableModel.getColumnName(j));
                arrayList2.add(tableModel.getColumnClass(j));
            }
        }
        this.columnNames = arrayList.toArray(new String[arrayList.size()]);
        this.columnTypes = arrayList2.toArray(new Class[arrayList2.size()]);
        this.rowCount = n;
        this.fireTableStructureChanged();
    }

    protected synchronized void updateRowCount() {
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < this.models.size(); ++i) {
            TablePosition tablePosition = (TablePosition)this.models.get(i);
            tablePosition.updateOffsets(n, n2);
            n += tablePosition.getTableModel().getRowCount();
            n2 += tablePosition.getTableModel().getColumnCount();
        }
        this.fireTableStructureChanged();
    }

    protected void updateData() {
        this.fireTableDataChanged();
    }

    public synchronized Class getColumnClass(int n) {
        return this.columnTypes[n];
    }

    @Override
    public synchronized String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public final boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public synchronized int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public synchronized int getRowCount() {
        return this.rowCount;
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        TablePosition tablePosition = this.getTableModelForRow(n);
        if (tablePosition == null) {
            return null;
        }
        if (n2 == 0) {
            return tablePosition.getPrefix();
        }
        int n3 = tablePosition.getColumnOffset();
        if (n2 < n3) {
            return null;
        }
        TableModel tableModel = tablePosition.getTableModel();
        if (n2 >= n3 + tableModel.getColumnCount()) {
            return null;
        }
        return tableModel.getValueAt(n - tablePosition.getTableOffset(), n2 - n3);
    }

    private TablePosition getTableModelForRow(int n) {
        for (int i = 0; i < this.models.size(); ++i) {
            TablePosition tablePosition = (TablePosition)this.models.get(i);
            int n2 = tablePosition.getTableOffset() + tablePosition.getTableModel().getRowCount();
            if (n >= n2) continue;
            return tablePosition;
        }
        return null;
    }

    private class TableChangeHandler
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == -1) {
                JoiningTableModel.this.updateStructure();
            } else if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1) {
                JoiningTableModel.this.updateRowCount();
            } else {
                JoiningTableModel.this.updateData();
            }
        }
    }

    private static class TablePosition {
        private TableModel tableModel;
        private String prefix;
        private int tableOffset;
        private int columnOffset;

        public TablePosition(TableModel tableModel, String string) {
            if (tableModel == null) {
                throw new NullPointerException("Model must not be null");
            }
            if (string == null) {
                throw new NullPointerException("Prefix must not be null.");
            }
            this.tableModel = tableModel;
            this.prefix = string;
        }

        public void updateOffsets(int n, int n2) {
            this.tableOffset = n;
            this.columnOffset = n2;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getColumnOffset() {
            return this.columnOffset;
        }

        public TableModel getTableModel() {
            return this.tableModel;
        }

        public int getTableOffset() {
            return this.tableOffset;
        }
    }
}

