%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm,quote,ragged-right]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  line-width = 160\mm - 2.0 * 10.16\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  ragged-right = ##t
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/changing-midi-output-to-one-channel-per-voice.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: a8a85e19654e46d725563e6deba44083ef137a2c
  texidocja = "
MIDI を出力する際、デフォルトの挙動では譜ごとに MIDI チャンネルが作られ、@c
譜の中にある全てのボイスは統合されます。これは、トラックごとに 16 しか@c
存在しない MIDI チャンネルが足りなくなる恐れを減らします。

しかしながら、次の例のように
@code{Staff_performer} を @code{Voice} コンテキストに移動する@c
ことで、ボイスごとに独自の MIDI チャンネルを持つようになります:
同じ譜にあるにもかかわらず、2 つの MIDI チャンネルが作られ、異なる
@code{midiInstrument} が割り当てられます。
"
  doctitleja = "MIDI チャンネルをボイスごとに割り当てる"

%% Translation of GIT committish: 2f3474d9af596d677ed5b7ce720ae4d0954a6b51
  texidocit = "
Nella creazione del file di output MIDI, il comportamento predefinito prevede
che ogni rigo sia assegnato a un canale MIDI, con tutte le voci del rigo
amalgamate in un canale. Ciò diminuisce il rischio di esaurire i canali
MIDI disponibili, dato che ce ne sono solo 16 per traccia.

Tuttavia, spostando @code{Staff_performer} nel contesto @code{Voice}, ogni
voce in un rigo può avere il proprio canale MIDI, come è illustrato
nell'esempio seguente: sebbene le voci siano sullo stesso rigo, vengono
creati due canali MIDI, ciascuno con un diverso strumento MIDI
(@code{midiInstrument}).

"
  doctitleit = "Impostare l'output MIDI su un canale per voce"


%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Lorsque LilyPond génère un fichier MIDI, chaque portée sera par défaut
affectée à un canal, quel que soit le nombre de voix qu'elle contient.
Ceci permet d'éviter de se retrouver à court de canaux, sachant qu'il
n'y en a que seize de disponibles par piste.

Le fait de déplacer le @code{Staff_performer} dans le contexte
@code{Voice} permet d'affecter à chaque voix d'une même portée un canal
MIDI spécifique.  Dans l'exemple suivant, la même portée donnera lieu à
deux canaux MIDI différents, chacun étant affecté de son propre
@code{midiInstrument}.
"

  doctitlefr = "Affectation d'un canal MIDI par voix"

%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidoces = "
Al producir una salida MIDI, el comportamiento predeterminado es que
cada pentagrama representa un canal MIDI, con todas las voces de dicho
pentagrama mezcladas.  Esto reduce al mínimo el riesgo de que se agote
el número de canales MIDI disponibles, pues existe un máximo de 16
canales por cada puerto MIDI, y la mayoría de los dispositivos sólo
tiene un puerto.

Sin embargo, cuando se traslada el interpretador
@code{Staff_performer} al contexto @code{Voice}, cada voz de un
pentagrama puede tener su propio canal MIDI, como se muestra en el
siguiente ejemplo: a pesar de estar sobre el mismo pentagrama, se
crean dos canales MIDI, cada uno con un @code{midiInstrument}
distinto.

"
  doctitlees = "Modificar la salida MIDI para que tenga un canal por cada voz"

%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidocca = "
En produir una sortida MIDI, el comportament predeterminat és que cada
pentagrama representa un canal MIDI, amb totes les veus d'aquest
pentagrama barrejades.  Això redueix al mínim el risc que s'esgoti el
nombre de canals MIDI disponibles, atès que hi ha un màxim de 16
canals per cada port MIDI, i la majoria dels dispositius sols tenen un
port.

No obstant, quan es trasllada l'interpretador @code{Staff_performer}
al context @code{Voice}, cada veu d'un pentagrama pot tenir el seu
propi canal MIDI, com es mostra a l'exemple següent: malgrat d'estar
sobre el mateix pentagrama, es creen dos canals MIDI, cadascú amb un
@code{midiInstrument} diferent.

"
  doctitleca = "Modificar la sortida MIDI perquè tingui un canal per a cada veu"


  lsrtags = "contexts-and-engravers, midi, real-music"

  texidoc = "
When outputting MIDI, the default behavior is for each staff to
represent one MIDI channel, with all the voices on a staff amalgamated.
This minimizes the risk of running out of MIDI channels, since there
are only 16 available per track.

However, by moving the @code{Staff_performer} to the @code{Voice}
context, each voice on a staff can have its own MIDI channel, as is
demonstrated by the following example: despite being on the same staff,
two MIDI channels are created, each with a different
@code{midiInstrument}.
"

  doctitle = "Changing MIDI output to one channel per voice"
} % begin verbatim


\score {
  \new Staff <<
    \new Voice \relative c''' {
      \set midiInstrument = #"flute"
      \voiceOne
      \key g \major
      \time 2/2
      r2 g-"Flute" ~
      g fis ~
      fis4 g8 fis e2 ~
      e4 d8 cis d2
    }
    \new Voice \relative c'' {
      \set midiInstrument = #"clarinet"
      \voiceTwo
      b1-"Clarinet"
      a2. b8 a
      g2. fis8 e
      fis2 r
    }
  >>
  \layout { }
  \midi {
    \context {
      \Staff
      \remove "Staff_performer"
    }
    \context {
      \Voice
      \consists "Staff_performer"
    }
    \tempo 2 = 72
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
