/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.ColumnConfig;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.PreparedStatementFactory;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomAwareReader;
import liquibase.statement.ExecutablePreparedStatement;
import liquibase.util.JdbcUtils;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import liquibase.util.file.FilenameUtils;

public abstract class ExecutablePreparedStatementBase
implements ExecutablePreparedStatement {
    private Logger log = LogFactory.getLogger();
    protected Database database;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns;
    private ChangeSet changeSet;
    private Set<Closeable> closeables;
    private ResourceAccessor resourceAccessor;

    protected ExecutablePreparedStatementBase(Database database, String catalogName, String schemaName, String tableName, List<ColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        this.database = database;
        this.changeSet = changeSet;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columns = columns;
        this.changeSet = changeSet;
        this.closeables = new HashSet<Closeable>();
        this.resourceAccessor = resourceAccessor;
    }

    @Override
    public void execute(PreparedStatementFactory factory) throws DatabaseException {
        ArrayList<ColumnConfig> cols = new ArrayList<ColumnConfig>(this.getColumns().size());
        String sql = this.generateSql(cols);
        this.log.info("Prepared statement: " + sql);
        this.log.debug("Number of columns = " + cols.size());
        PreparedStatement stmt = factory.create(sql);
        try {
            int i = 1;
            for (ColumnConfig col : cols) {
                this.log.debug("Applying column parameter = " + i + " for column " + col.getName());
                this.applyColumnParameter(stmt, i, col);
                ++i;
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            for (Closeable closeable : this.closeables) {
                StreamUtil.closeQuietly(closeable);
            }
            JdbcUtils.closeStatement(stmt);
        }
    }

    protected abstract String generateSql(List<ColumnConfig> var1);

    private void applyColumnParameter(PreparedStatement stmt, int i, ColumnConfig col) throws SQLException, DatabaseException {
        if (col.getValue() != null) {
            this.log.debug("value is string = " + col.getValue());
            stmt.setString(i, col.getValue());
        } else if (col.getValueBoolean() != null) {
            this.log.debug("value is boolean = " + col.getValueBoolean());
            stmt.setBoolean(i, col.getValueBoolean());
        } else if (col.getValueNumeric() != null) {
            this.log.debug("value is numeric = " + col.getValueNumeric());
            Number number = col.getValueNumeric();
            if (number instanceof ColumnConfig.ValueNumeric) {
                ColumnConfig.ValueNumeric valueNumeric = (ColumnConfig.ValueNumeric)number;
                number = valueNumeric.getDelegate();
            }
            if (number instanceof Long) {
                stmt.setLong(i, number.longValue());
            } else if (number instanceof Integer) {
                stmt.setInt(i, number.intValue());
            } else if (number instanceof Double) {
                stmt.setDouble(i, number.doubleValue());
            } else if (number instanceof Float) {
                stmt.setFloat(i, number.floatValue());
            } else if (number instanceof BigDecimal) {
                stmt.setBigDecimal(i, (BigDecimal)number);
            } else if (number instanceof BigInteger) {
                stmt.setInt(i, number.intValue());
            }
        } else if (col.getValueDate() != null) {
            this.log.debug("value is date = " + col.getValueDate());
            if (col.getValueDate() instanceof Timestamp) {
                stmt.setTimestamp(i, (Timestamp)col.getValueDate());
            } else {
                stmt.setDate(i, new Date(col.getValueDate().getTime()));
            }
        } else if (col.getValueBlobFile() != null) {
            this.log.debug("value is blob = " + col.getValueBlobFile());
            try {
                LOBContent<InputStream> lob = this.toBinaryStream(col.getValueBlobFile());
                if (((LOBContent)lob).length <= Integer.MAX_VALUE) {
                    stmt.setBinaryStream(i, (InputStream)((LOBContent)lob).content, (int)((LOBContent)lob).length);
                }
                stmt.setBinaryStream(i, (InputStream)((LOBContent)lob).content, ((LOBContent)lob).length);
            }
            catch (IOException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        } else if (col.getValueClobFile() != null) {
            try {
                this.log.debug("value is clob = " + col.getValueClobFile());
                LOBContent<Reader> lob = this.toCharacterStream(col.getValueClobFile(), col.getEncoding());
                if (((LOBContent)lob).length <= Integer.MAX_VALUE) {
                    stmt.setCharacterStream(i, (Reader)((LOBContent)lob).content, (int)((LOBContent)lob).length);
                }
                stmt.setCharacterStream(i, (Reader)((LOBContent)lob).content, ((LOBContent)lob).length);
            }
            catch (IOException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        } else {
            this.log.debug("value is explicit null");
            stmt.setNull(i, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LOBContent<InputStream> toBinaryStream(String valueLobFile) throws DatabaseException, IOException {
        InputStream in = this.getResourceAsStream(valueLobFile);
        if (in == null) {
            throw new DatabaseException("BLOB resource not found: " + valueLobFile);
        }
        try {
            if (in instanceof FileInputStream) {
                InputStream bufferedInput = this.createStream(in);
                LOBContent<InputStream> lOBContent = new LOBContent<InputStream>(bufferedInput, ((FileInputStream)in).getChannel().size());
                return lOBContent;
            }
            in = this.createStream(in);
            int IN_MEMORY_THRESHOLD = 100000;
            if (in.markSupported()) {
                in.mark(100000);
            }
            long length = StreamUtil.getContentLength(in);
            if (in.markSupported() && length <= 100000L) {
                in.reset();
            } else {
                StreamUtil.closeQuietly(in);
                in = this.getResourceAsStream(valueLobFile);
                in = this.createStream(in);
            }
            LOBContent<InputStream> lOBContent = new LOBContent<InputStream>(in, length);
            return lOBContent;
        }
        finally {
            if (in != null) {
                this.closeables.add(in);
            }
        }
    }

    private InputStream createStream(InputStream in) {
        return in instanceof BufferedInputStream ? in : new BufferedInputStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LOBContent<Reader> toCharacterStream(String valueLobFile, String encoding) throws IOException, DatabaseException {
        InputStream in = this.getResourceAsStream(valueLobFile);
        if (in == null) {
            throw new DatabaseException("CLOB resource not found: " + valueLobFile);
        }
        int IN_MEMORY_THRESHOLD = 100000;
        Reader reader = null;
        try {
            reader = this.createReader(in, encoding);
            if (reader.markSupported()) {
                reader.mark(100000);
            }
            long length = StreamUtil.getContentLength(reader);
            if (reader.markSupported() && length <= 100000L) {
                reader.reset();
            } else {
                StreamUtil.closeQuietly(reader);
                in = this.getResourceAsStream(valueLobFile);
                reader = this.createReader(in, encoding);
            }
            LOBContent<Reader> lOBContent = new LOBContent<Reader>(reader, length);
            return lOBContent;
        }
        finally {
            if (reader != null) {
                this.closeables.add(reader);
            }
            if (in != null) {
                this.closeables.add(in);
            }
        }
    }

    private Reader createReader(InputStream in, String encoding) throws UnsupportedEncodingException {
        return new BufferedReader(StringUtils.trimToNull(encoding) == null ? new UtfBomAwareReader(in) : new UtfBomAwareReader(in, encoding));
    }

    private InputStream getResourceAsStream(String valueLobFile) throws IOException {
        String fileName = this.getFileName(valueLobFile);
        Set<InputStream> streams = this.resourceAccessor.getResourcesAsStream(fileName);
        if (streams == null || streams.size() == 0) {
            return null;
        }
        if (streams.size() > 1) {
            for (InputStream stream : streams) {
                stream.close();
            }
            throw new IOException(streams.size() + " matched " + valueLobFile);
        }
        return streams.iterator().next();
    }

    private String getFileName(String fileName) {
        String relativeBaseFileName = this.changeSet.getChangeLog().getPhysicalFilePath();
        String tempFile = FilenameUtils.concat(FilenameUtils.getFullPath(relativeBaseFileName), fileName);
        fileName = tempFile != null ? tempFile : FilenameUtils.getFullPath(relativeBaseFileName) + fileName;
        return fileName;
    }

    public String getAbsolutePath(String path) {
        String p = path;
        File f = new File(p);
        if (!f.isAbsolute()) {
            String basePath = FilenameUtils.getFullPath(this.changeSet.getChangeLog().getPhysicalFilePath());
            p = FilenameUtils.normalize(basePath + p);
        }
        return p;
    }

    @Override
    public boolean skipOnUnsupported() {
        return false;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    private class LOBContent<T> {
        private final T content;
        private final long length;

        LOBContent(T content, long length) {
            this.content = content;
            this.length = length;
        }
    }
}

