/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.AsciiStream;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.CloseFilterInputStream;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LOBStateTracker;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.Utils;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class ClientResultSet
implements ResultSet,
ResultSetCallbackInterface {
    public ClientStatement statement_;
    ClientStatement outerStatement_;
    public ColumnMetaData resultSetMetaData_;
    private SqlWarning warnings_;
    public Cursor cursor_;
    private LOBStateTracker lobState = null;
    protected Agent agent_;
    public Section generatedSection_ = null;
    private CloseFilterInputStream currentStream;
    private Reader currentReader;
    private final ClientConnection connection_;
    public static final int scrollOrientation_relative__ = 1;
    public static final int scrollOrientation_absolute__ = 2;
    public static final int scrollOrientation_after__ = 3;
    public static final int scrollOrientation_before__ = 4;
    private static final int scrollOrientation_prior__ = 5;
    private static final int scrollOrientation_first__ = 6;
    private static final int scrollOrientation_last__ = 7;
    private static final int scrollOrientation_current__ = 8;
    private static final int scrollOrientation_next__ = 0;
    public static final int sensitivity_unknown__ = 0;
    public static final int sensitivity_insensitive__ = 1;
    public static final int sensitivity_sensitive_static__ = 2;
    public static final int sensitivity_sensitive_dynamic__ = 3;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;
    private static final byte DDM_RETURN_CALLER = 1;
    private static final byte DDM_RETURN_CLIENT = 2;
    private int wasNull_ = 0;
    private byte rsReturnability_ = (byte)2;
    boolean openOnClient_ = true;
    public boolean openOnServer_ = true;
    public Sqlca queryTerminatingSqlca_;
    boolean autoCommitted_ = false;
    private boolean isValidCursorPosition_ = false;
    private boolean savedIsValidCursorPosition_ = false;
    public boolean cursorHold_;
    public long queryInstanceIdentifier_ = 0L;
    public int resultSetType_;
    int resultSetConcurrency_;
    int resultSetHoldability_;
    public boolean scrollable_ = false;
    public int sensitivity_;
    public boolean isRowsetCursor_ = false;
    private boolean isBeforeFirst_ = true;
    private boolean isAfterLast_ = false;
    private boolean isFirst_ = false;
    private boolean isLast_ = false;
    public Sqlca[] rowsetSqlca_;
    protected int suggestedFetchSize_;
    public int fetchSize_;
    private int fetchDirection_;
    private long rowCount_ = -1L;
    private long absolutePosition_ = 0L;
    private long firstRowInRowset_ = 0L;
    private long lastRowInRowset_ = 0L;
    private long currentRowInRowset_ = -1L;
    private boolean isOnInsertRow_ = false;
    private boolean isOnCurrentRow_ = true;
    public int rowsReceivedInCurrentRowset_ = 0;
    public int rowsYetToBeReceivedForRowset_ = 0;
    private Object[] updatedColumns_;
    private boolean[] columnUpdated_;
    private ClientPreparedStatement preparedStatementForUpdate_;
    private ClientPreparedStatement preparedStatementForDelete_;
    private ClientPreparedStatement preparedStatementForInsert_;
    private boolean cursorUnpositionedOnServer_ = false;
    private long maxRows_;
    private boolean[] columnUsedFlags_;
    private boolean listenToUnitOfWork_ = false;

    protected ClientResultSet(Agent agent, ClientStatement statement, Cursor cursor, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.agent_ = agent;
        this.statement_ = statement;
        this.connection_ = this.statement_.connection_;
        this.cursor_ = cursor;
        if (this.cursor_ != null) {
            this.cursor_.maxFieldSize_ = this.statement_.maxFieldSize_;
        }
        this.resultSetType_ = resultSetType;
        this.resultSetConcurrency_ = resultSetConcurrency;
        this.resultSetHoldability_ = resultSetHoldability;
        this.fetchDirection_ = this.statement_.fetchDirection_;
        this.suggestedFetchSize_ = this.statement_.fetchSize_;
        this.maxRows_ = this.statement_.maxRows_;
        if (this.resultSetType_ < this.statement_.resultSetType_) {
            this.statement_.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J08"), this.statement_.resultSetType_, this.resultSetType_));
        }
        if (this.resultSetConcurrency_ < this.statement_.resultSetConcurrency_) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J06"), new Object[0]));
        }
        this.listenToUnitOfWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean next() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "next", new Object[0]);
                }
                boolean isValidCursorPosition = this.nextX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "next", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    boolean nextX() throws SqlException {
        this.checkForClosedResultSet("next");
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.unuseStreamsAndLOBs();
        if (this.resultSetType_ == 1003) {
            boolean bl = this.isValidCursorPosition_ = this.cursor_ == null ? false : this.cursor_.next();
            if (this.fetchSize_ != 0) {
                if (this.rowsYetToBeReceivedForRowset_ == 0) {
                    this.rowsYetToBeReceivedForRowset_ = this.fetchSize_;
                }
                if (this.isValidCursorPosition_) {
                    --this.rowsYetToBeReceivedForRowset_;
                }
            }
            if (!this.isValidCursorPosition_ && this.cursor_ != null || this.maxRows_ > 0L && this.cursor_.rowsRead_ > this.maxRows_) {
                this.isValidCursorPosition_ = false;
                SqlException sqlException = null;
                if (!this.openOnServer_) {
                    int sqlcode = Utils.getSqlcodeFromSqlca(this.queryTerminatingSqlca_);
                    if (sqlcode > 0 && sqlcode != 100) {
                        this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, this.queryTerminatingSqlca_));
                    } else if (sqlcode < 0) {
                        sqlException = new SqlException(this.agent_.logWriter_, this.queryTerminatingSqlca_);
                    }
                }
                try {
                    this.statement_.resultSetCommitting(this);
                }
                catch (SqlException sqle) {
                    sqlException = Utils.accumulateSQLException(sqle, sqlException);
                }
                if (sqlException != null) {
                    throw sqlException;
                }
            }
        } else {
            this.isAfterLast_ = false;
            this.isLast_ = false;
            if (this.rowIsInCurrentRowset(this.firstRowInRowset_ + this.currentRowInRowset_ + 1L, 0)) {
                this.isValidCursorPosition_ = true;
                ++this.currentRowInRowset_;
            } else {
                this.checkAndThrowReceivedQueryTerminatingException();
                this.isValidCursorPosition_ = this.getNextRowset();
            }
            if (this.isValidCursorPosition_) {
                this.updateColumnInfoFromCache();
                this.checkRowsetSqlca();
                if (this.isBeforeFirst_) {
                    this.isFirst_ = true;
                }
                this.isBeforeFirst_ = false;
            } else {
                this.isFirst_ = false;
                return this.isValidCursorPosition_;
            }
        }
        if (!this.openOnClient_) {
            this.isValidCursorPosition_ = false;
        } else if (this.sensitivity_ != 3 && this.maxRows_ > 0L && this.firstRowInRowset_ + this.currentRowInRowset_ > this.maxRows_) {
            this.isValidCursorPosition_ = false;
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "close", new Object[0]);
                }
                this.closeX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final void closeX() throws SqlException {
        if (!this.openOnClient_) {
            return;
        }
        this.closeOpenStreams();
        if (this.isValidCursorPosition_ && !this.isOnInsertRow_) {
            this.lobState.checkCurrentRow(this.cursor_);
        }
        this.preClose_();
        try {
            if (this.openOnServer_) {
                this.flowCloseAndAutoCommitIfNotAutoCommitted();
            } else {
                this.statement_.resultSetCommitting(this);
            }
        }
        finally {
            this.markClosed(true);
        }
        if (this.statement_.openOnClient_ && this.statement_.isCatalogQuery_) {
            this.statement_.closeX();
        }
        this.nullDataForGC();
    }

    private void closeStatementOnCompletion() {
        this.statement_.closeMeOnCompletion();
        if (this.outerStatement_ != null && this.outerStatement_ != this.statement_) {
            this.outerStatement_.closeMeOnCompletion();
        }
        this.outerStatement_ = null;
    }

    private void nullDataForGC() {
        if (this.cursor_ != null && !this.statement_.isPreparedStatement_) {
            this.cursor_.nullDataForGC();
        }
        this.cursor_ = null;
        this.resultSetMetaData_ = null;
    }

    private void flowCloseAndAutoCommitIfNotAutoCommitted() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        boolean performedAutoCommit = this.writeCloseAndAutoCommit();
        this.agent_.flow(this.statement_);
        this.readCloseAndAutoCommit(performedAutoCommit);
        this.agent_.endReadChain();
    }

    private boolean writeCloseAndAutoCommit() throws SqlException {
        this.autoCommitted_ = false;
        if (this.generatedSection_ == null) {
            this.writeCursorClose_(this.statement_.getSection());
        } else {
            this.writeCursorClose_(this.generatedSection_);
        }
        return this.statement_.resultSetCommitting(this, true);
    }

    private void readCloseAndAutoCommit(boolean readAutoCommit) throws SqlException {
        this.readCursorClose_();
        if (readAutoCommit) {
            this.readAutoCommitIfNotAutoCommitted();
        }
    }

    void writeClose() throws SqlException {
        this.autoCommitted_ = false;
        if (this.generatedSection_ == null) {
            this.writeCursorClose_(this.statement_.getSection());
        } else {
            this.writeCursorClose_(this.generatedSection_);
        }
    }

    void readClose() throws SqlException {
        try {
            if (this.generatedSection_ == null) {
                this.readCursorClose_();
            } else {
                this.readCursorClose_();
            }
        }
        finally {
            this.markClosed();
        }
    }

    private void readAutoCommitIfNotAutoCommitted() throws SqlException {
        if (this.connection_.autoCommit_ && !this.autoCommitted_) {
            this.connection_.readAutoCommit();
            this.markAutoCommitted();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "wasNull", new Object[0]);
            }
            this.checkForClosedResultSet("wasNull");
            if (this.wasNull_ == 0) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ088.S"), new Object[0]);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "wasNull", this.wasNull_ == 1);
            }
            return this.wasNull_ == 1;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public boolean getBoolean(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBoolean", column);
            }
            this.checkGetterPreconditions(column, "getBoolean");
            boolean result = false;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? false : this.agent_.crossConverters_.setBooleanFromObject(this.updatedColumns_[column - 1], this.resultSetMetaData_.types_[column - 1]);
            } else {
                boolean bl = result = this.isNull(column) ? false : this.cursor_.getBoolean(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBoolean", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public byte getByte(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getByte", column);
            }
            this.checkGetterPreconditions(column, "getByte");
            byte result = 0;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? (byte)0 : this.agent_.crossConverters_.setByteFromObject(this.updatedColumns_[column - 1], this.resultSetMetaData_.types_[column - 1]);
            } else {
                byte by = result = this.isNull(column) ? (byte)0 : this.cursor_.getByte(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getByte", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public short getShort(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getShort", column);
            }
            this.checkGetterPreconditions(column, "getShort");
            short result = 0;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? (short)0 : (Short)this.agent_.crossConverters_.setObject(5, this.updatedColumns_[column - 1]);
            } else {
                short s = result = this.isNull(column) ? (short)0 : this.cursor_.getShort(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getShort", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getInt(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getInt", column);
            }
            this.checkGetterPreconditions(column, "getInt");
            int result = 0;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 0 : (Integer)this.agent_.crossConverters_.setObject(4, this.updatedColumns_[column - 1]);
            } else {
                int n = result = this.isNull(column) ? 0 : this.cursor_.getInt(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getInt", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public long getLong(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getLong", column);
            }
            this.checkGetterPreconditions(column, "getLong");
            long result = 0L;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 0L : (Long)this.agent_.crossConverters_.setObject(-5, this.updatedColumns_[column - 1]);
            } else {
                long l = result = this.isNull(column) ? 0L : this.cursor_.getLong(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getLong", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public float getFloat(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getFloat", column);
            }
            this.checkGetterPreconditions(column, "getFloat");
            float result = 0.0f;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 0.0f : ((Float)this.agent_.crossConverters_.setObject(7, this.updatedColumns_[column - 1])).floatValue();
            } else {
                float f = result = this.isNull(column) ? 0.0f : this.cursor_.getFloat(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFloat", Float.valueOf(result));
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public double getDouble(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDouble", column);
            }
            this.checkGetterPreconditions(column, "getDouble");
            double result = 0.0;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 0.0 : (Double)this.agent_.crossConverters_.setObject(8, this.updatedColumns_[column - 1]);
            } else {
                double d = result = this.isNull(column) ? 0.0 : this.cursor_.getDouble(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDouble", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry(this, "getBigDecimal", column, scale);
            }
            this.checkGetterPreconditions(column, "getBigDecimal");
            BigDecimal result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = ((BigDecimal)this.agent_.crossConverters_.setObject(3, this.updatedColumns_[column - 1])).setScale(scale, 1);
            } else {
                BigDecimal bigDecimal = result = this.isNull(column) ? null : this.cursor_.getBigDecimal(column).setScale(scale, 1);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedExit(this, "getBigDecimal", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public BigDecimal getBigDecimal(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBigDecimal", column);
            }
            this.checkGetterPreconditions(column, "getBigDecimal");
            BigDecimal result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (BigDecimal)this.agent_.crossConverters_.setObject(3, this.updatedColumns_[column - 1]);
            } else {
                BigDecimal bigDecimal = result = this.isNull(column) ? null : this.cursor_.getBigDecimal(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Date getDate(int column, Calendar cal) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDate", column);
            }
            this.checkGetterPreconditions(column, "getDate");
            if (cal == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
            }
            Date result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (Date)this.agent_.crossConverters_.setObject(91, this.updatedColumns_[column - 1]);
                result = this.convertFromDefaultCalendar(result, cal);
            } else {
                Date date = result = this.isNull(column) ? null : this.cursor_.getDate(column, cal);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDate", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Date getDate(int column) throws SQLException {
        return this.getDate(column, Calendar.getInstance());
    }

    @Override
    public Time getTime(int column, Calendar cal) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTime", column, cal);
            }
            this.checkGetterPreconditions(column, "getTime");
            if (cal == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
            }
            Time result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (Time)this.agent_.crossConverters_.setObject(92, this.updatedColumns_[column - 1]);
                result = this.convertFromDefaultCalendar(result, cal);
            } else {
                Time time = result = this.isNull(column) ? null : this.cursor_.getTime(column, cal);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTime", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Time getTime(int column) throws SQLException {
        return this.getTime(column, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int column, Calendar calendar) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTimestamp", column, calendar);
            }
            this.checkGetterPreconditions(column, "getTimestamp");
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
            }
            Timestamp result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (Timestamp)this.agent_.crossConverters_.setObject(93, this.updatedColumns_[column - 1]);
                result = this.convertFromDefaultCalendar(result, calendar);
            } else if (!this.isNull(column)) {
                result = this.cursor_.getTimestamp(column, calendar);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Timestamp getTimestamp(int column) throws SQLException {
        return this.getTimestamp(column, Calendar.getInstance());
    }

    private static Calendar createCalendar(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private Date convertFromDefaultCalendar(Date date, Calendar cal) {
        Calendar from = ClientResultSet.createCalendar(date);
        cal.clear();
        cal.set(from.get(1), from.get(2), from.get(5));
        return new Date(cal.getTimeInMillis());
    }

    private Time convertFromDefaultCalendar(Time time, Calendar cal) {
        Calendar from = ClientResultSet.createCalendar(time);
        cal.clear();
        cal.set(1970, 0, 1, from.get(11), from.get(12), from.get(13));
        return new Time(cal.getTimeInMillis());
    }

    private Timestamp convertFromDefaultCalendar(Timestamp ts, Calendar cal) {
        Calendar from = ClientResultSet.createCalendar(ts);
        cal.clear();
        cal.set(from.get(1), from.get(2), from.get(5), from.get(11), from.get(12), from.get(13));
        Timestamp result = new Timestamp(cal.getTimeInMillis());
        result.setNanos(ts.getNanos());
        return result;
    }

    @Override
    public String getString(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getString", column);
            }
            this.checkGetterPreconditions(column, "getString");
            int type = this.resultSetMetaData_.types_[column - 1];
            if (type == 2004 || type == 2005) {
                this.checkLOBMultiCall(column);
            }
            String result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[column - 1]);
            } else {
                String string = result = this.isNull(column) ? null : this.cursor_.getString(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getString", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public byte[] getBytes(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBytes", column);
            }
            this.checkGetterPreconditions(column, "getBytes");
            int type = this.resultSetMetaData_.types_[column - 1];
            if (type == 2004) {
                this.checkLOBMultiCall(column);
            }
            byte[] result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (byte[])this.agent_.crossConverters_.setObject(-2, this.updatedColumns_[column - 1]);
            } else {
                byte[] byArray = result = this.isNull(column) ? null : this.cursor_.getBytes(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBytes", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public InputStream getBinaryStream(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBinaryStream", column);
            }
            this.checkGetterPreconditions(column, "getBinaryStream");
            this.useStreamOrLOB(column);
            InputStream result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = new ByteArrayInputStream((byte[])this.agent_.crossConverters_.setObject(-2, this.updatedColumns_[column - 1]));
            } else {
                InputStream inputStream = result = this.isNull(column) ? null : this.cursor_.getBinaryStream(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", result);
            }
            this.setWasNull(column);
            return this.createCloseFilterInputStream(result);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public InputStream getAsciiStream(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getAsciiStream", column);
            }
            this.checkGetterPreconditions(column, "getAsciiStream");
            this.useStreamOrLOB(column);
            InputStream result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = new AsciiStream((String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[column - 1]));
            } else {
                InputStream inputStream = result = this.isNull(column) ? null : this.cursor_.getAsciiStream(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getAsciiStream", result);
            }
            this.setWasNull(column);
            return this.createCloseFilterInputStream(result);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public InputStream getUnicodeStream(int column) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedEntry(this, "getUnicodeStream", column);
        }
        throw SQLExceptionFactory.notImplemented("getUnicodeStream");
    }

    @Override
    public Reader getCharacterStream(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCharacterStream", column);
            }
            this.checkGetterPreconditions(column, "getCharacterStream");
            this.useStreamOrLOB(column);
            Reader result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = new StringReader((String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[column - 1]));
            } else {
                Reader reader = result = this.isNull(column) ? null : this.cursor_.getCharacterStream(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", result);
            }
            this.setWasNull(column);
            this.currentReader = result;
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Blob getBlob(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBlob", column);
            }
            this.checkGetterPreconditions(column, "getBlob");
            this.useStreamOrLOB(column);
            Blob result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (Blob)this.agent_.crossConverters_.setObject(2004, this.updatedColumns_[column - 1]);
            } else {
                Blob blob = result = this.isNull(column) ? null : this.cursor_.getBlob(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBlob", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Clob getClob(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getClob", column);
            }
            this.checkGetterPreconditions(column, "getClob");
            this.useStreamOrLOB(column);
            Clob result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (Clob)this.agent_.crossConverters_.setObject(2005, this.updatedColumns_[column - 1]);
            } else {
                Clob clob = result = this.isNull(column) ? null : this.cursor_.getClob(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getClob", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Ref getRef(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getRef", column);
            }
            this.checkGetterPreconditions(column, "getRef");
            Ref result = this.isNull(column) ? null : this.cursor_.getRef(column);
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Array getArray(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getArray", column);
            }
            this.checkGetterPreconditions(column, "getArray");
            Array result = this.isNull(column) ? null : this.cursor_.getArray(column);
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Object getObject(int column) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", column);
            }
            Object result = this.getObjectX(column);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getObject", result);
            }
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    Object getObjectX(int column) throws SqlException {
        this.checkGetterPreconditions(column, "getObject");
        int type = this.resultSetMetaData_.types_[column - 1];
        if (type == 2004 || type == 2005) {
            this.useStreamOrLOB(column);
        }
        Object result = null;
        result = this.wasNonNullSensitiveUpdate(column) ? this.updatedColumns_[column - 1] : (this.isNull(column) ? null : this.cursor_.getObject(column));
        this.setWasNull(column);
        return result;
    }

    public Object getObject(int column, Map map) throws SQLException {
        try {
            this.closeOpenStreams();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", column, map);
            }
            this.checkGetterPreconditions(column, "getObject");
            Object result = null;
            result = this.wasNonNullSensitiveUpdate(column) ? this.updatedColumns_[column - 1] : (this.isNull(column) ? null : this.cursor_.getObject(column));
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean wasNonNullSensitiveUpdate(int column) {
        return this.updatedColumns_ != null && this.updatedColumns_[column - 1] != null;
    }

    private boolean wasNullSensitiveUpdate(int column) {
        return this.updatedColumns_ != null && this.updatedColumns_[column - 1] == null && this.columnUpdated_[column - 1];
    }

    private void setWasNull(int column) {
        this.wasNull_ = this.wasNullSensitiveUpdate(column) || this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 1 : (this.cursor_.isNull_ == null || this.cursor_.isNull_[column - 1] ? 1 : 2);
    }

    private boolean isNull(int column) {
        if (this.wasNullSensitiveUpdate(column)) {
            return true;
        }
        return this.cursor_.isUpdateDeleteHole_ || this.cursor_.isNull_[column - 1];
    }

    @Override
    public final boolean getBoolean(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBoolean", columnName);
            }
            return this.getBoolean(this.findColumnX(columnName, "getBoolean"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final byte getByte(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getByte", columnName);
            }
            return this.getByte(this.findColumnX(columnName, "getByte"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final short getShort(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getShort", columnName);
            }
            return this.getShort(this.findColumnX(columnName, "getShort"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final int getInt(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getInt", columnName);
            }
            return this.getInt(this.findColumnX(columnName, "getInt"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final long getLong(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getLong", columnName);
            }
            return this.getLong(this.findColumnX(columnName, "getLong"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final float getFloat(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getFloat", columnName);
            }
            return this.getFloat(this.findColumnX(columnName, "getFloat"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final double getDouble(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDouble", columnName);
            }
            return this.getDouble(this.findColumnX(columnName, "getDouble"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry(this, "getBigDecimal", columnName, scale);
            }
            return this.getBigDecimal(this.findColumnX(columnName, "getBigDecimal"), scale);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final BigDecimal getBigDecimal(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBigDecimal", columnName);
            }
            return this.getBigDecimal(this.findColumnX(columnName, "getBigDecimal"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Date getDate(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDate", columnName);
            }
            return this.getDate(this.findColumnX(columnName, "getDate"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Date getDate(String columnName, Calendar cal) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getDate", columnName, cal);
            }
            return this.getDate(this.findColumnX(columnName, "getDate"), cal);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Time getTime(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTime", columnName);
            }
            return this.getTime(this.findColumnX(columnName, "getTime"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Time getTime(String columnName, Calendar cal) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTime", columnName, cal);
            }
            return this.getTime(this.findColumnX(columnName, "getTime"), cal);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Timestamp getTimestamp(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTimestamp", columnName);
            }
            return this.getTimestamp(this.findColumnX(columnName, "getTimestamp"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTimestamp", columnName, cal);
            }
            return this.getTimestamp(this.findColumnX(columnName, "getTimestamp"), cal);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final String getString(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getString", columnName);
            }
            return this.getString(this.findColumnX(columnName, "getString"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final byte[] getBytes(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBytes", columnName);
            }
            return this.getBytes(this.findColumnX(columnName, "getBytes"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final InputStream getBinaryStream(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBinaryStream", columnName);
            }
            return this.getBinaryStream(this.findColumnX(columnName, "getBinaryStream"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final InputStream getAsciiStream(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getAsciiStream", columnName);
            }
            return this.getAsciiStream(this.findColumnX(columnName, "getAsciiStream"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final InputStream getUnicodeStream(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry(this, "getUnicodeStream", columnName);
            }
            return this.getUnicodeStream(this.findColumnX(columnName, "getUnicodeStream"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Reader getCharacterStream(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCharacterStream", columnName);
            }
            return this.getCharacterStream(this.findColumnX(columnName, "getCharacterStream"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Blob getBlob(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getBlob", columnName);
            }
            return this.getBlob(this.findColumnX(columnName, "getBlob"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Clob getClob(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getClob", columnName);
            }
            return this.getClob(this.findColumnX(columnName, "getClob"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Array getArray(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getArray", columnName);
            }
            return this.getArray(this.findColumnX(columnName, "getArray"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Ref getRef(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getRef", columnName);
            }
            return this.getRef(this.findColumnX(columnName, "getRef"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final Object getObject(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", columnName);
            }
            return this.getObject(this.findColumnX(columnName, "getObject"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Object getObject(String columnName, Map map) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", columnName, map);
            }
            return this.getObject(this.findColumnX(columnName, "getObject"), map);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        try {
            this.checkForClosedResultSet("getWarnings");
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearWarnings() throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings", new Object[0]);
            }
            try {
                this.checkForClosedResultSet("clearWarnings");
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
            this.clearWarningsX();
        }
    }

    private void clearWarningsX() {
        this.warnings_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCursorName", new Object[0]);
                }
                this.checkForClosedResultSet("getCursorName");
                if (this.generatedSection_ != null) {
                    return "stored procedure generated cursor:" + this.generatedSection_.getServerCursorName();
                }
                if (this.statement_.cursorName_ == null) {
                    this.statement_.cursorName_ = this.statement_.getSection().getServerCursorName();
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCursorName", this.statement_.cursorName_);
                }
                return this.statement_.cursorName_;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getMetaData", new Object[0]);
            }
            ColumnMetaData resultSetMetaData = this.getMetaDataX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getMetaData", (Object)resultSetMetaData);
            }
            return resultSetMetaData;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    ColumnMetaData getMetaDataX() throws SqlException {
        this.checkForClosedResultSet("getMetaData");
        return this.resultSetMetaData_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int findColumn(String columnName) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "findColumn", columnName);
                }
                int column = this.findColumnX(columnName, "findColumn");
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "findColumn", column);
                }
                return column;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    protected final int findColumnX(String columnName, String operation) throws SqlException {
        this.checkForClosedResultSet(operation);
        return this.resultSetMetaData_.findColumnX(columnName);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isBeforeFirst", new Object[0]);
            }
            this.checkForClosedResultSet("isBeforeFirst");
            this.checkThatResultSetTypeIsScrollable();
            boolean isBeforeFirst = this.isBeforeFirstX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isBeforeFirst", isBeforeFirst);
            }
            return isBeforeFirst;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean isBeforeFirstX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isBeforeFirst_;
        }
        return this.currentRowInRowset_ == -1L && !this.resultSetContainsNoRows();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isAfterLast", new Object[0]);
            }
            this.checkForClosedResultSet("isAfterLast");
            this.checkThatResultSetTypeIsScrollable();
            boolean isAfterLast = this.isAfterLastX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isAfterLast", isAfterLast);
            }
            return isAfterLast;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean isAfterLastX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isAfterLast_;
        }
        return this.resultSetContainsNoRows() ? false : this.firstRowInRowset_ == this.currentRowInRowset_ && this.currentRowInRowset_ == this.lastRowInRowset_ && this.lastRowInRowset_ == 0L && this.absolutePosition_ == (this.maxRows_ == 0L ? this.rowCount_ + 1L : this.maxRows_ + 1L);
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isFirst", new Object[0]);
            }
            this.checkForClosedResultSet("isFirst");
            this.checkThatResultSetTypeIsScrollable();
            boolean isFirst = this.isFirstX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isFirst", isFirst);
            }
            return isFirst;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean isFirstX() {
        if (this.sensitivity_ == 3) {
            return this.isFirst_;
        }
        return this.firstRowInRowset_ == 1L && this.currentRowInRowset_ == 0L;
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isLast", new Object[0]);
            }
            this.checkForClosedResultSet("isLast");
            this.checkThatResultSetTypeIsScrollable();
            boolean isLast = this.isLastX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isLast", isLast);
            }
            return isLast;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean isLastX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isLast_;
        }
        return this.resultSetContainsNoRows() ? false : this.firstRowInRowset_ + this.currentRowInRowset_ == this.rowCount_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "beforeFirst", new Object[0]);
                }
                this.checkForClosedResultSet("beforeFirst");
                this.checkThatResultSetTypeIsScrollable();
                this.clearWarningsX();
                this.beforeFirstX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void beforeFirstX() throws SqlException {
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        this.moveToCurrentRowX();
        if (this.sensitivity_ == 3 || !this.resultSetContainsNoRows() && !this.isServersCursorPositionBeforeFirst()) {
            this.moveToBeforeFirst();
        }
        this.isBeforeFirst_ = true;
        this.setRowsetBeforeFirstEvent();
        this.cursor_.resetDataBuffer();
        this.resetRowsetSqlca();
        this.isValidCursorPosition_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "afterLast", new Object[0]);
                }
                this.checkForClosedResultSet("afterLast");
                this.checkThatResultSetTypeIsScrollable();
                this.clearWarningsX();
                this.afterLastX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void afterLastX() throws SqlException {
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        this.moveToCurrentRowX();
        if (this.sensitivity_ == 3 || !this.resultSetContainsNoRows() && !this.isServerCursorPositionAfterLast()) {
            this.moveToAfterLast();
        }
        this.isAfterLast_ = true;
        this.setRowsetAfterLastEvent();
        this.cursor_.resetDataBuffer();
        this.resetRowsetSqlca();
        this.isValidCursorPosition_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "first", new Object[0]);
                }
                boolean isValidCursorPosition = this.firstX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "first", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean firstX() throws SqlException {
        this.checkForClosedResultSet("first");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        if (this.rowIsInCurrentRowset(1L, 6)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = 0L;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getFirstRowset();
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.isFirst_ = true;
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "last", new Object[0]);
                }
                boolean isValidCursorPosition = this.lastX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "last", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean lastX() throws SqlException {
        this.checkForClosedResultSet("last");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        long row = this.rowCount_;
        if (this.sensitivity_ != 3 && this.maxRows_ > 0L && this.rowCount_ > this.maxRows_) {
            row = this.maxRows_;
        }
        if (this.rowIsInCurrentRowset(row, 7)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = row - this.firstRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getLastRowset(row);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.isLast_ = true;
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getRow", new Object[0]);
                }
                int row = this.getRowX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getRow", row);
                }
                return row;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private int getRowX() throws SqlException {
        long row;
        this.checkForClosedResultSet("getRow");
        this.checkThatResultSetIsNotDynamic();
        if (this.resultSetType_ == 1003) {
            row = this.cursor_.allRowsReceivedFromServer() && this.cursor_.currentRowPositionIsEqualToNextRowPosition() ? 0L : this.cursor_.rowsRead_;
        } else {
            if (this.rowCountIsUnknown()) {
                this.getRowCount();
            }
            row = this.rowCount_ == 0L || this.currentRowInRowset_ < 0L ? 0L : this.firstRowInRowset_ + this.currentRowInRowset_;
        }
        if (row > Integer.MAX_VALUE) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J13"), row));
        }
        return (int)row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int row) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "absolute", row);
                }
                boolean isValidCursorPosition = this.absoluteX(row);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "absolute", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean absoluteX(int row) throws SqlException {
        this.checkForClosedResultSet("absolute");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        this.unuseStreamsAndLOBs();
        if (this.maxRows_ > 0L) {
            if (row > 0 && (long)row > this.maxRows_) {
                this.afterLastX();
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
            if (row <= 0 && (long)Math.abs(row) > this.maxRows_) {
                this.beforeFirstX();
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
        }
        int fetchAbsoluteRow = 0;
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        if (this.sensitivity_ == 3) {
            fetchAbsoluteRow = row;
        } else {
            int n = fetchAbsoluteRow = row >= 0 ? row : (int)(this.rowCount_ + (long)row + 1L);
        }
        if (this.rowIsInCurrentRowset(fetchAbsoluteRow, 2)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = (long)fetchAbsoluteRow - this.firstRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getAbsoluteRowset(fetchAbsoluteRow);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            if (row == 1) {
                this.isFirst_ = true;
            }
            if (row == -1) {
                this.isLast_ = true;
            }
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int rows) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "relative", rows);
                }
                boolean isValidCursorPosition = this.relativeX(rows);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "relative", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean relativeX(int rows) throws SqlException {
        this.checkForClosedResultSet("relative");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.unuseStreamsAndLOBs();
        if (this.resultSetContainsNoRows()) {
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (rows == 0) {
            this.isValidCursorPosition_ = this.resultSetConcurrency_ == 1008 && this.resultSetType_ == 1004 ? this.getAbsoluteRowset(this.absolutePosition_) : !this.isBeforeFirstX() && !this.isAfterLastX();
            return this.isValidCursorPosition_;
        }
        if (this.isBeforeFirstX()) {
            if (rows > 0) {
                this.nextX();
                return this.relativeX(rows - 1);
            }
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (this.isAfterLastX()) {
            if (rows < 0) {
                this.previousX();
                return this.relativeX(rows + 1);
            }
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        this.resetRowsetFlags();
        long currentAbsoluteRowNumber = this.firstRowInRowset_ + this.currentRowInRowset_;
        if (this.sensitivity_ != 3 && this.maxRows_ > 0L && rows > 0 && currentAbsoluteRowNumber + (long)rows > this.maxRows_) {
            this.afterLastX();
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (this.rowIsInCurrentRowset(currentAbsoluteRowNumber + (long)rows, 1)) {
            this.currentRowInRowset_ += (long)rows;
            this.isValidCursorPosition_ = true;
        } else {
            long rowNumber;
            this.checkAndThrowReceivedQueryTerminatingException();
            long l = rowNumber = this.sensitivity_ == 3 ? this.currentRowInRowset_ + (long)rows : currentAbsoluteRowNumber + (long)rows - this.absolutePosition_;
            if (this.maxRows_ < Math.abs(rowNumber) && this.maxRows_ != 0L) {
                if (rowNumber > 0L) {
                    this.afterLastX();
                } else {
                    this.beforeFirstX();
                }
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
            this.isValidCursorPosition_ = this.getRelativeRowset(rowNumber);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "previous", new Object[0]);
                }
                boolean isValidCursorPosition = this.previousX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "previous", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean previousX() throws SqlException {
        this.checkForClosedResultSet("previous");
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.unuseStreamsAndLOBs();
        this.isBeforeFirst_ = false;
        this.isFirst_ = false;
        if (this.rowIsInCurrentRowset(this.firstRowInRowset_ + this.currentRowInRowset_ - 1L, 5)) {
            this.isValidCursorPosition_ = true;
            --this.currentRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getPreviousRowset();
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.checkRowsetSqlca();
            if (this.isAfterLast_) {
                this.isLast_ = true;
            }
        } else {
            return this.isValidCursorPosition_;
        }
        this.isAfterLast_ = false;
        if (this.sensitivity_ != 3 && this.maxRows_ > 0L && this.firstRowInRowset_ + this.currentRowInRowset_ > this.maxRows_) {
            this.isValidCursorPosition_ = false;
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setFetchDirection", direction);
                }
                this.checkForClosedResultSet("setFetchDirection");
                this.checkThatResultSetTypeIsScrollable();
                switch (direction) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this.fetchDirection_ = direction;
                        break;
                    }
                    default: {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ064.S"), direction);
                    }
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.checkForClosedResultSet("getFetchDirection");
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchDirection", this.fetchDirection_);
            }
            return this.fetchDirection_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setFetchSize", rows);
                }
                this.checkForClosedResultSet("setFetchSize");
                if (rows < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ062.S"), rows).getSQLException();
                }
                this.setFetchSize_(rows);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchSize", this.fetchSize_);
            }
            this.checkForClosedResultSet("getFetchSize");
            return this.suggestedFetchSize_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getType", this.resultSetType_);
            }
            this.checkForClosedResultSet("getType");
            return this.resultSetType_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getConcurrency", this.resultSetConcurrency_);
            }
            this.checkForClosedResultSet("getConcurrency");
            return this.resultSetConcurrency_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            this.checkForClosedResultSet("rowUpdated");
            this.checkPositionedOnPlainRow();
            boolean rowUpdated = this.cursor_.getIsRowUpdated();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "rowUpdated", rowUpdated);
            }
            return rowUpdated;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            this.checkForClosedResultSet("rowInserted");
            this.checkPositionedOnPlainRow();
            boolean rowInserted = false;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "rowInserted", rowInserted);
            }
            return rowInserted;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            boolean rowDeleted;
            this.checkForClosedResultSet("rowDeleted");
            this.checkPositionedOnPlainRow();
            boolean bl = rowDeleted = this.resultSetType_ == 1004 ? this.cursor_.getIsUpdateDeleteHole() : false;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "rowDeleted", rowDeleted);
            }
            return rowDeleted;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNull(int column) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateNull", column);
                }
                this.checkUpdatePreconditions(column, "updateNull");
                if (!this.resultSetMetaData_.nullable_[column - 1]) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("23502"), column);
                }
                this.updateColumn(column, null);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(int column, boolean x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateBoolean", column, x);
                }
                this.checkUpdatePreconditions(column, "updateBoolean");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(int column, byte x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateByte", column, x);
                }
                this.checkUpdatePreconditions(column, "updateByte");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(int column, short x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateShort", column, x);
                }
                this.checkUpdatePreconditions(column, "updateShort");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(int column, int x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateInt", column, x);
                }
                this.checkUpdatePreconditions(column, "updateInt");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(int column, long x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateLong", column, x);
                }
                this.checkUpdatePreconditions(column, "updateLong");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(int column, float x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateFloat", column, Float.valueOf(x));
                }
                this.checkUpdatePreconditions(column, "updateFloat");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(int column, double x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateDouble", column, x);
                }
                this.checkUpdatePreconditions(column, "updateDouble");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(int column, BigDecimal x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateBigDecimal", column, x);
                }
                this.checkUpdatePreconditions(column, "updateBigDecimal");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(int column, Date x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateDate", column, x);
                }
                this.checkUpdatePreconditions(column, "updateDate");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(int column, Time x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateTime", column, x);
                }
                this.checkUpdatePreconditions(column, "updateTime");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(int column, Timestamp x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateTimestamp", column, x);
                }
                this.checkUpdatePreconditions(column, "updateTimestamp");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(int column, String x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateString", column, x);
                }
                this.checkUpdatePreconditions(column, "updateString");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(int column, byte[] x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateBytes", column, x);
                }
                this.checkUpdatePreconditions(column, "updateBytes");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int column, InputStream x, int length) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "", column, x, length);
                }
                this.checkUpdatePreconditions(column, "updateBinaryStream");
                this.updateColumn(column, this.agent_.crossConverters_.setObjectFromBinaryStream(this.resultSetMetaData_.types_[column - 1], x, length));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int column, InputStream x, int length) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateAsciiStream", column, x, length);
                }
                this.checkUpdatePreconditions(column, "updateAsciiStream");
                this.updateColumn(column, this.agent_.crossConverters_.setObjectFromCharacterStream(this.resultSetMetaData_.types_[column - 1], x, Cursor.ISO_8859_1, length));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int column, Reader x, int length) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateCharacterStream", column, x, length);
                }
                this.checkUpdatePreconditions(column, "updateCharacterStream");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x, length));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int column, Object x, int scale) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateObject", column, x, scale);
                }
                this.checkUpdatePreconditions(column, "updateObject");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int column, Object x) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateObject", column, x);
                }
                this.checkUpdatePreconditions(column, "updateObject");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateNull", columnName);
            }
            this.updateNull(this.findColumnX(columnName, "updateNull"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBoolean", columnName, x);
            }
            this.updateBoolean(this.findColumnX(columnName, "updateBoolean"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateByte", columnName, x);
            }
            this.updateByte(this.findColumnX(columnName, "updateByte"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateShort", columnName, x);
            }
            this.updateShort(this.findColumnX(columnName, "updateShort"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateInt", columnName, x);
            }
            this.updateInt(this.findColumnX(columnName, "updateInt"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateLong", columnName, x);
            }
            this.updateLong(this.findColumnX(columnName, "updateLong"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateFloat", columnName, Float.valueOf(x));
            }
            this.updateFloat(this.findColumnX(columnName, "updateFloat"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateDouble", columnName, x);
            }
            this.updateDouble(this.findColumnX(columnName, "updateDouble"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBigDecimal", columnName, x);
            }
            this.updateBigDecimal(this.findColumnX(columnName, "updateBigDecimal"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateDate", columnName, x);
            }
            this.updateDate(this.findColumnX(columnName, "updateDate"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateTime", columnName, x);
            }
            this.updateTime(this.findColumnX(columnName, "updateTime"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateTimestamp", columnName, x);
            }
            this.updateTimestamp(this.findColumnX(columnName, "updateTimestamp"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateString", columnName, x);
            }
            this.updateString(this.findColumnX(columnName, "updateString"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBytes", columnName, x);
            }
            this.updateBytes(this.findColumnX(columnName, "updateBytes"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBinaryStream", columnName, x, length);
            }
            this.updateBinaryStream(this.findColumnX(columnName, "updateBinaryStream"), x, length);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateAsciiStream", columnName, x, length);
            }
            this.updateAsciiStream(this.findColumnX(columnName, "updateAsciiStream"), x, length);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateCharacterStream", columnName, x, length);
            }
            this.updateCharacterStream(this.findColumnX(columnName, "updateCharacterStream"), x, length);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateObject", columnName, x, scale);
            }
            this.updateObject(this.findColumnX(columnName, "updateObject"), x, scale);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateObject", columnName, x);
            }
            this.updateObject(this.findColumnX(columnName, "updateObject"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateNClob(String columnName, Reader reader) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "insertRow", new Object[0]);
                }
                this.insertRowX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void insertRowX() throws SqlException {
        this.checkForClosedResultSet("insertRow");
        this.checkForUpdatableResultSet("insertRow");
        if (this.isOnCurrentRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ086.S"), new Object[0]);
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
        }
        this.getPreparedStatementForInsert();
        int paramNumber = 0;
        for (int i = 0; i < this.updatedColumns_.length; ++i) {
            if (this.resultSetMetaData_.sqlxUpdatable_[i] != 1 || !this.columnUpdated_[i]) continue;
            ++paramNumber;
            if (this.updatedColumns_[i] == null && (this.updatedColumns_[i] != null || !this.columnUpdated_[i])) continue;
            this.preparedStatementForInsert_.setInput(paramNumber, this.updatedColumns_[i]);
        }
        this.insert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateRow", new Object[0]);
                }
                if (this.updateRowX() && this.getType() == 1003) {
                    this.isValidCursorPosition_ = false;
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRowX() throws SqlException {
        this.checkForClosedResultSet("updateRow");
        this.checkForUpdatableResultSet("updateRow");
        if (this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"), new Object[0]);
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
        }
        if (this.updatedColumns_ == null) {
            return false;
        }
        boolean didAnyColumnGetUpdated = false;
        for (int i = 0; i < this.updatedColumns_.length; ++i) {
            if (!this.columnUpdated_[i]) continue;
            didAnyColumnGetUpdated = true;
            break;
        }
        if (!didAnyColumnGetUpdated) {
            return false;
        }
        this.getPreparedStatementForUpdate();
        int paramNumber = 0;
        for (int i = 0; i < this.updatedColumns_.length; ++i) {
            Object originalObj;
            if (this.resultSetMetaData_.sqlxUpdatable_[i] != 1 || !this.columnUpdated_[i]) continue;
            ++paramNumber;
            if (this.updatedColumns_[i] != null || this.updatedColumns_[i] == null && this.columnUpdated_[i]) {
                this.preparedStatementForUpdate_.setInput(paramNumber, this.updatedColumns_[i]);
                continue;
            }
            try {
                originalObj = this.getObject(i + 1);
            }
            catch (SQLException se) {
                throw new SqlException(se);
            }
            if (originalObj == null) {
                this.preparedStatementForUpdate_.setInput(paramNumber, null);
                continue;
            }
            this.preparedStatementForUpdate_.setInput(paramNumber, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[i], originalObj));
        }
        try {
            if (this.isRowsetCursor_ || this.sensitivity_ == 3 || this.sensitivity_ == 2) {
                this.update();
            } else {
                this.positionToCurrentRowAndUpdate();
            }
        }
        finally {
            this.resetUpdatedColumns();
        }
        if (this.resultSetType_ == 1004 && this.preparedStatementForUpdate_.updateCount_ > 0L) {
            this.getAbsoluteRowset(this.absolutePosition_);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "deleteRow", new Object[0]);
                }
                this.deleteRowX();
                this.isValidCursorPosition_ = false;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void deleteRowX() throws SqlException {
        this.checkForClosedResultSet("deleteRow");
        this.checkForUpdatableResultSet("deleteRow");
        this.resetUpdatedColumns();
        if (this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"), new Object[0]);
        }
        if (this.preparedStatementForDelete_ == null) {
            this.getPreparedStatementForDelete();
        }
        if (this.isRowsetCursor_ || this.sensitivity_ == 3 || this.sensitivity_ == 2) {
            this.delete();
        } else {
            this.positionToCurrentRowAndDelete();
        }
        if (this.resultSetType_ == 1003) {
            this.cursor_.isUpdateDeleteHole_ = true;
        } else if (this.preparedStatementForDelete_.updateCount_ > 0L) {
            this.cursor_.isUpdateDeleteHoleCache_.set((int)this.currentRowInRowset_, Cursor.ROW_IS_NULL);
            this.cursor_.isUpdateDeleteHole_ = this.cursor_.isUpdateDeleteHoleCache_.get((int)this.currentRowInRowset_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "refreshRow", new Object[0]);
                }
                this.refreshRowX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void refreshRowX() throws SqlException {
        this.checkForClosedResultSet("refreshRow");
        this.checkThatResultSetTypeIsScrollable();
        this.checkForUpdatableResultSet("refreshRow");
        if (this.isBeforeFirstX() || this.isAfterLastX() || this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"), new Object[0]);
        }
        if (this.resultSetType_ == 1005) {
            this.isValidCursorPosition_ = this.getRefreshRowset();
            try {
                this.cancelRowUpdates();
            }
            catch (SQLException sqle) {
                throw new SqlException(sqle);
            }
            this.unuseStreamsAndLOBs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "cancelRowUpdates", new Object[0]);
                }
                this.checkForClosedResultSet("cancelRowUpdates");
                this.checkForUpdatableResultSet("cancelRowUpdates");
                if (this.isOnInsertRow_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ086.S"), new Object[0]);
                }
                if (!this.isValidCursorPosition_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
                }
                this.resetUpdatedColumns();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "moveToInsertRow", new Object[0]);
                }
                this.checkForClosedResultSet("moveToInsertRow");
                this.checkForUpdatableResultSet("moveToInsertRow");
                this.resetUpdatedColumnsForInsert();
                this.isOnInsertRow_ = true;
                this.isOnCurrentRow_ = false;
                this.savedIsValidCursorPosition_ = this.isValidCursorPosition_;
                this.isValidCursorPosition_ = true;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "moveToCurrentRow", new Object[0]);
                }
                this.checkForClosedResultSet("moveToCurrentRow");
                this.checkForUpdatableResultSet("moveToCurrentRow");
                this.moveToCurrentRowX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void moveToCurrentRowX() throws SqlException {
        if (this.isOnInsertRow_) {
            this.resetUpdatedColumns();
            this.isOnInsertRow_ = false;
            this.isOnCurrentRow_ = true;
            if (this.currentRowInRowset_ > 0L) {
                this.updateColumnInfoFromCache();
            }
            this.isValidCursorPosition_ = this.savedIsValidCursorPosition_;
        }
        if (this.isValidCursorPosition_) {
            SanityManager.ASSERT((!this.isOnInsertRow_ ? 1 : 0) != 0, (String)"Cannot check current row if positioned on insert row");
            this.lobState.checkCurrentRow(this.cursor_);
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            this.checkForClosedResultSet("getStatement");
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getStatement", this.statement_);
        }
        if (this.statement_.getOwner() != null) {
            return this.statement_.getOwner();
        }
        return this.statement_;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBlob", columnIndex, x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateBlob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], x));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        try {
            this.updateBlob(this.findColumnX(columnName, "updateBlob"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBlob", columnIndex, x, (int)length);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateBlob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], new ClientBlob(this.agent_, x, (int)length)));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    @Override
    public void updateBlob(String columnName, InputStream x, long length) throws SQLException {
        try {
            this.updateBlob(this.findColumnX(columnName, "updateBlob"), x, length);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    boolean repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete() throws SqlException {
        boolean repositionedCursor = false;
        long rowToFetch = this.getRowUncast() - this.absolutePosition_;
        if (rowToFetch != 0L) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, 1, rowToFetch);
            this.absolutePosition_ += rowToFetch;
            repositionedCursor = true;
        }
        return repositionedCursor;
    }

    private void flowPositioningFetch(int scrollOrientation, int rowToFetch) throws DisconnectException {
        try {
            this.agent_.beginWriteChain(this.statement_);
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, scrollOrientation, rowToFetch);
            this.agent_.flow(this.statement_);
            this.readPositioningFetch_();
            this.agent_.endReadChain();
        }
        catch (SqlException e) {
            throw new DisconnectException(this.agent_, e);
        }
    }

    private void positionToCurrentRowAndUpdate() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        long currentRowPosRelativeToAbsoluteRowPos = this.getRowUncast() - this.absolutePosition_;
        if (this.resultSetType_ != 1003 && (currentRowPosRelativeToAbsoluteRowPos != 0L || currentRowPosRelativeToAbsoluteRowPos == 0L && this.cursorUnpositionedOnServer_)) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, 1, currentRowPosRelativeToAbsoluteRowPos);
        }
        try {
            this.writeUpdateRow(false);
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        this.agent_.flow(this.statement_);
        this.absolutePosition_ += currentRowPosRelativeToAbsoluteRowPos;
        if (this.resultSetType_ != 1003 && (currentRowPosRelativeToAbsoluteRowPos != 0L || currentRowPosRelativeToAbsoluteRowPos == 0L && this.cursorUnpositionedOnServer_)) {
            this.readPositioningFetch_();
            this.cursorUnpositionedOnServer_ = false;
            this.listenToUnitOfWork();
        }
        this.readUpdateRow();
        this.agent_.endReadChain();
    }

    private void insert() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        try {
            this.writeInsertRow(false);
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        this.agent_.flow(this.statement_);
        this.readInsertRow();
        this.agent_.endReadChain();
    }

    private void update() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        if (this.isRowsetCursor_) {
            try {
                this.preparedStatementForUpdate_.setInt(this.updatedColumns_.length + 1, (int)(this.currentRowInRowset_ + 1L));
            }
            catch (SQLException se) {
                throw new SqlException(se);
            }
        }
        boolean chainAutoCommit = this.connection_.willAutoCommitGenerateFlow();
        try {
            this.writeUpdateRow(chainAutoCommit);
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        if (chainAutoCommit) {
            this.connection_.writeCommit();
        }
        this.agent_.flow(this.statement_);
        this.readUpdateRow();
        if (chainAutoCommit) {
            this.connection_.readCommit();
        }
        this.agent_.endReadChain();
    }

    private void positionToCurrentRowAndDelete() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        long currentRowPosRelativeToAbsoluteRowPos = this.getRowUncast() - this.absolutePosition_;
        if (this.resultSetType_ != 1003 && (currentRowPosRelativeToAbsoluteRowPos != 0L || currentRowPosRelativeToAbsoluteRowPos == 0L && this.cursorUnpositionedOnServer_)) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, 1, currentRowPosRelativeToAbsoluteRowPos);
        }
        try {
            this.writeDeleteRow();
        }
        catch (SQLException sqle) {
            throw new SqlException(sqle);
        }
        this.agent_.flow(this.statement_);
        this.absolutePosition_ += currentRowPosRelativeToAbsoluteRowPos;
        if (this.resultSetType_ != 1003 && (currentRowPosRelativeToAbsoluteRowPos != 0L || currentRowPosRelativeToAbsoluteRowPos == 0L && this.cursorUnpositionedOnServer_)) {
            this.readPositioningFetch_();
            this.cursorUnpositionedOnServer_ = false;
            this.listenToUnitOfWork();
        }
        this.readDeleteRow();
        this.agent_.endReadChain();
    }

    private void delete() throws SqlException {
        try {
            this.agent_.beginWriteChain(this.statement_);
            if (this.isRowsetCursor_) {
                this.preparedStatementForDelete_.setInt(1, (int)(this.currentRowInRowset_ + 1L));
            }
            this.writeDeleteRow();
            if (this.connection_.autoCommit_) {
                this.connection_.writeAutoCommit();
            }
            this.agent_.flow(this.statement_);
            this.readDeleteRow();
            if (this.connection_.autoCommit_) {
                this.connection_.readAutoCommit();
            }
            this.agent_.endReadChain();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    private void setRowsetAfterLastEvent() throws SqlException {
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = this.maxRows_ == 0L ? this.rowCount_ + 1L : this.maxRows_ + 1L;
        this.currentRowInRowset_ = 0L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    private void setRowsetBeforeFirstEvent() throws SqlException {
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = 0L;
        this.currentRowInRowset_ = -1L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    private void setRowsetNoRowsEvent() {
        this.rowCount_ = 0L;
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = 0L;
        this.currentRowInRowset_ = -1L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    private boolean isServersCursorPositionBeforeFirst() throws SqlException {
        return this.isBeforeFirstX() && this.firstRowInRowset_ == 0L && this.lastRowInRowset_ == 0L && this.absolutePosition_ == 0L;
    }

    private boolean isServerCursorPositionAfterLast() {
        return this.absolutePosition_ == this.rowCount_ + 1L;
    }

    public void setValidCursorPosition(boolean isValidCursorPosition) {
        this.isValidCursorPosition_ = isValidCursorPosition;
    }

    private void moveToAfterLast() throws DisconnectException {
        this.flowPositioningFetch(3, 0);
    }

    private void moveToBeforeFirst() throws DisconnectException {
        this.flowPositioningFetch(4, 0);
    }

    private void writeInsertRow(boolean chainedWritesFollowingSetLob) throws SQLException {
        try {
            this.preparedStatementForInsert_.materialPreparedStatement_.writeExecute_(this.preparedStatementForInsert_.getSection(), this.preparedStatementForInsert_.parameterMetaData_, this.preparedStatementForInsert_.parameters_, this.preparedStatementForInsert_.parameterMetaData_ == null ? 0 : this.preparedStatementForInsert_.parameterMetaData_.getColumnCount(), false, chainedWritesFollowingSetLob);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void writeUpdateRow(boolean chainedWritesFollowingSetLob) throws SQLException {
        try {
            this.preparedStatementForUpdate_.materialPreparedStatement_.writeExecute_(this.preparedStatementForUpdate_.getSection(), this.preparedStatementForUpdate_.parameterMetaData_, this.preparedStatementForUpdate_.parameters_, this.preparedStatementForUpdate_.parameterMetaData_.getColumnCount(), false, chainedWritesFollowingSetLob);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void writeDeleteRow() throws SQLException {
        try {
            if (this.isRowsetCursor_) {
                this.preparedStatementForDelete_.materialPreparedStatement_.writeExecute_(this.preparedStatementForDelete_.getSection(), this.preparedStatementForDelete_.parameterMetaData_, this.preparedStatementForDelete_.parameters_, this.preparedStatementForDelete_.parameterMetaData_.getColumnCount(), false, false);
            } else {
                this.preparedStatementForDelete_.materialPreparedStatement_.writeExecute_(this.preparedStatementForDelete_.getSection(), null, null, 0, false, false);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void readInsertRow() throws DisconnectException, SqlException {
        this.preparedStatementForInsert_.materialPreparedStatement_.readExecute_();
    }

    private void readUpdateRow() throws DisconnectException, SqlException {
        this.preparedStatementForUpdate_.materialPreparedStatement_.readExecute_();
        this.accumulateWarning(this.preparedStatementForUpdate_.getSqlWarnings());
    }

    private void readDeleteRow() throws DisconnectException, SqlException {
        this.preparedStatementForDelete_.materialPreparedStatement_.readExecute_();
        this.accumulateWarning(this.preparedStatementForDelete_.getSqlWarnings());
    }

    @Override
    public void listenToUnitOfWork() {
        if (!this.listenToUnitOfWork_) {
            this.listenToUnitOfWork_ = true;
            this.connection_.CommitAndRollbackListeners_.put(this, null);
        }
    }

    @Override
    public void completeLocalCommit(Iterator listenerIterator) {
        this.cursorUnpositionedOnServer_ = true;
        this.lobState.discardState();
        this.markAutoCommitted();
        if (!this.cursorHold_) {
            this.markClosed();
            this.nullOutReferenceInStatement();
            listenerIterator.remove();
            this.listenToUnitOfWork_ = false;
        }
    }

    @Override
    public void completeLocalRollback(Iterator listenerIterator) {
        this.lobState.discardState();
        this.markAutoCommitted();
        this.markClosed();
        this.nullOutReferenceInStatement();
        listenerIterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    private void nullOutReferenceInStatement() {
        if (this.statement_.resultSet_ == this) {
            this.statement_.resultSet_ = null;
        }
        if (this.statement_.resultSetList_ != null) {
            for (int i = 0; i < this.statement_.resultSetList_.length; ++i) {
                if (this.statement_.resultSetList_[i] != this) continue;
                this.statement_.resultSetList_[i] = null;
            }
        }
    }

    void markClosed() {
        this.markClosed(false);
    }

    void markClosed(boolean removeListener) {
        this.openOnClient_ = false;
        this.openOnServer_ = false;
        this.statement_.resetCursorNameAndRemoveFromWhereCurrentOfMappings();
        this.statement_.removeClientCursorNameFromCache();
        this.markPositionedUpdateDeletePreparedStatementsClosed();
        if (removeListener) {
            this.connection_.CommitAndRollbackListeners_.remove(this);
        }
        this.closeStatementOnCompletion();
    }

    public void markClosedOnServer() {
        this.openOnServer_ = false;
    }

    void markAutoCommitted() {
        this.autoCommitted_ = true;
    }

    @Override
    public void earlyCloseComplete(Sqlca sqlca) {
        this.markClosedOnServer();
        this.queryTerminatingSqlca_ = sqlca;
        this.cursor_.setAllRowsReceivedFromServer(true);
    }

    @Override
    public int completeSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        int sqlcode = sqlca.getSqlCode();
        if (sqlcode == 100 || sqlcode == 20237) {
            this.cursor_.setAllRowsReceivedFromServer(true);
        } else if (sqlcode < 0) {
            this.connection_.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else if (sqlcode > 0) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
        }
        return sqlcode;
    }

    public void setRowCountEvent(long rowCount) throws DisconnectException {
        if (this.rowCount_ == -1L) {
            this.rowCount_ = rowCount;
        }
    }

    @Override
    public void accumulateWarning(SqlWarning e) {
        if (this.warnings_ == null) {
            this.warnings_ = e;
        } else {
            this.warnings_.setNextException(e);
        }
    }

    boolean rowCountIsUnknown() {
        if (this.sensitivity_ == 3) {
            return false;
        }
        return this.rowCount_ == -1L;
    }

    private void updateColumn(int column, Object value) {
        if (this.updatedColumns_ == null) {
            this.updatedColumns_ = new Object[this.resultSetMetaData_.columns_];
        }
        if (this.columnUpdated_ == null) {
            this.columnUpdated_ = new boolean[this.resultSetMetaData_.columns_];
        }
        this.updatedColumns_[column - 1] = value;
        this.columnUpdated_[column - 1] = true;
    }

    private String buildInsertString() throws SqlException {
        boolean foundOneUpdatedColumnAlready = false;
        StringBuffer insertSQL = new StringBuffer("INSERT INTO ");
        StringBuffer valuesSQL = new StringBuffer("VALUES (");
        insertSQL.append(this.getTableName());
        insertSQL.append(" (");
        for (int column = 1; column <= this.resultSetMetaData_.columns_; ++column) {
            if (foundOneUpdatedColumnAlready) {
                insertSQL.append(",");
                valuesSQL.append(",");
            }
            try {
                insertSQL.append(Utils.quoteSqlIdentifier(this.resultSetMetaData_.getColumnName(column)));
            }
            catch (SQLException sqle) {
                throw new SqlException(sqle);
            }
            if (this.columnUpdated_[column - 1]) {
                valuesSQL.append("?");
            } else {
                valuesSQL.append("DEFAULT");
            }
            foundOneUpdatedColumnAlready = true;
        }
        insertSQL.append(") ");
        valuesSQL.append(") ");
        insertSQL.append(valuesSQL.toString());
        return insertSQL.toString();
    }

    private String buildUpdateString() throws SqlException {
        int numColumns = 0;
        boolean foundOneUpdatedColumnAlready = false;
        StringBuffer updateString = new StringBuffer(64);
        updateString.append("UPDATE ").append(this.getTableName()).append(" SET ");
        for (int column = 1; column <= this.resultSetMetaData_.columns_; ++column) {
            if (!this.columnUpdated_[column - 1]) continue;
            if (foundOneUpdatedColumnAlready) {
                updateString.append(",");
            }
            try {
                updateString.append(Utils.quoteSqlIdentifier(this.resultSetMetaData_.getColumnName(column))).append(" = ? ");
            }
            catch (SQLException sqle) {
                throw new SqlException(sqle);
            }
            ++numColumns;
            foundOneUpdatedColumnAlready = true;
        }
        if (!foundOneUpdatedColumnAlready) {
            return null;
        }
        updateString.append(" WHERE CURRENT OF ").append(this.getServerCursorName());
        if (this.isRowsetCursor_) {
            updateString.append(" FOR ROW ? OF ROWSET");
        }
        return updateString.toString();
    }

    private String buildDeleteString() throws SqlException {
        Object deleteString = "DELETE FROM ";
        deleteString = (String)deleteString + this.getTableName() + " WHERE CURRENT OF \"" + this.getServerCursorName() + "\"";
        if (this.isRowsetCursor_) {
            deleteString = (String)deleteString + " FOR ROW ? OF ROWSET";
        }
        return deleteString;
    }

    private String getTableName() throws SqlException {
        int baseTableColumn;
        int totalColumns;
        Object tableName = "";
        try {
            totalColumns = this.resultSetMetaData_.getColumnCount();
        }
        catch (SQLException sqle) {
            throw new SqlException(sqle);
        }
        for (baseTableColumn = 0; baseTableColumn < totalColumns && this.resultSetMetaData_.sqlxBasename_[baseTableColumn] == null; ++baseTableColumn) {
        }
        if (baseTableColumn == totalColumns) {
            baseTableColumn = 0;
        }
        if (this.resultSetMetaData_.sqlxSchema_[baseTableColumn] != null && !this.resultSetMetaData_.sqlxSchema_[baseTableColumn].equals("")) {
            tableName = (String)tableName + Utils.quoteSqlIdentifier(this.resultSetMetaData_.sqlxSchema_[baseTableColumn]) + ".";
        }
        if (this.resultSetMetaData_.sqlxBasename_[baseTableColumn] != null) {
            tableName = (String)tableName + Utils.quoteSqlIdentifier(this.resultSetMetaData_.sqlxBasename_[baseTableColumn]);
        }
        return tableName;
    }

    private String getServerCursorName() throws SqlException {
        return this.statement_.getSection().getServerCursorName();
    }

    private void getPreparedStatementForInsert() throws SqlException {
        String insertString = this.buildInsertString();
        try {
            this.preparedStatementForInsert_ = (ClientPreparedStatement)this.statement_.connection_.prepareStatement(insertString);
        }
        catch (SQLException sqle) {
            throw new SqlException(sqle);
        }
    }

    private void getPreparedStatementForUpdate() throws SqlException {
        String updateString = this.buildUpdateString();
        if (updateString == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ122.S"), new Object[0]);
        }
        this.preparedStatementForUpdate_ = this.statement_.connection_.preparePositionedUpdateStatement(updateString, this.statement_.getSection().getPositionedUpdateSection());
    }

    private void getPreparedStatementForDelete() throws SqlException {
        String deleteString = this.buildDeleteString();
        this.preparedStatementForDelete_ = this.statement_.connection_.preparePositionedUpdateStatement(deleteString, this.statement_.getSection().getPositionedUpdateSection());
    }

    private final void resetUpdatedColumnsForInsert() {
        for (int i = 0; i < this.resultSetMetaData_.columns_; ++i) {
            this.updateColumn(i + 1, null);
            this.columnUpdated_[i] = false;
        }
    }

    private final void resetUpdatedColumns() {
        if (this.updatedColumns_ != null) {
            Arrays.fill(this.updatedColumns_, null);
        }
        if (this.columnUpdated_ != null) {
            Arrays.fill(this.columnUpdated_, false);
        }
    }

    private final long getRowUncast() {
        return this.firstRowInRowset_ + this.currentRowInRowset_;
    }

    private final void checkGetterPreconditions(int column, String operation) throws SqlException {
        this.checkForClosedResultSet(operation);
        this.checkForValidColumnIndex(column);
        this.checkForValidCursorPosition();
    }

    private final void checkUpdatePreconditions(int column, String operation) throws SqlException {
        this.checkForClosedResultSet(operation);
        this.checkForValidColumnIndex(column);
        this.checkForUpdatableResultSet(operation);
        if (!this.isOnCurrentRow_ && !this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ123.S"), new Object[0]);
        }
        if (this.resultSetMetaData_.sqlxUpdatable_ == null || this.resultSetMetaData_.sqlxUpdatable_[column - 1] != 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ124.S"), new Object[0]);
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
        }
    }

    private void checkForValidColumnIndex(int column) throws SqlException {
        if (column < 1 || column > this.resultSetMetaData_.columns_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL14.S"), column, this.resultSetMetaData_.columns_);
        }
    }

    protected final void checkForClosedResultSet(String operation) throws SqlException {
        if (!this.openOnClient_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL16.S"), operation);
        }
        this.agent_.checkForDeferredExceptions();
    }

    private final void checkForUpdatableResultSet(String operation) throws SqlException {
        if (this.resultSetConcurrency_ == 1007) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ083.U"), operation);
        }
    }

    private final void checkForValidCursorPosition() throws SqlException {
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"), new Object[0]);
        }
    }

    private final void checkPositionedOnPlainRow() throws SqlException {
        if (this.isOnInsertRow_ || !this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"), new Object[0]);
        }
    }

    private final void checkThatResultSetTypeIsScrollable() throws SqlException {
        if (this.resultSetType_ == 1003) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ125.S"), new Object[0]);
        }
    }

    private final void checkThatResultSetIsNotDynamic() throws SqlException {
        if (this.sensitivity_ == 3) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ126.S"), new Object[0]);
        }
    }

    private boolean resultSetContainsNoRows() throws SqlException {
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        return this.rowCount_ == 0L;
    }

    private boolean rowIsInCurrentRowset(long rowNumber, int orientation) throws SqlException {
        if (this.sensitivity_ == 3) {
            switch (orientation) {
                case 0: {
                    if (this.isAfterLast_) {
                        return false;
                    }
                    return this.currentRowInRowset_ + 1L < (long)this.rowsReceivedInCurrentRowset_;
                }
                case 5: {
                    if (this.isBeforeFirst_) {
                        return false;
                    }
                    return this.currentRowInRowset_ - 1L >= 0L;
                }
                case 1: {
                    return rowNumber < (long)this.rowsReceivedInCurrentRowset_ && rowNumber >= 0L;
                }
                case 2: 
                case 6: 
                case 7: {
                    return false;
                }
            }
            return false;
        }
        if (this.resultSetMetaData_.hasLobColumns()) {
            return false;
        }
        return this.rowIsInCurrentRowset(rowNumber);
    }

    private boolean rowIsInCurrentRowset(long rowNumber) {
        if (this.firstRowInRowset_ == this.lastRowInRowset_ && this.firstRowInRowset_ == 0L) {
            return false;
        }
        return rowNumber >= this.firstRowInRowset_ && rowNumber <= this.lastRowInRowset_;
    }

    private void markPositionedUpdateDeletePreparedStatementsClosed() {
        if (this.preparedStatementForUpdate_ != null) {
            this.preparedStatementForUpdate_.markClosed();
            this.preparedStatementForUpdate_ = null;
        }
        if (this.preparedStatementForDelete_ != null) {
            this.preparedStatementForDelete_.markClosed();
            this.preparedStatementForDelete_ = null;
        }
    }

    private void updateColumnInfoFromCache() {
        this.cursor_.columnDataPosition_ = this.cursor_.columnDataPositionCache_.get((int)this.currentRowInRowset_);
        this.cursor_.columnDataComputedLength_ = this.cursor_.columnDataLengthCache_.get((int)this.currentRowInRowset_);
        this.cursor_.isNull_ = this.cursor_.columnDataIsNullCache_.get((int)this.currentRowInRowset_);
        this.cursor_.isUpdateDeleteHole_ = this.cursor_.isUpdateDeleteHoleCache_.get((int)this.currentRowInRowset_);
    }

    protected final void checkAndThrowReceivedQueryTerminatingException() throws SqlException {
        if (!this.openOnServer_) {
            SqlException sqlException = null;
            int sqlcode = Utils.getSqlcodeFromSqlca(this.queryTerminatingSqlca_);
            if (sqlcode < 0) {
                sqlException = new SqlException(this.agent_.logWriter_, this.queryTerminatingSqlca_);
            } else if (sqlcode > 0 && sqlcode != 100) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, this.queryTerminatingSqlca_));
            }
            try {
                this.closeX();
            }
            catch (SqlException e) {
                sqlException.setNextException(e);
            }
            if (sqlException != null) {
                throw sqlException;
            }
        }
    }

    void parseScrollableRowset() throws SqlException {
        if (this.cursor_.dataBufferHasUnprocessedData() && this.scrollable_) {
            this.parseRowset_();
            this.adjustFirstRowset();
            if (this.cursor_.allRowsReceivedFromServer() && this.rowsReceivedInCurrentRowset_ == 0) {
                this.setRowsetNoRowsEvent();
            }
        }
    }

    public byte getRSReturnability() {
        return this.rsReturnability_;
    }

    public void setRSReturnability(byte rsReturnability) {
        this.rsReturnability_ = rsReturnability == 1 || rsReturnability == 2 ? rsReturnability : (byte)1;
    }

    protected void getRowCount() throws SqlException {
        this.checkAndThrowReceivedQueryTerminatingException();
        this.agent_.beginWriteChain(this.statement_);
        Section section = this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_;
        this.writePositioningFetch_(section, 3, 0L);
        if (this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L) {
            this.writePositioningFetch_(section, 2, this.firstRowInRowset_);
        }
        this.agent_.flow(this.statement_);
        this.readPositioningFetch_();
        if (this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L) {
            this.readPositioningFetch_();
        }
        this.agent_.endReadChain();
        if (this.rowCount_ == -1L) {
            this.checkAndThrowReceivedQueryTerminatingException();
        }
        this.absolutePosition_ = this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L ? this.firstRowInRowset_ : (this.maxRows_ == 0L ? this.rowCount_ + 1L : this.maxRows_ + 1L);
    }

    private void flowGetRowset(int orientation, long rowNumber) throws SqlException {
        this.cursor_.clearLobData_();
        this.cursor_.resetDataBuffer();
        this.agent_.beginWriteChain(this.statement_);
        this.writeScrollableFetch_(this.generatedSection_ == null ? this.statement_.getSection() : this.generatedSection_, this.fetchSize_, orientation, rowNumber, true);
        this.rowsReceivedInCurrentRowset_ = 0;
        this.agent_.flow(this.statement_);
        this.readScrollableFetch_();
        this.agent_.endReadChain();
    }

    private boolean getNextRowset() throws SqlException {
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            int sqlcode = this.checkRowsetSqlca((int)this.currentRowInRowset_ + 2);
            if (sqlcode == 100) {
                this.isAfterLast_ = true;
                return false;
            }
            this.flowGetRowset(0, 0L);
        } else {
            if (this.resultSetContainsNoRows() || this.isAfterLastX()) {
                return false;
            }
            if (this.firstRowInRowset_ + this.currentRowInRowset_ == this.lastRowInRowset_ && this.cursor_.allRowsReceivedFromServer()) {
                this.isAfterLast_ = true;
                this.setRowsetAfterLastEvent();
                return false;
            }
            long rowNumber = 1L;
            int orientation = 1;
            if (this.absolutePosition_ < this.lastRowInRowset_) {
                rowNumber = this.lastRowInRowset_ - this.absolutePosition_ + 1L;
                this.absolutePosition_ = this.lastRowInRowset_;
            } else if (this.absolutePosition_ > this.lastRowInRowset_) {
                rowNumber = this.lastRowInRowset_ + 1L;
                orientation = 2;
            }
            this.flowGetRowset(orientation, rowNumber);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.isAfterLast_ = true;
            this.setRowsetAfterLastEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustNextRowset();
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustNextRowset() {
        this.firstRowInRowset_ = this.lastRowInRowset_ + 1L;
        this.lastRowInRowset_ += (long)this.rowsReceivedInCurrentRowset_;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getPreviousRowset() throws SqlException {
        int orientation = 1;
        long rowNumber = 0L;
        boolean isAfterLast = false;
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            if (this.currentRowInRowset_ == 0L && this.rowsetSqlca_ != null && this.rowsetSqlca_[0] != null && this.rowsetSqlca_[0].getSqlCode() == 20237) {
                this.isBeforeFirst_ = true;
                this.setRowsetBeforeFirstEvent();
                return false;
            }
            this.flowGetRowset(5, 0L);
        } else {
            if (this.resultSetContainsNoRows() || this.isBeforeFirstX()) {
                return false;
            }
            rowNumber = this.firstRowInRowset_ - this.absolutePosition_ - (long)this.fetchSize_;
            isAfterLast = this.isAfterLastX();
            if (this.isFirstX()) {
                rowNumber = 0L;
                orientation = 2;
            } else if (isAfterLast) {
                rowNumber = -1 * this.fetchSize_;
            }
            if (rowNumber * -1L >= this.absolutePosition_) {
                rowNumber = 1L;
                orientation = 2;
            }
            if (this.maxRows_ > 0L && orientation == 1 && isAfterLast) {
                rowNumber += this.maxRows_ + 1L;
                orientation = 2;
            }
            this.flowGetRowset(orientation, rowNumber);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.isBeforeFirst_ = true;
            this.setRowsetBeforeFirstEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustPreviousRowset(orientation, rowNumber, isAfterLast);
        } else {
            this.currentRowInRowset_ = this.rowsReceivedInCurrentRowset_ - 1;
        }
        return true;
    }

    private void adjustPreviousRowset(int orientation, long rowNumber, boolean isAfterLastRow) {
        if (orientation == 2 && rowNumber == 1L) {
            this.currentRowInRowset_ = isAfterLastRow ? this.absolutePosition_ - 2L : this.firstRowInRowset_ - 2L;
            this.firstRowInRowset_ = 1L;
            this.lastRowInRowset_ = this.rowsReceivedInCurrentRowset_;
            this.absolutePosition_ = isAfterLastRow ? this.lastRowInRowset_ + 1L : this.lastRowInRowset_;
        } else {
            this.lastRowInRowset_ = this.maxRows_ == 0L ? (isAfterLastRow ? this.rowCount_ : this.firstRowInRowset_ - 1L) : (isAfterLastRow ? this.maxRows_ : this.firstRowInRowset_ - 1L);
            this.firstRowInRowset_ = this.lastRowInRowset_ - (long)this.rowsReceivedInCurrentRowset_ + 1L;
            this.absolutePosition_ = this.lastRowInRowset_;
            this.currentRowInRowset_ = this.lastRowInRowset_ - this.firstRowInRowset_;
        }
    }

    private boolean getAbsoluteRowset(long row) throws SqlException {
        int orientation = 2;
        if (this.isRowsetCursor_ && row == 0L) {
            orientation = 4;
        } else if (this.sensitivity_ != 3 && row < 0L) {
            row = 0L;
        }
        this.flowGetRowset(orientation, row);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer() || orientation == 4) {
            if (row > 0L) {
                this.setRowsetAfterLastEvent();
                this.isAfterLast_ = true;
            } else {
                this.setRowsetBeforeFirstEvent();
                this.isBeforeFirst_ = true;
            }
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustAbsoluteRowset(row);
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustAbsoluteRowset(long rowNumber) {
        this.firstRowInRowset_ = rowNumber;
        this.lastRowInRowset_ = this.firstRowInRowset_ + (long)this.rowsReceivedInCurrentRowset_ - 1L;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getRelativeRowset(long rows) throws SqlException {
        if (rows == 0L && (this.cursor_.allRowsReceivedFromServer() || this.absolutePosition_ > this.rowCount_)) {
            this.setRowsetAfterLastEvent();
            this.isAfterLast_ = true;
            return false;
        }
        this.flowGetRowset(1, rows);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            if (rows > 0L) {
                this.setRowsetAfterLastEvent();
                this.isAfterLast_ = true;
            } else {
                this.setRowsetBeforeFirstEvent();
                this.isBeforeFirst_ = true;
            }
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustRelativeRowset(rows);
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustRelativeRowset(long rowNumber) {
        this.firstRowInRowset_ = this.absolutePosition_ + rowNumber;
        this.lastRowInRowset_ = this.firstRowInRowset_ + (long)this.rowsReceivedInCurrentRowset_ - 1L;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getFirstRowset() throws SqlException {
        this.flowGetRowset(2, 1L);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.resetRowsetFlags();
            this.setRowsetNoRowsEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustFirstRowset();
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustFirstRowset() {
        this.firstRowInRowset_ = 1L;
        this.lastRowInRowset_ = this.rowsReceivedInCurrentRowset_;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getLastRowset(long row) throws SqlException {
        if (this.sensitivity_ != 3 && this.rowCount_ == 0L) {
            this.isAfterLast_ = false;
            this.isBeforeFirst_ = false;
            this.setRowsetNoRowsEvent();
            return false;
        }
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            this.flowGetRowset(7, 0L);
        } else {
            long rowNumber = this.maxRows_ == 0L ? ((long)this.fetchSize_ < row ? (long)(-1 * this.fetchSize_) : 1L) : ((long)this.fetchSize_ < row ? this.maxRows_ - (long)this.fetchSize_ + 1L : 1L);
            this.flowGetRowset(2, rowNumber);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.isAfterLast_ = true;
            this.setRowsetAfterLastEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustLastRowset(row);
        } else {
            this.currentRowInRowset_ = this.rowsReceivedInCurrentRowset_ - 1;
        }
        return true;
    }

    private void adjustLastRowset(long row) {
        this.lastRowInRowset_ = row;
        this.firstRowInRowset_ = this.lastRowInRowset_ - (long)this.rowsReceivedInCurrentRowset_ + 1L;
        if (this.firstRowInRowset_ <= 0L) {
            this.firstRowInRowset_ = 1L;
        }
        this.setAbsolutePositionBasedOnAllRowsReceived();
        this.currentRowInRowset_ = this.lastRowInRowset_ - this.firstRowInRowset_;
    }

    private boolean getRefreshRowset() throws SqlException {
        if (this.isRowsetCursor_) {
            this.flowGetRowset(8, 0L);
        } else {
            this.flowGetRowset(1, -1L * (this.absolutePosition_ - this.firstRowInRowset_));
        }
        this.parseRowset_();
        if (this.sensitivity_ != 3) {
            this.adjustRefreshRowset();
        }
        return true;
    }

    private void adjustRefreshRowset() {
        this.setAbsolutePositionBasedOnAllRowsReceived();
        this.updateColumnInfoFromCache();
    }

    private void setAbsolutePositionBasedOnAllRowsReceived() {
        this.absolutePosition_ = this.cursor_.allRowsReceivedFromServer() ? this.lastRowInRowset_ + 1L : this.lastRowInRowset_;
    }

    public abstract void writeFetch_(Section var1) throws SqlException;

    public abstract void readFetch_() throws SqlException;

    public abstract void writeScrollableFetch_(Section var1, int var2, int var3, long var4, boolean var6) throws SqlException;

    public abstract void readScrollableFetch_() throws SqlException;

    public abstract void writePositioningFetch_(Section var1, int var2, long var3) throws SqlException;

    public abstract void readPositioningFetch_() throws SqlException;

    public abstract void writeCursorClose_(Section var1) throws SqlException;

    public abstract void readCursorClose_() throws SqlException;

    protected abstract void parseRowset_() throws SqlException;

    public abstract void setFetchSize_(int var1);

    protected abstract void preClose_() throws SqlException;

    @Override
    public ConnectionCallbackInterface getConnectionCallbackInterface() {
        return this.connection_;
    }

    @Override
    public StatementCallbackInterface getStatementCallbackInterface() {
        return this.statement_;
    }

    public void expandRowsetSqlca() {
        if (this.isRowsetCursor_ && (this.rowsetSqlca_ == null || this.rowsetSqlca_.length < this.fetchSize_ + 2)) {
            this.rowsetSqlca_ = new Sqlca[this.fetchSize_ + 2];
        }
    }

    private final int checkRowsetSqlca() throws SqlException {
        return this.checkRowsetSqlca((int)this.currentRowInRowset_ + 1);
    }

    private final int checkRowsetSqlca(int row) throws SqlException {
        int sqlcode = 0;
        if (!this.isRowsetCursor_ || this.rowsetSqlca_ == null || this.rowsetSqlca_[row] == null) {
            return sqlcode;
        }
        Sqlca sqlca = this.rowsetSqlca_[row];
        if (sqlca != null) {
            sqlcode = sqlca.getSqlCode();
            if (sqlcode < 0) {
                throw new SqlException(this.agent_.logWriter_, sqlca);
            }
            if (sqlcode > 0 && sqlcode != 100 && sqlcode != 20237) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            }
        }
        return sqlcode;
    }

    private void resetRowsetFlags() {
        this.isBeforeFirst_ = false;
        this.isAfterLast_ = false;
        this.isFirst_ = false;
        this.isLast_ = false;
    }

    private void resetRowsetSqlca() {
        if (this.rowsetSqlca_ != null) {
            Arrays.fill(this.rowsetSqlca_, null);
        }
    }

    private CloseFilterInputStream createCloseFilterInputStream(InputStream is) throws SqlException {
        if (is == null) {
            return null;
        }
        if (this.currentStream == is) {
            return this.currentStream;
        }
        this.closeOpenStreams();
        this.currentStream = new CloseFilterInputStream(is);
        return this.currentStream;
    }

    private void closeOpenStreams() throws SqlException {
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException ioe) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), ioe, "java.io.IOException", ioe.getMessage());
            }
            this.currentStream = null;
        }
        if (this.currentReader != null) {
            try {
                this.currentReader.close();
            }
            catch (IOException ioe) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), ioe, "java.io.IOException", ioe.getMessage());
            }
            this.currentReader = null;
        }
    }

    private void useStreamOrLOB(int columnIndex) throws SqlException {
        this.checkLOBMultiCall(columnIndex);
        this.columnUsedFlags_[columnIndex - 1] = true;
    }

    private void checkLOBMultiCall(int columnIndex) throws SqlException {
        if (this.columnUsedFlags_ == null) {
            this.columnUsedFlags_ = new boolean[this.resultSetMetaData_.columns_];
        }
        if (this.columnUsedFlags_[columnIndex - 1]) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL18.S"), new Object[0]);
        }
    }

    private void unuseStreamsAndLOBs() {
        if (this.columnUsedFlags_ != null) {
            Arrays.fill(this.columnUsedFlags_, false);
        }
    }

    private SQLException jdbc3MethodNotSupported() {
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]).getSQLException();
    }

    @Override
    public final int getHoldability() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getHoldability", new Object[0]);
        }
        try {
            this.checkForClosedResultSet("getHoldability");
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getHoldability", this.resultSetHoldability_);
        }
        return this.resultSetHoldability_;
    }

    @Override
    public final boolean isClosed() throws SQLException {
        boolean isClosed;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "isClosed", new Object[0]);
        }
        boolean bl = isClosed = !this.openOnClient_;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", isClosed);
        }
        return isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateAsciiStream", columnIndex, x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateAsciiStream");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObjectFromCharacterStream(this.resultSetMetaData_.types_[columnIndex - 1], x, Cursor.ISO_8859_1, Integer.MIN_VALUE));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), length, Integer.MAX_VALUE).getSQLException();
        }
        this.updateAsciiStream(columnIndex, x, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBinaryStream", columnIndex, x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateBinaryStream");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObjectFromBinaryStream(this.resultSetMetaData_.types_[columnIndex - 1], x, Integer.MIN_VALUE));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), length, Integer.MAX_VALUE).getSQLException();
        }
        this.updateBinaryStream(columnIndex, x, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateBlob", columnIndex, x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateBlob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], new ClientBlob(this.agent_, x)));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            try {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateCharacterStream", columnIndex, reader);
                }
                this.checkUpdatePreconditions(columnIndex, "updateCharacterStream");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], reader, Integer.MIN_VALUE));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), length, Integer.MAX_VALUE).getSQLException();
        }
        this.updateCharacterStream(columnIndex, x, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateClob", columnIndex, reader);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateClob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], new ClientClob(this.agent_, reader)));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        try {
            this.updateAsciiStream(this.findColumnX(columnName, "updateAsciiStream"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        try {
            this.updateAsciiStream(this.findColumnX(columnName, "updateAsciiStream"), x, length);
        }
        catch (SqlException sqle) {
            throw sqle.getSQLException();
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumnX(columnLabel, "updateBinaryStream"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumnX(columnName, "updateBinaryStream"), x, length);
        }
        catch (SqlException sqle) {
            throw sqle.getSQLException();
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        try {
            this.updateBlob(this.findColumnX(columnLabel, "updateBlob"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        try {
            this.updateCharacterStream(this.findColumnX(columnLabel, "updateCharacterStream"), reader);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        try {
            this.updateCharacterStream(this.findColumnX(columnName, "updateCharacterStream"), reader, length);
        }
        catch (SqlException sqle) {
            throw sqle.getSQLException();
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        try {
            this.updateClob(this.findColumnX(columnLabel, "updateClob"), reader);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateClob", columnIndex, x, (int)length);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateClob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], new ClientClob(this.agent_, x, (int)length)));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    @Override
    public void updateClob(String columnName, Reader x, long length) throws SQLException {
        try {
            this.updateClob(this.findColumnX(columnName, "updateClob"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "updateClob", columnIndex, x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateClob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], x));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        try {
            this.updateClob(this.findColumnX(columnLabel, "updateClob"), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final void markLOBAsPublished(int index) {
        this.lobState.markAsPublished(index);
    }

    final void createLOBColumnTracker() {
        SanityManager.ASSERT((this.lobState == null ? 1 : 0) != 0, (String)"LOB state tracker already initialized.");
        if (this.connection_.supportsSessionDataCaching() && this.resultSetMetaData_.hasLobColumns()) {
            int columnCount = this.resultSetMetaData_.columns_;
            int lobCount = 0;
            int[] tmpIndexes = new int[columnCount];
            boolean[] tmpIsBlob = new boolean[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                int type = this.resultSetMetaData_.types_[i];
                if (type != 2004 && type != 2005) continue;
                tmpIndexes[lobCount] = i + 1;
                tmpIsBlob[lobCount++] = type == 2004;
            }
            int[] lobIndexes = new int[lobCount];
            boolean[] isBlob = new boolean[lobCount];
            System.arraycopy(tmpIndexes, 0, lobIndexes, 0, lobCount);
            System.arraycopy(tmpIsBlob, 0, isBlob, 0, lobCount);
            this.lobState = new LOBStateTracker(lobIndexes, isBlob, true);
        } else {
            this.lobState = LOBStateTracker.NO_OP_TRACKER;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(String)");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(int)");
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(String)");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (int)");
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (String)");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateRowId (int, RowId)");
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateRowId (String, RowId)");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNString (int, String)");
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNString (String, String)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNCharacterStream(int,Reader,long)");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNCharacterStream(String,Reader,long)");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob (int, NClob)");
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob (String, NClob)");
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNClob (int)");
    }

    @Override
    public NClob getNClob(String colName) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNClob (String)");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (int)");
    }

    @Override
    public SQLXML getSQLXML(String colName) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (String)");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateSQLXML (int, SQLXML)");
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateSQLXML (String, SQLXML)");
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        try {
            this.checkForClosedResultSet("isWrapperFor");
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return interfaces.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        try {
            this.checkForClosedResultSet("unwrap");
            return interfaces.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), interfaces).getSQLException();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob(int,Reader,long)");
    }

    public void updateNClob(String columnName, InputStream x, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob(String,InputStream,long)");
    }

    @Override
    public void updateNClob(String columnName, Reader x, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("updateNClob(String,Reader,long)");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            this.checkForClosedResultSet("getObject");
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getObject", columnIndex);
        }
        if (type == null) {
            throw this.mismatchException("NULL", columnIndex);
        }
        Object retval = String.class.equals(type) ? this.getString(columnIndex) : (BigDecimal.class.equals(type) ? this.getBigDecimal(columnIndex) : (Boolean.class.equals(type) ? Boolean.valueOf(this.getBoolean(columnIndex)) : (Byte.class.equals(type) ? Byte.valueOf(this.getByte(columnIndex)) : (Short.class.equals(type) ? Short.valueOf(this.getShort(columnIndex)) : (Integer.class.equals(type) ? Integer.valueOf(this.getInt(columnIndex)) : (Long.class.equals(type) ? Long.valueOf(this.getLong(columnIndex)) : (Float.class.equals(type) ? Float.valueOf(this.getFloat(columnIndex)) : (Double.class.equals(type) ? Double.valueOf(this.getDouble(columnIndex)) : (Date.class.equals(type) ? this.getDate(columnIndex) : (Time.class.equals(type) ? this.getTime(columnIndex) : (Timestamp.class.equals(type) ? this.getTimestamp(columnIndex) : (Blob.class.equals(type) ? this.getBlob(columnIndex) : (Clob.class.equals(type) ? this.getClob(columnIndex) : (type.isArray() && type.getComponentType().equals(Byte.TYPE) ? (Object)this.getBytes(columnIndex) : this.getObject(columnIndex)))))))))))))));
        if (this.wasNull()) {
            retval = null;
        }
        if (retval == null || type.isInstance(retval)) {
            return type.cast(retval);
        }
        throw this.mismatchException(type.getName(), columnIndex);
    }

    private SQLException mismatchException(String targetTypeName, int columnIndex) throws SQLException {
        String sourceTypeName = this.getMetaData().getColumnTypeName(columnIndex);
        ClientMessageId cmi = new ClientMessageId("22005");
        SqlException se = new SqlException(this.agent_.logWriter_, cmi, targetTypeName, sourceTypeName);
        return se.getSQLException();
    }

    @Override
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getObject", columnName);
            }
            return this.getObject(this.findColumnX(columnName, "getObject"), type);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }
}

