/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.util.Properties;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.error.StandardException;

class BackingStoreHashTableFromScan
extends BackingStoreHashtable {
    private ScanManager open_scan;
    private boolean includeRowLocations;

    public BackingStoreHashTableFromScan(TransactionController tc, long conglomId, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, long max_rowcnt, int[] key_column_numbers, boolean remove_duplicates, long estimated_rowcnt, long max_inmemory_rowcnt, int initialCapacity, float loadFactor, boolean collect_runtimestats, boolean skipNullKeyColumns, boolean keepAfterCommit, boolean includeRowLocations) throws StandardException {
        super(tc, null, key_column_numbers, remove_duplicates, estimated_rowcnt, max_inmemory_rowcnt, initialCapacity, loadFactor, skipNullKeyColumns, keepAfterCommit);
        this.includeRowLocations = includeRowLocations;
        this.open_scan = (ScanManager)tc.openScan(conglomId, false, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator);
        this.open_scan.fetchSet(max_rowcnt, key_column_numbers, this);
        if (collect_runtimestats) {
            Properties prop = new Properties();
            this.open_scan.getScanInfo().getAllScanInfo(prop);
            this.setAuxillaryRuntimeStats(prop);
            prop = null;
        }
    }

    @Override
    public boolean includeRowLocations() {
        return this.includeRowLocations;
    }

    @Override
    public void close() throws StandardException {
        this.open_scan.close();
        super.close();
    }
}

