/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricExt;
import org.logstash.instrument.metrics.NullMetricExt;

@JRubyClass(name={"NamespacedNullMetric"}, parent="AbstractNamespacedMetric")
public final class NullNamespacedMetricExt
extends AbstractNamespacedMetricExt {
    private static final long serialVersionUID = 1L;
    private static final RubySymbol NULL = RubyUtil.RUBY.newSymbol("null");
    private RubyArray namespaceName;
    private NullMetricExt metric;

    public static AbstractNamespacedMetricExt create(NullMetricExt metric, RubyArray namespaceName) {
        NullNamespacedMetricExt res = new NullNamespacedMetricExt(RubyUtil.RUBY, RubyUtil.NULL_NAMESPACED_METRIC_CLASS);
        res.metric = metric;
        res.namespaceName = namespaceName;
        return res;
    }

    public NullNamespacedMetricExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(optional=2)
    public NullNamespacedMetricExt initialize(ThreadContext context, IRubyObject[] args) {
        this.metric = args.length > 0 && !args[0].isNil() && args[0] instanceof NullMetricExt ? (NullMetricExt)args[0] : new NullMetricExt(context.runtime, this.metaClass);
        RubySymbol namespaceName = args.length == 2 ? args[1] : NULL;
        this.namespaceName = namespaceName instanceof RubyArray ? (RubyArray)namespaceName : RubyArray.newArray((Ruby)context.runtime, (IRubyObject)namespaceName);
        return this;
    }

    @Override
    protected IRubyObject getCollector(ThreadContext context) {
        return this.metric.collector(context);
    }

    @Override
    protected IRubyObject getCounter(ThreadContext context, IRubyObject key) {
        return NullCounter.INSTANCE;
    }

    @Override
    protected IRubyObject getGauge(ThreadContext context, IRubyObject key, IRubyObject value) {
        return context.nil;
    }

    @Override
    protected IRubyObject getTimer(ThreadContext context, IRubyObject key) {
        return this.metric.getTimer(context, (IRubyObject)this.namespaceName, key);
    }

    @Override
    protected IRubyObject doIncrement(ThreadContext context, IRubyObject[] args) {
        return context.nil;
    }

    @Override
    protected IRubyObject doDecrement(ThreadContext context, IRubyObject[] args) {
        return context.nil;
    }

    @Override
    protected IRubyObject doTime(ThreadContext context, IRubyObject key, Block block) {
        return this.metric.time(context, (IRubyObject)this.namespaceName, key, block);
    }

    @Override
    protected IRubyObject doReportTime(ThreadContext context, IRubyObject key, IRubyObject duration) {
        return context.nil;
    }

    @Override
    protected RubyArray getNamespaceName(ThreadContext context) {
        return this.namespaceName;
    }

    @Override
    protected AbstractNamespacedMetricExt createNamespaced(ThreadContext context, IRubyObject name) {
        MetricExt.validateName(context, name, RubyUtil.METRIC_NO_NAMESPACE_PROVIDED_CLASS);
        return NullNamespacedMetricExt.create(this.metric, (RubyArray)this.namespaceName.op_plus((IRubyObject)(name instanceof RubyArray ? name : RubyArray.newArray((Ruby)context.runtime, (IRubyObject)name))));
    }

    @Override
    public AbstractMetricExt getMetric() {
        return this.metric;
    }

    @JRubyClass(name={"NullCounter"})
    public static final class NullCounter
    extends RubyObject {
        private static final long serialVersionUID = 1L;
        public static final NullCounter INSTANCE = new NullCounter(RubyUtil.RUBY, RubyUtil.NULL_COUNTER_CLASS);

        public NullCounter(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public IRubyObject increment(ThreadContext context, IRubyObject value) {
            return context.nil;
        }
    }
}

