/*
 * Decompiled with CFR 0.152.
 */
package org.nio4r;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.nio4r.ByteBuffer;
import org.nio4r.Monitor;
import org.nio4r.Selector;

public class Nio4r
implements Library {
    private Ruby ruby;

    public void load(Ruby ruby, boolean bl) {
        this.ruby = ruby;
        RubyModule rubyModule = ruby.defineModule("NIO");
        RubyClass rubyClass = ruby.defineClassUnder("Selector", ruby.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new Selector(ruby, rubyClass);
            }
        }, rubyModule);
        rubyClass.defineAnnotatedMethods(Selector.class);
        RubyClass rubyClass2 = ruby.defineClassUnder("Monitor", ruby.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new Monitor(ruby, rubyClass);
            }
        }, rubyModule);
        rubyClass2.defineAnnotatedMethods(Monitor.class);
        RubyClass rubyClass3 = ruby.defineClassUnder("ByteBuffer", ruby.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new ByteBuffer(ruby, rubyClass);
            }
        }, rubyModule);
        rubyClass3.defineAnnotatedMethods(ByteBuffer.class);
        rubyClass3.includeModule((IRubyObject)ruby.getEnumerable());
        ruby.defineClassUnder("OverflowError", ruby.getIOError(), ruby.getIOError().getAllocator(), (RubyModule)rubyClass3);
        ruby.defineClassUnder("UnderflowError", ruby.getIOError(), ruby.getIOError().getAllocator(), (RubyModule)rubyClass3);
        ruby.defineClassUnder("MarkUnsetError", ruby.getIOError(), ruby.getIOError().getAllocator(), (RubyModule)rubyClass3);
    }

    public static int symbolToInterestOps(Ruby ruby, SelectableChannel selectableChannel, IRubyObject iRubyObject) {
        if (iRubyObject == ruby.newSymbol("r")) {
            if ((selectableChannel.validOps() & 0x10) != 0) {
                return 16;
            }
            return 1;
        }
        if (iRubyObject == ruby.newSymbol("w")) {
            if (selectableChannel instanceof SocketChannel && !((SocketChannel)selectableChannel).isConnected()) {
                return 8;
            }
            return 4;
        }
        if (iRubyObject == ruby.newSymbol("rw")) {
            int n = 0;
            if ((selectableChannel.validOps() & 0x11) != 0) {
                n |= Nio4r.symbolToInterestOps(ruby, selectableChannel, (IRubyObject)ruby.newSymbol("r"));
            }
            if ((selectableChannel.validOps() & 0xC) != 0) {
                n |= Nio4r.symbolToInterestOps(ruby, selectableChannel, (IRubyObject)ruby.newSymbol("w"));
            }
            return n;
        }
        throw ruby.newArgumentError("invalid interest type: " + String.valueOf(iRubyObject));
    }

    public static IRubyObject interestOpsToSymbol(Ruby ruby, int n) {
        switch (n) {
            case 1: 
            case 16: {
                return ruby.newSymbol("r");
            }
            case 4: 
            case 8: {
                return ruby.newSymbol("w");
            }
            case 5: 
            case 9: {
                return ruby.newSymbol("rw");
            }
            case 0: {
                return ruby.getNil();
            }
        }
        throw ruby.newArgumentError("unknown interest op combination");
    }
}

