/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaVersionFetcher;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSchemaProvider
implements SchemaProvider {
    private SchemaVersionFetcher schemaVersionFetcher;

    @Override
    public void configure(Map<String, ?> configs) {
        this.schemaVersionFetcher = (SchemaVersionFetcher)configs.get("schemaVersionFetcher");
    }

    public SchemaVersionFetcher schemaVersionFetcher() {
        return this.schemaVersionFetcher;
    }

    protected Map<String, String> resolveReferences(List<SchemaReference> references) {
        if (references == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        HashSet<String> visited = new HashSet<String>();
        this.resolveReferences(references, result, visited);
        return result;
    }

    private void resolveReferences(List<SchemaReference> references, Map<String, String> schemas, Set<String> visited) {
        for (SchemaReference reference : references) {
            if (reference.getName() == null || reference.getSubject() == null || reference.getVersion() == null) {
                throw new IllegalStateException("Invalid reference: " + reference);
            }
            if (visited.contains(reference.getName())) continue;
            visited.add(reference.getName());
            String subject = reference.getSubject();
            if (schemas.containsKey(reference.getName())) continue;
            Schema schema = this.schemaVersionFetcher().getByVersion(subject, reference.getVersion(), true);
            if (schema == null) {
                throw new IllegalStateException("No schema reference found for subject \"" + subject + "\" and version " + reference.getVersion());
            }
            if (reference.getVersion() == -1) {
                reference.setVersion(schema.getVersion());
            }
            this.resolveReferences(schema.getReferences(), schemas, visited);
            schemas.put(reference.getName(), schema.getSchema());
        }
    }
}

