/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.kafka.common.errors.SerializationException;

public class NonRecordContainer
implements GenericContainer {
    private final Schema schema;
    private final Object value;

    public NonRecordContainer(Schema schema, Object value) {
        if (schema == null) {
            throw new SerializationException("Schema may not be null.");
        }
        this.schema = schema;
        this.value = value;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonRecordContainer that = (NonRecordContainer)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.value);
    }
}

