/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH128_canonical_t")
public class XXH128Canonical
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    public XXH128Canonical(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH128Canonical.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[16]")
    public ByteBuffer digest() {
        return XXH128Canonical.ndigest(this.address());
    }

    @NativeType(value="unsigned char")
    public byte digest(int index) {
        return XXH128Canonical.ndigest(this.address(), index);
    }

    public static XXH128Canonical malloc() {
        return (XXH128Canonical)XXH128Canonical.wrap(XXH128Canonical.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XXH128Canonical calloc() {
        return (XXH128Canonical)XXH128Canonical.wrap(XXH128Canonical.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XXH128Canonical create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XXH128Canonical)XXH128Canonical.wrap(XXH128Canonical.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XXH128Canonical create(long address) {
        return (XXH128Canonical)XXH128Canonical.wrap(XXH128Canonical.class, (long)address);
    }

    @Nullable
    public static XXH128Canonical createSafe(long address) {
        return address == 0L ? null : (XXH128Canonical)XXH128Canonical.wrap(XXH128Canonical.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XXH128Canonical.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XXH128Canonical.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XXH128Canonical.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH128Canonical.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XXH128Canonical.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XXH128Canonical.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XXH128Canonical.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static XXH128Canonical mallocStack() {
        return XXH128Canonical.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH128Canonical callocStack() {
        return XXH128Canonical.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH128Canonical mallocStack(MemoryStack stack) {
        return XXH128Canonical.malloc(stack);
    }

    @Deprecated
    public static XXH128Canonical callocStack(MemoryStack stack) {
        return XXH128Canonical.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH128Canonical.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH128Canonical.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH128Canonical.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH128Canonical.calloc(capacity, stack);
    }

    public static XXH128Canonical malloc(MemoryStack stack) {
        return (XXH128Canonical)XXH128Canonical.wrap(XXH128Canonical.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH128Canonical calloc(MemoryStack stack) {
        return (XXH128Canonical)XXH128Canonical.wrap(XXH128Canonical.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XXH128Canonical.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XXH128Canonical.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DIGEST), (int)16);
    }

    public static byte ndigest(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DIGEST + Checks.check((int)index, (int)16) * 1L);
    }

    static {
        Struct.Layout layout = XXH128Canonical.__struct((Struct.Member[])new Struct.Member[]{XXH128Canonical.__array((int)1, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH128Canonical, Buffer>
    implements NativeResource {
        private static final XXH128Canonical ELEMENT_FACTORY = XXH128Canonical.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XXH128Canonical getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[16]")
        public ByteBuffer digest() {
            return XXH128Canonical.ndigest(this.address());
        }

        @NativeType(value="unsigned char")
        public byte digest(int index) {
            return XXH128Canonical.ndigest(this.address(), index);
        }
    }
}

