/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPassthroughLayerFB;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrTriangleMeshFB;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGeometryInstanceCreateInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYER;
    public static final int MESH;
    public static final int BASESPACE;
    public static final int POSE;
    public static final int SCALE;

    public XrGeometryInstanceCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrGeometryInstanceCreateInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGeometryInstanceCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGeometryInstanceCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrPassthroughLayerFB")
    public long layer() {
        return XrGeometryInstanceCreateInfoFB.nlayer(this.address());
    }

    @NativeType(value="XrTriangleMeshFB")
    public long mesh() {
        return XrGeometryInstanceCreateInfoFB.nmesh(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrGeometryInstanceCreateInfoFB.nbaseSpace(this.address());
    }

    public XrPosef pose() {
        return XrGeometryInstanceCreateInfoFB.npose(this.address());
    }

    public XrVector3f scale() {
        return XrGeometryInstanceCreateInfoFB.nscale(this.address());
    }

    public XrGeometryInstanceCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrGeometryInstanceCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrGeometryInstanceCreateInfoFB type$Default() {
        return this.type(1000118004);
    }

    public XrGeometryInstanceCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrGeometryInstanceCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrGeometryInstanceCreateInfoFB layer(XrPassthroughLayerFB value) {
        XrGeometryInstanceCreateInfoFB.nlayer(this.address(), value);
        return this;
    }

    public XrGeometryInstanceCreateInfoFB mesh(XrTriangleMeshFB value) {
        XrGeometryInstanceCreateInfoFB.nmesh(this.address(), value);
        return this;
    }

    public XrGeometryInstanceCreateInfoFB baseSpace(XrSpace value) {
        XrGeometryInstanceCreateInfoFB.nbaseSpace(this.address(), value);
        return this;
    }

    public XrGeometryInstanceCreateInfoFB pose(XrPosef value) {
        XrGeometryInstanceCreateInfoFB.npose(this.address(), value);
        return this;
    }

    public XrGeometryInstanceCreateInfoFB pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrGeometryInstanceCreateInfoFB scale(XrVector3f value) {
        XrGeometryInstanceCreateInfoFB.nscale(this.address(), value);
        return this;
    }

    public XrGeometryInstanceCreateInfoFB scale(Consumer<XrVector3f> consumer) {
        consumer.accept(this.scale());
        return this;
    }

    public XrGeometryInstanceCreateInfoFB set(int type, long next, XrPassthroughLayerFB layer, XrTriangleMeshFB mesh, XrSpace baseSpace, XrPosef pose, XrVector3f scale) {
        this.type(type);
        this.next(next);
        this.layer(layer);
        this.mesh(mesh);
        this.baseSpace(baseSpace);
        this.pose(pose);
        this.scale(scale);
        return this;
    }

    public XrGeometryInstanceCreateInfoFB set(XrGeometryInstanceCreateInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrGeometryInstanceCreateInfoFB malloc() {
        return (XrGeometryInstanceCreateInfoFB)XrGeometryInstanceCreateInfoFB.wrap(XrGeometryInstanceCreateInfoFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrGeometryInstanceCreateInfoFB calloc() {
        return (XrGeometryInstanceCreateInfoFB)XrGeometryInstanceCreateInfoFB.wrap(XrGeometryInstanceCreateInfoFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrGeometryInstanceCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrGeometryInstanceCreateInfoFB)XrGeometryInstanceCreateInfoFB.wrap(XrGeometryInstanceCreateInfoFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrGeometryInstanceCreateInfoFB create(long address) {
        return (XrGeometryInstanceCreateInfoFB)XrGeometryInstanceCreateInfoFB.wrap(XrGeometryInstanceCreateInfoFB.class, (long)address);
    }

    @Nullable
    public static XrGeometryInstanceCreateInfoFB createSafe(long address) {
        return address == 0L ? null : (XrGeometryInstanceCreateInfoFB)XrGeometryInstanceCreateInfoFB.wrap(XrGeometryInstanceCreateInfoFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrGeometryInstanceCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrGeometryInstanceCreateInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrGeometryInstanceCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGeometryInstanceCreateInfoFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrGeometryInstanceCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrGeometryInstanceCreateInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrGeometryInstanceCreateInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrGeometryInstanceCreateInfoFB malloc(MemoryStack stack) {
        return (XrGeometryInstanceCreateInfoFB)XrGeometryInstanceCreateInfoFB.wrap(XrGeometryInstanceCreateInfoFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGeometryInstanceCreateInfoFB calloc(MemoryStack stack) {
        return (XrGeometryInstanceCreateInfoFB)XrGeometryInstanceCreateInfoFB.wrap(XrGeometryInstanceCreateInfoFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGeometryInstanceCreateInfoFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGeometryInstanceCreateInfoFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nlayer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LAYER));
    }

    public static long nmesh(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MESH));
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE));
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrVector3f nscale(long struct) {
        return XrVector3f.create(struct + (long)SCALE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlayer(long struct, XrPassthroughLayerFB value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LAYER), (long)value.address());
    }

    public static void nmesh(long struct, XrTriangleMeshFB value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MESH), (long)value.address());
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASESPACE), (long)value.address());
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void nscale(long struct, XrVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SCALE), (long)XrVector3f.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)LAYER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MESH)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE)));
    }

    static {
        Struct.Layout layout = XrGeometryInstanceCreateInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrGeometryInstanceCreateInfoFB.__member((int)4), XrGeometryInstanceCreateInfoFB.__member((int)POINTER_SIZE), XrGeometryInstanceCreateInfoFB.__member((int)POINTER_SIZE), XrGeometryInstanceCreateInfoFB.__member((int)POINTER_SIZE), XrGeometryInstanceCreateInfoFB.__member((int)POINTER_SIZE), XrGeometryInstanceCreateInfoFB.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrGeometryInstanceCreateInfoFB.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYER = layout.offsetof(2);
        MESH = layout.offsetof(3);
        BASESPACE = layout.offsetof(4);
        POSE = layout.offsetof(5);
        SCALE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrGeometryInstanceCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrGeometryInstanceCreateInfoFB ELEMENT_FACTORY = XrGeometryInstanceCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrGeometryInstanceCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGeometryInstanceCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGeometryInstanceCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrPassthroughLayerFB")
        public long layer() {
            return XrGeometryInstanceCreateInfoFB.nlayer(this.address());
        }

        @NativeType(value="XrTriangleMeshFB")
        public long mesh() {
            return XrGeometryInstanceCreateInfoFB.nmesh(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrGeometryInstanceCreateInfoFB.nbaseSpace(this.address());
        }

        public XrPosef pose() {
            return XrGeometryInstanceCreateInfoFB.npose(this.address());
        }

        public XrVector3f scale() {
            return XrGeometryInstanceCreateInfoFB.nscale(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGeometryInstanceCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118004);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGeometryInstanceCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer layer(XrPassthroughLayerFB value) {
            XrGeometryInstanceCreateInfoFB.nlayer(this.address(), value);
            return this;
        }

        public Buffer mesh(XrTriangleMeshFB value) {
            XrGeometryInstanceCreateInfoFB.nmesh(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrGeometryInstanceCreateInfoFB.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrGeometryInstanceCreateInfoFB.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer scale(XrVector3f value) {
            XrGeometryInstanceCreateInfoFB.nscale(this.address(), value);
            return this;
        }

        public Buffer scale(Consumer<XrVector3f> consumer) {
            consumer.accept(this.scale());
            return this;
        }
    }
}

