/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.ui.browser;

import javax.servlet.http.Cookie;
import org.directwebremoting.ScriptSessions;
import org.directwebremoting.util.JavascriptUtil;

public class Document {
    public static void setCookie(String name, String value) {
        ScriptSessions.addScript("document.cookie = \"" + JavascriptUtil.escapeJavaScript(name) + "=" + JavascriptUtil.escapeJavaScript(value) + "\"");
    }

    public static void setCookie(Cookie cookie) {
        String name = JavascriptUtil.escapeJavaScript(cookie.getName());
        String value = JavascriptUtil.escapeJavaScript(cookie.getValue());
        String domain = cookie.getDomain() == null ? "" : ";domain=" + JavascriptUtil.escapeJavaScript(cookie.getDomain());
        String path = cookie.getPath() == null ? "" : ";path=" + JavascriptUtil.escapeJavaScript(cookie.getPath());
        String maxAge = cookie.getMaxAge() == -1 ? "" : ";max-age=" + cookie.getMaxAge();
        String secure = !cookie.getSecure() ? "" : ";secure=true";
        ScriptSessions.addScript("document.cookie = \"" + name + "=" + value + domain + path + maxAge + secure + "\"");
    }

    public static void setTitle(String title) {
        ScriptSessions.addScript("document.title = '" + JavascriptUtil.escapeJavaScript(title) + "';");
    }
}

