/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.internal.extension;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.AddonService;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.ConsoleCommandCompleter;
import org.openhab.core.io.console.StringsCompleter;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={ConsoleCommandExtension.class})
@NonNullByDefault
public class AddonConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_SERVICES = "services";
    private static final String SUBCMD_INSTALL = "install";
    private static final String SUBCMD_UNINSTALL = "uninstall";
    private static final StringsCompleter SUBCMD_COMPLETER = new StringsCompleter(List.of("list", "services", "install", "uninstall"), false);
    private final Map<String, AddonService> addonServices = new ConcurrentHashMap<String, AddonService>();

    @Activate
    public AddonConsoleCommandExtension() {
        super("addons", "Manage add-ons.");
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindAddonService(AddonService addonService) {
        this.addonServices.put(addonService.getId(), addonService);
    }

    public void unbindAddonService(AddonService addonService) {
        this.addonServices.remove(addonService.getId());
    }

    @Override
    public List<String> getUsages() {
        return List.of(this.buildCommandUsage(SUBCMD_SERVICES, "list all available add-on services"), this.buildCommandUsage("list [<serviceId>]", "lists names of all add-ons (from the named service, if given)"), this.buildCommandUsage("install <addonUid>", "installs the given add-on"), this.buildCommandUsage("uninstall <addonUid>", "uninstalls the given add-on"));
    }

    @Override
    public void execute(String[] args, Console console) {
        block20: {
            block18: {
                String subCommand;
                if (args.length <= 0) break block18;
                switch (subCommand = args[0]) {
                    case "services": {
                        this.listServices(console);
                        break;
                    }
                    case "list": {
                        this.listAddons(console, args.length < 2 ? "" : args[1]);
                        break;
                    }
                    case "install": {
                        if (args.length == 2) {
                            this.installAddon(console, args[1]);
                            break;
                        }
                        console.println("Specify the UID of the add-on to install: " + this.getCommand() + " install <addonUid>");
                        break;
                    }
                    case "uninstall": {
                        if (args.length == 2) {
                            this.uninstallAddon(console, args[1]);
                            break;
                        }
                        console.println("Specify the UID of the add-on to uninstall: " + this.getCommand() + " uninstall <addonUid>");
                        break;
                    }
                    default: {
                        console.println("Unknown command '" + subCommand + "'");
                        this.printUsage(console);
                        break;
                    }
                }
                break block20;
            }
            this.printUsage(console);
        }
    }

    @Override
    public @Nullable ConsoleCommandCompleter getCompleter() {
        return new AddonConsoleCommandCompleter();
    }

    private void listServices(Console console) {
        this.addonServices.values().forEach(s -> console.println(String.format("%-20s %s", s.getId(), s.getName())));
    }

    private void listAddons(Console console, String serviceId) {
        List addons;
        if (serviceId.isBlank()) {
            addons = this.addonServices.values().stream().map(s -> s.getAddons(null)).flatMap(Collection::stream).toList();
        } else {
            AddonService service = this.addonServices.get(serviceId);
            if (service == null) {
                console.println("Add-on service '" + serviceId + "' is not known.");
                return;
            }
            addons = service.getAddons(null);
        }
        addons.forEach(addon -> console.println(String.format("%s %-45s %-20s %s", addon.isInstalled() ? "i" : " ", addon.getUid(), addon.getVersion().isBlank() ? "not set" : addon.getVersion(), addon.getLabel())));
    }

    private void installAddon(Console console, String addonUid) {
        String[] parts = addonUid.split(":");
        String serviceId = parts.length == 2 ? parts[0] : "karaf";
        String addonId = parts.length == 2 ? parts[1] : parts[0];
        AddonService service = this.addonServices.get(serviceId);
        if (service == null) {
            console.println("Could not find requested add-on service. Add-on " + addonUid + " not installed.");
        } else {
            Addon addon = service.getAddon(addonId, null);
            if (addon == null) {
                console.println("Could not find add-on in add-on service. Add-on " + addonUid + " not installed.");
            } else if (addon.isInstalled()) {
                console.println("Add-on " + addonUid + " is already installed.");
            } else {
                service.install(addonId);
                console.println("Installed " + addonUid + ".");
            }
        }
    }

    private void uninstallAddon(Console console, String addonUid) {
        String[] parts = addonUid.split(":");
        String serviceId = parts.length == 2 ? parts[0] : "karaf";
        String addonId = parts.length == 2 ? parts[1] : parts[0];
        AddonService service = this.addonServices.get(serviceId);
        if (service == null) {
            console.println("Could not find requested add-on service. Add-on " + addonUid + " not uninstalled.");
        } else {
            Addon addon = service.getAddon(addonId, null);
            if (addon == null) {
                console.println("Could not find add-on in add-on service. Add-on " + addonUid + " not uninstalled.");
            } else if (!addon.isInstalled()) {
                console.println("Add-on " + addonUid + " is not installed.");
            } else {
                service.uninstall(addonId);
                console.println("Uninstalled " + addonUid + ".");
            }
        }
    }

    private class AddonConsoleCommandCompleter
    implements ConsoleCommandCompleter {
        private AddonConsoleCommandCompleter() {
        }

        @Override
        public boolean complete(String[] args, int cursorArgumentIndex, int cursorPosition, List<String> candidates) {
            if (cursorArgumentIndex <= 0) {
                return SUBCMD_COMPLETER.complete(args, cursorArgumentIndex, cursorPosition, candidates);
            }
            return false;
        }
    }
}

