/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import java.util.Map;
import lombok.Generated;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.KNNMethod;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.util.EngineSpecificMethodContext;
import org.opensearch.knn.index.util.KNNLibrary;
import org.opensearch.knn.training.VectorSpaceInfo;

public abstract class AbstractKNNLibrary
implements KNNLibrary {
    protected final Map<String, KNNMethod> methods;
    protected final Map<String, EngineSpecificMethodContext> engineMethods;
    protected final String version;

    @Override
    public KNNMethod getMethod(String methodName) {
        KNNMethod method = this.methods.get(methodName);
        if (method == null) {
            throw new IllegalArgumentException(String.format("Invalid method name: %s", methodName));
        }
        return method;
    }

    @Override
    public EngineSpecificMethodContext getMethodContext(String methodName) {
        EngineSpecificMethodContext method = this.engineMethods.get(methodName);
        if (method == null) {
            throw new IllegalArgumentException(String.format("Invalid method name: %s", methodName));
        }
        return method;
    }

    @Override
    public ValidationException validateMethod(KNNMethodContext knnMethodContext) {
        String methodName = knnMethodContext.getMethodComponentContext().getName();
        return this.getMethod(methodName).validate(knnMethodContext);
    }

    @Override
    public ValidationException validateMethodWithData(KNNMethodContext knnMethodContext, VectorSpaceInfo vectorSpaceInfo) {
        String methodName = knnMethodContext.getMethodComponentContext().getName();
        return this.getMethod(methodName).validateWithData(knnMethodContext, vectorSpaceInfo);
    }

    @Override
    public boolean isTrainingRequired(KNNMethodContext knnMethodContext) {
        String methodName = knnMethodContext.getMethodComponentContext().getName();
        return this.getMethod(methodName).isTrainingRequired(knnMethodContext);
    }

    @Override
    public Map<String, Object> getMethodAsMap(KNNMethodContext knnMethodContext) {
        KNNMethod knnMethod = this.methods.get(knnMethodContext.getMethodComponentContext().getName());
        if (knnMethod == null) {
            throw new IllegalArgumentException(String.format("Invalid method name: %s", knnMethodContext.getMethodComponentContext().getName()));
        }
        return knnMethod.getAsMap(knnMethodContext);
    }

    @Generated
    AbstractKNNLibrary(Map<String, KNNMethod> methods, Map<String, EngineSpecificMethodContext> engineMethods, String version) {
        this.methods = methods;
        this.engineMethods = engineMethods;
        this.version = version;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }
}

