/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.script;

import java.math.BigInteger;
import java.util.Base64;
import java.util.List;
import org.opensearch.index.mapper.BinaryFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.knn.common.KNNValidationUtil;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.plugin.stats.KNNCounter;

public class KNNScoringSpaceUtil {
    public static boolean isLongFieldType(MappedFieldType fieldType) {
        return fieldType instanceof NumberFieldMapper.NumberFieldType && ((NumberFieldMapper.NumberFieldType)fieldType).numericType() == NumberFieldMapper.NumberType.LONG.numericType();
    }

    public static boolean isBinaryFieldType(MappedFieldType fieldType) {
        return fieldType instanceof BinaryFieldMapper.BinaryFieldType;
    }

    public static boolean isKNNVectorFieldType(MappedFieldType fieldType) {
        return fieldType instanceof KNNVectorFieldMapper.KNNVectorFieldType;
    }

    public static boolean isBinaryVectorDataType(KNNVectorFieldMapper.KNNVectorFieldType fieldType) {
        return VectorDataType.BINARY == fieldType.getVectorDataType();
    }

    public static Long parseToLong(Object object) {
        if (object instanceof Integer) {
            return (long)((Integer)object);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new IllegalArgumentException("Object cannot be parsed as a Long.");
    }

    public static BigInteger parseToBigInteger(Object object) {
        return new BigInteger(1, Base64.getDecoder().decode((String)object));
    }

    public static float[] parseToFloatArray(Object object, int expectedVectorLength, VectorDataType vectorDataType) {
        float[] floatArray = KNNScoringSpaceUtil.convertVectorToPrimitive(object, vectorDataType);
        if (expectedVectorLength != floatArray.length) {
            KNNCounter.SCRIPT_QUERY_ERRORS.increment();
            throw new IllegalStateException("Object's length=" + floatArray.length + " does not match the expected length=" + expectedVectorLength + ".");
        }
        return floatArray;
    }

    public static float[] convertVectorToPrimitive(Object vector, VectorDataType vectorDataType) {
        float[] primitiveVector = null;
        if (vector != null) {
            List tmp = (List)vector;
            primitiveVector = new float[tmp.size()];
            for (int i = 0; i < primitiveVector.length; ++i) {
                float value = ((Number)tmp.get(i)).floatValue();
                if (VectorDataType.BYTE == vectorDataType || VectorDataType.BINARY == vectorDataType) {
                    KNNValidationUtil.validateByteVectorValue(value, vectorDataType);
                }
                primitiveVector[i] = value;
            }
        }
        return primitiveVector;
    }

    public static float getVectorMagnitudeSquared(float[] inputVector) {
        if (null == inputVector) {
            throw new IllegalStateException("vector magnitude cannot be evaluated as it is null");
        }
        float normInputVector = 0.0f;
        for (int i = 0; i < inputVector.length; ++i) {
            normInputVector += inputVector[i] * inputVector[i];
        }
        return normInputVector;
    }
}

